local STR = MG_CarDealer.TunerElement_CreateStruct("rear_light")
STR.PrintName = "Modifiziertes Rücklicht"
STR.Icon = "asterisk_yellow"
STR.Max = 2

local VAR = STR:AddVars("Position_X", "number")
VAR.Min = -100
VAR.Max = 100
local VAR = STR:AddVars("Position_Y", "number")
VAR.Min = -150
VAR.Max = 150
local VAR = STR:AddVars("Position_Z", "number")
VAR.Min = -100
VAR.Max = 100
VAR.StartValue = 50
local VAR = STR:AddVars("Skala", "number")
VAR.Min = 10
VAR.Max = 100
VAR.StartValue = 50

function STR:SV_Think(tunesys)
	local driver = tunesys:GetDriver()
	if IsValid(driver) and (driver:KeyDown(IN_JUMP) or driver:KeyDown(IN_BACK)) then
		tunesys:SetNW2Bool("RearLight", true)
	else
		tunesys:SetNW2Bool("RearLight", false)
	end
end

local MAT_LIGHT = Material("sprites/gmdm_pickups/light")
function STR:Render(tunesys, vars)
	local m = 1
	if tunesys:GetNW2Bool("RearLight") then
		m = 1.5
	end
	local pos = tunesys:GetPos()
	local ang = tunesys:GetAngles()
	pos = pos + ang:Forward() * vars["Position_X"]
	pos = pos + ang:Right() * vars["Position_Y"]
	pos = pos + ang:Up() * vars["Position_Z"]	
	render.SetMaterial(MAT_LIGHT)
	local angk = EyeAngles():Forward() * -1
	local angd = MG_CarDealer.Get3DWorldCamAngle()
	if angd then
		angk = angd:Forward()
	end
	local scale = vars["Skala"]
	render.DrawQuadEasy(pos, angk, scale * m, scale * m, Color(255, 0, 0, 255), 90) 
end

TunerElement.Register(STR)