local Entity = FindMetaTable("Entity")

function Entity:WCR_SetChannel(chan)
	self:SetNW2Int("wcr_chan", chan)
end

function Entity:WCR_GetChannel()
	return self:GetNW2Int("wcr_chan")
end

local blacklist = {
	["models/tdmcars/por_tricycle.mdl"] = true,
}

function Entity:WCR_IsCarEntity()
	if !self:IsVehicle() or IsValid(self:GetParent()) then return false end
	if blacklist[self:GetModel()] then return false end
	local cls = self:GetClass()
	return cls == "prop_vehicle_airboat" or cls == "prop_vehicle_jeep" or cls == "prop_vehicle_jeep_old"
end

function Entity:WCR_GetCarEntity()
	if !self:IsValid() or blacklist[self:GetModel()] then return NULL end
	local cls = self:GetClass()
	if cls == "prop_vehicle_prisoner_pod" and !self:GetParent():IsVehicle() then return NULL end
	if cls != "prop_vehicle_jeep" then
		local par = self:GetParent()
		if par:IsValid() then
			return par
		end
	end
	return self
end

function Entity:WCR_IsCarHealthy()
	local health = self.VC_getHealth and self:VC_getHealth(true)
	if health and health <= 0 then
		return false
	end
	return true
end

function Entity:WCR_HasRadioCapability()
	return self:WCR_IsCarHealthy()
end