local function isTracked(cls)
	return cls == "prop_vehicle_jeep" or cls == "prop_vehicle_jeep_old"
end

local carents = setmetatable({}, {__mode = "v"})
hook.Add(SERVER and "OnEntityCreated" or "NetworkEntityCreated", "CarRadio_CarTracker", function(e)
	if isTracked(e:GetClass()) then
		carents[e:EntIndex()] = e
	end
end)

hook.Add("EntityRemoved", "CarRadio_CarTracker", function(e)
	if isTracked(e:GetClass()) then
		carents[e:EntIndex()] = nil
	end
end)

function wcr.GetCarEnts()
	if !carents or !istable(carents) then return end
	return carents
end