MG_Trunk.TrunkSize = 4
MG_Trunk.MaxMass = 100

MG_Trunk.MaxPlayerDistance = 7000
MG_Trunk.MaxHitPosDistance = 4000
MG_Trunk.MaxControllerDistance = 12000
MG_Trunk.MaxEntityDistance = 7500

MG_Trunk.UseBind = "+reload"
MG_Trunk.StoreBind = "+reload"

MG_Trunk.CustomTrunkSizes = {
	["Airboat"] = 0,
	["porcycletdm"] = 0,
	["airtugtdm"] = 0,
	["wrangler88tdm"] = 0,
	["jeewillystdm"] = 0,
	["Jeep"] = 1,
	["bmw_isettatdm"] = 1,
	["wranglertdm"] = 2,
	["che_sparktdm"] = 3,
	["colttdm"] = 3,
	["h1tdm"] = 5,
	["h1opentdm"] = 5,
	["cad_escaladetdm"] = 5,
	["bowlexrstdm"] = 5,
	["che_blazertdm"] = 5,
	["grandchetdm"] = 5,
	["landrovertdm"] = 5,
	["landrover12tdm"] = 5,
	["toyrav4tdm"] = 5,
	["toyfjtdm"] = 5,
	["coupe40tdm"] = 5,
	["cayennetdm"] = 5,
	["cayenne12tdm"] = 5,
	["priustdm"] = 5,
	["mr2gttdm"] = 5,
	["merml63tdm"] = 5,
	["mer300seltdm"] = 5,
	["che_corv_gsctdm"] = 5,
	["507tdm"] = 5,
	["rs4avanttdm"] = 5,
	["audir8spydtdm"] = 5,
	["che_impala96tdm"] = 5,
	["fer_250gttdm"] = 5,
	["crownvic_taxitdm"] = 5,
	["che_c10tdm"] = 6,
	["f100tdm"] = 6,
	["raptorsvttdm"] = 6,
	["sierratdm"] = 6,
	["syclonetdm"] = 6,
	["lrdefendertdm"] = 6,
	["dod_ram_1500tdm"] = 6,
	["dodgeramtdm"] = 6,
	["toytundratdm"] = 7,
	["dod_ram_3500tdm"] = 7,
	["f350tdm"] = 7,
	["transittdm"] = 7,
	["gmcvantdm"] = 7,
	["vswat"] = 8,
	["c5500tdm"] = 8
}

MG_Trunk.CustomTrunkPositionChecks = {
	["che_c10tdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 12500
	end,
	["f100tdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11500
	end,
	["dod_ram_1500tdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11500
	end,
	["dodgeramtdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11500
	end,
	["f350tdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 15000
	end,
	["raptorsvttdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 12500
	end,
	["sierralowtdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 12500
	end,
	["sierratdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 12500
	end,
	["syclonetdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 12500
	end,
	["dod_ram_3500tdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 15000
	end,
	["toytundratdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11000
	end,
	["transittdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11000 or ply:EyePos():DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 7500
	end,
	["gmcvantdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11000 or ply:EyePos():DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 7500
	end,
	["vswat"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11000 or ply:EyePos():DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 7500
	end,
	["c5500tdm"] = function(ply, ent, tr)
		return ply:EyePos():DistToSqr(tr.HitPos) <= 10000 and tr.HitPos:DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 11000 or ply:EyePos():DistToSqr(ent:LocalToWorld(ent:GetTrunkPosition())) <= 7500
	end
}

MG_Trunk.PickupBlacklist = {
	["player"] = true,
	["worldspawn"] = true,
	["prop_vehicle_jeep"] = true,
	["prop_vehicle_jeep_old"] = true,
	["prop_vehicle_airboat"] = true,
	["prop_vehicle_prisoner_pod"] = true,
	["prop_physics"] = true,
	["prop_physics_multiplayer"] = true,
	["prop_dynamic"] = true,
	["gmod_button"] = true,
	["gmod_dynamite"] = true,
	["gmod_thruster"] = true,
	["gmod_light"] = true,
	["gmod_lamp"] = true,
	["gmod_emitter"] = true,
	["money_pot"] = true,
	["3d2dtext"] = true,
	["textscreen"] = true,
	["keypad"] = true,
	["bell"] = true,
	["glorifiedbanking_atm"] = true,
	["glorifiedbanking_cardreader"] = true,
	["armory"] = true,
	["dumpster"] = true,
	["wheel_of_luck"] = true,
	["double_or_nothing"] = true,
	["mr_roulette_screen"] = true,
	["mr_roulette_base"] = true,
	["plant_plot"] = true,
	["economy_bank"] = true,
	["economy_alarm"] = true,
	["itemstore_bank"] = true,
	["npc_dealer"] = true,
	["car_dealer"] = true,
	["npc_dmv"] = true,
	["npc_family"] = true,
	["npc_plantmarket"] = true,
	["zrush_fuelbuyer_npc"] = true,
	["zmlab_methdropoff"] = true,
	["zrush_burner"] = true,
	["zrush_drillhole"] = true,
	["zrush_drillpipe_holder"] = true,
	["zrush_drilltower"] = true,
	["zrush_module"] = true,
	["zrush_oilspot"] = true,
	["zrush_oilspot_generator"] = true,
	["zrush_pump"] = true,
	["zrush_refinery"] = true,
	["zmlab_combiner"] = function(ent)
		if !ent.GetIsScraped or !ent:GetIsScraped() then
			return true
		end
		return false
	end,
	["zmlab_freezer"] = true,
	["mining_rock"] = true,
	["mining_sellcrate"] = true,
	["gaspump"] = true,
	["bs_dshield"] = true,
	["bs_shield"] = true,
	["admin_healthstation"] = true,
	["admin_microwave"] = true,
	["spawnpoint"] = true,
	["spawnpoint_protected"] = true,
	["metal_detector"] = true
}