MG_Trunk = MG_Trunk or {}

hook.Add(SERVER and "OnEntityCreated" or "NetworkEntityCreated", "MG_Trunk_Initialize", function(ent)
	local class = ent:GetClass()
	if class == "prop_vehicle_jeep" or class == "prop_vehicle_jeep_old" or class == "prop_vehicle_airboat" then
		timer.Simple(0, function()
			if !IsValid(ent) then return end
			local size = MG_Trunk.CustomTrunkSizes[ent:GetVehicleClass()] or MG_Trunk.TrunkSize
			if size > 0 then
				ent.TrunkSize = size
				if SERVER then
					ent.Trunk = {}
				end
			end
		end)
	end
end)

MG_Trunk.CustomEntityFunctions = {}
function MG_Trunk.CallCustomEntityFunction(typ, ent, veh, trunk_pos)
	local func = MG_Trunk.CustomEntityFunctions[ent:GetClass()]
	if func then
		return func(typ, ent, veh, trunk_pos)
	end
end

function MG_Trunk.AddCustomEntityFunction(class, func)
	MG_Trunk.CustomEntityFunctions[class] = func
end

local meta = FindMetaTable("Entity")
MG_Trunk.Cache = {}
function meta:GetTrunkPosition()
	local model = self:GetModel()
	local cache = MG_Trunk.Cache
	if !cache[model] then
		local maxs = self:OBBMaxs()
		cache[model] = self:OBBMins() + Vector(maxs.x, 0, maxs.z / 4)
	end
	return cache[model]
end