include("shared.lua")

local isSitting
local draw_simpletextoutlined = draw.SimpleTextOutlined

net.Receive("MG_Blackjack_Sit", function()
	isSitting = net.ReadBool() and true

	if isSitting then
		local localPly
		hook.Add("HUDPaint", "MG_Blackjack_HUDPaint", function()
			localPly = localPly or LocalPlayer()

			if !isSitting or !localPly:InVehicle() then
				isSitting = nil
				hook.Remove("HUDPaint", "MG_Blackjack_HUDPaint")
				return
			end

			local scrw, scrh = ScrW() / 2, ScrH() - 110
			draw_simpletextoutlined("Du sitzt am Blackjacktisch.", "mg_instructions", scrw, scrh, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
			draw_simpletextoutlined("Drücke ["..string.upper(input.LookupBinding("+reload")).."], um aufzustehen.", "mg_instructions2", scrw, scrh + 25, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP, 1, color_black)
		end)
		
		hook.Add("KeyPress", "MG_Blackjack_KeyPress", function(ply, button)
			if !isSitting then
				hook.Remove("KeyPress", "MG_Blackjack_KeyPress")
				return
			end
			if !IsFirstTimePredicted() then return end
			if button == IN_RELOAD then
				net.Start("MG_Blackjack_Unsit")
				net.SendToServer()
			elseif button == IN_USE then
				net.Start("MG_Blackjack_Use")
				net.SendToServer()
			end
		end)
	else
		hook.Remove("HUDPaint", "MG_Blackjack_HUDPaint")
		hook.Remove("KeyPress", "MG_Blackjack_KeyPress")
	end
end)