MG_Blackjack.Config.BetDefault = 1
MG_Blackjack.Config.BetSteps = {5000, 10000, 25000, 50000, 100000, 250000, 500000}
MG_Blackjack.Config.BetPeriod = 30
MG_Blackjack.Config.Timeout = 30
MG_Blackjack.Config.Blackjack = 3
MG_Blackjack.Config.Win = 1.5
MG_Blackjack.Config.DealerHandMin = {16, 17, 18, 19}

function MG_Blackjack:RequestConfigData()
	return {
		["bet"] = {
			["default"] = self.Config.BetSteps[self.Config.BetDefault],
			["steps"] = self.Config.BetSteps,
		},
		["general"] = {
			["betPeriod"] = self.Config.BetPeriod,
		},
		["payout"] = {
			["blackjack"] = self.Config.Blackjack,
			["win"] = self.Config.Win,
		},
		["turn"] = {
			["timeout"] = self.Config.Timeout,
		}
	}
end

local allCards = {}
for _, s in pairs({"h", "d", "s", "c"}) do
	for _, v in pairs{"a", 2, 3, 4, 5, 6, 7, 8, 9, "t", "j", "k", "q"} do
		table.insert(allCards, s..v)
	end
end

function MG_Blackjack.GetRandom()
	return allCards[math.random(1, #allCards)]
end

function MG_Blackjack.GetValue(card, sum)
	local v = card[2]
	if !v then return false end

	if (v == "t") or (v == "j") or (v == "k") or (v == "q") then
		return 10
	elseif v == "a" then
		if sum then -- Check if we're basing it off a current evaluation
			if sum <= 10 then -- If the current sum is less than 11, we can return 11 without going bust
				return 11
			end

			return 1 -- Return 1 as a fallback
		end

		return 11
	else
		return tonumber(v)
	end
end

function MG_Blackjack.GetHandValue(cards)
	local totalValue = 0
	local aces = 0

	for k, v in pairs(cards) do
		-- We calculate the aces after we've summmed up the total
		if v[2] == "a" then
			aces = aces + 1
			continue
		end
		totalValue = totalValue + MG_Blackjack.GetValue(v)
	end

	if aces > 0 then
		for i=1, aces do
			totalValue = totalValue + MG_Blackjack.GetValue("ha", totalValue) -- It doesn't matter the card we give it, as long as it's an ace
		end
	end

	return totalValue
end

local skins = {["h"] = 0, ["d"] = 1, ["c"] = 2, ["s"] = 3}
local bodygroups = {["a"] = 0, ["2"] = 1, ["3"] = 2, ["4"] = 3, ["5"] = 4, ["6"] = 5, ["7"] = 6, ["8"] = 7, ["9"] = 8, ["t"] = 9, ["j"] = 10, ["q"] = 11, ["k"] = 12}
function MG_Blackjack.GetFaceData(card)
	if !card then return end
	return skins[card[1]] or 0, bodygroups[card[2]] or 0
end

-- All the types of chips
MG_Blackjack.ChipTypes = {1, 5, 10, 25, 50, 100, 250, 500, 1000, 2000, 5000, 25000, 50000, 100000, 250000, 500000, 1000000, 10000000, 100000000, 1000000000, 10000000000}
-- Builds a stack of chips to equal the number given
function MG_Blackjack.GetFromNumber(num)
	local total = num
	local chips = {}

	-- Loop the chip set and break it into chips
	for i = #MG_Blackjack.ChipTypes, 1, -1 do
		local chip = MG_Blackjack.ChipTypes[i]
		-- We offset by 1 to account for skins starting at 0
		chips[i-1] = math.floor(total/chip)
		total = total - (chips[i-1]*chip)

		-- Don't include it if it's empty
		if chips[i-1] == 0 then
			chips[i-1] = nil
		end
	end

	return chips
end