include("shared.lua")
include("don_config.lua")

local screenOverlay = Material( "materials/bluesdoubleornothing/screen_overlay.png" )
local screenBackground = Material( "materials/bluesdoubleornothing/screen_background.png" )
local startMaterial = Material("materials/bluesdoubleornothing/start.png")
local cashoutMaterial = Material("materials/bluesdoubleornothing/cashout.png")
local jackpotMaterial = Material("materials/bluesdoubleornothing/jackpot.png")
local bsodMaterial = Material("materials/bluesdoubleornothing/bsod.png")

local numberMaterials = {}
for i = 0 , 10 do
	numberMaterials[i] = Material("materials/bluesdoubleornothing/x"..i..".png")
end

local lowEndColor = Color(130,130,210)
local highEndColor = Color(255,58,58)

--Lerps between colors instead of single values
local function LerpColor(t, col1, col2)
	local newCol = Color(0, 0, 0, 0)

	newCol.r = Lerp(t, col1.r, col2.r)
	newCol.g = Lerp(t, col1.g, col2.g)
	newCol.b = Lerp(t, col1.b, col2.b)
	newCol.a = Lerp(t, col1.a, col2.a)

	return newCol
end

surface.CreateFont( "DON_SMALL", {
	font = "Roboto",
	extended = false,
	size = 50,
	weight = 500,
	blursize = 0,
	scanlines = 0,
	antialias = true,
	underline = false,
	italic = false,
	strikeout = false,
	symbol = false,
	rotary = false, 
	shadow = false,
	additive = false,
	outline = false,
} )

surface.CreateFont( "DON_MEDIAM", {
	font = "Roboto",
	extended = false,
	size = 85,
	weight = 500,
	blursize = 0,
	scanlines = 0,
	antialias = true,
	underline = false,
	italic = false,
	strikeout = false,
	symbol = false,
	rotary = false,
	shadow = false,
	additive = false,
	outline = false,
} )

surface.CreateFont( "DON_LARGE", {
	font = "Roboto",
	extended = false,
	size = 150,
	weight = 500,
	blursize = 0,
	scanlines = 0,
	antialias = true,
	underline = false,
	italic = false,
	strikeout = false,
	symbol = false,
	rotary = false,
	shadow = false,
	additive = false,
	outline = false,
} )

--Localise some vars

local surface = surface
local CurTime = CurTime
local math = math
local Color = Color
local draw = draw
local FrameTime = FrameTime
local oldLocalPlayer = LocalPlayer
local LocalPlayer = LocalPlayer
local Matrix = Matrix

if isfunction(LocalPlayer) and LocalPlayer():IsValid() then
	LocalPlayer = LocalPlayer()
end

hook.Add("InitPostEntity", "DON:setuplocalplayer", function()
	LocalPlayer = oldLocalPlayer()
end)

function ENT:Initialize()
	self:SetSubMaterial(3, "!don_machinescreenmat_"..self:EntIndex())

	self.screenMaterial = CreateMaterial("don_machinescreenmat_"..self:EntIndex(), "UnlitGeneric", {
		["$basetexture"] = "icon16/user.png" 
	})
	self.renderTarget = GetRenderTarget("don_machinescreen_"..self:EntIndex(), 2048, 2048, false)
	self.color = Color(math.random(0, 255), math.random(0, 255), math.random(0, 255))

	self.ScreenZoom = 1
	self.ScreenRotation = 0
	self.textRotation = 0

	self.cashOutSelected = false

	--This is frames used to draw the jackpot page, 0 means disabled.
	self.jackpotFrame = 0

	self.overrideGlitchMulti = false
	self.glitchMulti = 0

	self.screenMaterial:SetTexture('$basetexture', self.renderTarget)
end

--Stores draw frames for jackpots
local jackpotFrames = {}

--bsof screen
jackpotFrames[1] = function(ScrW, ScrH, ent)
	ent.ScreenZoom = 1 --Set instantly

	surface.SetDrawColor(color_white)
	surface.SetMaterial(bsodMaterial) 
	surface.DrawTexturedRect(0, 0, ScrW, ScrH) 
end

--Dont worry
jackpotFrames[2] = function(ScrW, ScrH)
	draw.SimpleText("Keine Sorge.", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Keine Sorge.", "DON_MEDIAM", ScrW/2, ScrH / 2, color_white, 1, 0)
end

--This isnt a glitch
jackpotFrames[3] = function(ScrW, ScrH)
	draw.SimpleText("Das ist kein Fehler.", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Das ist kein Fehler.", "DON_MEDIAM", ScrW/2, ScrH / 2, color_white, 1, 0)
end

--I'v got something to tell you
jackpotFrames[4] = function(ScrW, ScrH)
	draw.SimpleText("Ich habe dir etwas", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Ich habe dir etwas", "DON_MEDIAM", ScrW/2, ScrH / 2, color_white, 1, 0)

	draw.SimpleText("zu erzählen", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5 + 75, Color(60,60,60,255), 1, 0)
	draw.SimpleText("zu erzählen", "DON_MEDIAM", ScrW/2, ScrH / 2 + 75, color_white, 1, 0)
end

--Something important
jackpotFrames[5] = function(ScrW, ScrH, ent)
	draw.SimpleText("Etwas Wichtiges!", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Etwas Wichtiges!", "DON_MEDIAM", ScrW/2, ScrH / 2, color_white, 1, 0)
end

--Congratulations player
jackpotFrames[6] = function(ScrW, ScrH, ent)
	draw.SimpleText("Herzlichen Glückwunsch,", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Herzlichen Glückwunsch,", "DON_MEDIAM", ScrW/2, ScrH / 2, color_white, 1, 0)

	draw.SimpleText(ent:GetUserName(), "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5 + 75, Color(60,60,60,255), 1, 0)
	draw.SimpleText(ent:GetUserName(), "DON_MEDIAM", ScrW/2, ScrH / 2 + 75, color_white, 1, 0)
end

--You've just won the...
jackpotFrames[7] = function(ScrW, ScrH, ent)
	draw.SimpleText("Du hast gewonnen!", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Du hast gewonnen!", "DON_MEDIAM", ScrW/2, ScrH / 2, color_white, 1, 0)

	draw.SimpleText("Nämlich den...", "DON_MEDIAM", ScrW/2 + 5, ScrH / 2 + 5 + 75, Color(60,60,60,255), 1, 0)
	draw.SimpleText("Nämlich den...", "DON_MEDIAM", ScrW/2, ScrH / 2 + 75, color_white, 1, 0)	
end

--You've just won the...
jackpotFrames[8] = function(ScrW, ScrH, ent)
	surface.SetDrawColor(LerpColor(math.sin((SysTime() * 22) + 1) / 2,Color(255,215,100), Color(255 * 0.6,215 * 0.6, 100)))
	surface.SetMaterial(screenBackground)
	surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * 60) % 360)

	surface.SetDrawColor(color_white)
	surface.SetMaterial(jackpotMaterial) 
	surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1024 * 1.5, 512 * 1.5, ent.textRotation)	

	--draw.SimpleText("DU GEWINNST!", "DON_LARGE", ScrW/2 + 5, 350 + 5 - 30, Color(60,60,60,255), 1, 0)
	--draw.SimpleText("DU GEWINNST!", "DON_LARGE", ScrW/2, 350 - 30, color_white, 1, 0)

	--draw.SimpleText("$"..string.Comma(self:GetCashOutAmount()), "DON_LARGE", ScrW/2 + 5, 350 + 5 + 75, Color(60,60,60,255), 1, 0)
	--draw.SimpleText("$"..string.Comma(self:GetCashOutAmount()), "DON_LARGE", ScrW/2, 350 + 75, color_white, 1, 0)

	surface.SetDrawColor(color_white)
	surface.SetMaterial(screenOverlay) 
	surface.DrawTexturedRect(0 - 50, 0 - 50, ScrW + 100, ScrH + 100) 
end

jackpotFrames[9] = function(ScrW, ScrH, ent)
	surface.SetDrawColor(LerpColor(math.sin((SysTime() * 22) + 1) / 2,Color(255,215,100), Color(255 * 0.6,215 * 0.6, 100)))
	surface.SetMaterial(screenBackground)
	surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * 60) % 360)

	surface.SetDrawColor(color_white)
	surface.SetMaterial(jackpotMaterial) 
	surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1024 * 1.5, 512 * 1.5, ent.textRotation)	

	draw.SimpleText("DEIN PREIS", "DON_LARGE", ScrW/2 + 5, 450 + 5 - 30, Color(60,60,60,255), 1, 0)
	draw.SimpleText("DEIN PREIS", "DON_LARGE", ScrW/2, 450 - 30, Color(255,255,255, 255), 1, 0)
 
	draw.SimpleText("$"..string.Comma(ent:GetJackpot()), "DON_LARGE", ScrW/2 + 5, 450 + 5 + 75, Color(60,60,60,255), 1, 0)
	draw.SimpleText("$"..string.Comma(ent:GetJackpot()), "DON_LARGE", ScrW/2, 450 + 75, color_white, 1, 0)

	surface.SetDrawColor(color_white)
	surface.SetMaterial(screenOverlay) 
	surface.DrawTexturedRect(0 - 50, 0 - 50, ScrW + 100, ScrH + 100) 
end

jackpotFrames[10] = function(ScrW, ScrH, ent)
	surface.SetDrawColor(LerpColor(math.sin((SysTime() * 22) + 1) / 2,Color(255,215,100), Color(255 * 0.6,215 * 0.6, 100)))
	surface.SetMaterial(screenBackground)
	surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * 60) % 360)

	surface.SetDrawColor(color_white)
	surface.SetMaterial(jackpotMaterial) 
	surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1024 * 1.5, 512 * 1.5, ent.textRotation)	

	draw.SimpleText("DEIN PREIS", "DON_LARGE", ScrW/2 + 5, 450 + 5 - 30, Color(60,60,60,255), 1, 0)
	draw.SimpleText("DEIN PREIS", "DON_LARGE", ScrW/2, 450 - 30, Color(255,255,255, 255), 1, 0)

	local prizeLerpValue = math.Clamp((ent.jackpotCountdown - SysTime()) / 13.97, 0, 1)
 
	local prizeValue = math.floor(Lerp(1 - prizeLerpValue, ent:GetJackpot(), 0))

	draw.SimpleText("$"..string.Comma(prizeValue), "DON_LARGE", ScrW/2 + 5, 450 + 5 + 75, Color(60,60,60,255), 1, 0)
	draw.SimpleText("$"..string.Comma(prizeValue), "DON_LARGE", ScrW/2, 450 + 75, color_white, 1, 0)

	surface.SetDrawColor(color_white)
	surface.SetMaterial(screenOverlay) 
	surface.DrawTexturedRect(0 - 50, 0 - 50, ScrW + 100, ScrH + 100) 
end

--Called when ever the screen should draw
function ENT:DrawScreen(ScrW, ScrH, tb)
	local multiplier = self:GetMultiplier() -- out of 10
 
	--Do we override with the jackpot?
	if tb.jackpotFrame ~= 0 then
		jackpotFrames[tb.jackpotFrame](ScrW, ScrH, self)
		return --Dont draw anything else
	end

	--Draw cashout screen
	if self:GetCashOutAmount() > 0 then
		surface.SetDrawColor(LerpColor(math.sin((SysTime() * 8) + 1) / 2,Color(83, 255,136), Color(83 * 0.6,255 * 0.6,136 * 0.6)))
		surface.SetMaterial(screenBackground)
		surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * 10) % 360)

		surface.SetDrawColor(color_white)
		surface.SetMaterial(cashoutMaterial) 
		surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1024 * 1.3, 512 * 1.3, tb.textRotation)	

		draw.SimpleText("DU GEWINNST!", "DON_LARGE", ScrW/2 + 5, 350 + 5 - 30, Color(60,60,60,255), 1, 0)
		draw.SimpleText("DU GEWINNST!", "DON_LARGE", ScrW/2, 350 - 30, color_white, 1, 0)

		draw.SimpleText("$"..string.Comma(self:GetCashOutAmount()), "DON_LARGE", ScrW/2 + 5, 350 + 5 + 75, Color(60,60,60,255), 1, 0)
		draw.SimpleText("$"..string.Comma(self:GetCashOutAmount()), "DON_LARGE", ScrW/2, 350 + 75, color_white, 1, 0)

		--Draw the current user 
		local textToDisplay = "Derzeitiger Nutzer: "..self:GetUserName()
		if math.ceil((self:GetUserLastInteract() + DON_CONFIG.antiTheftTime) - CurTime()) > 0 then
			textToDisplay = textToDisplay.." ("..math.abs(math.ceil((self:GetUserLastInteract() + DON_CONFIG.antiTheftTime) - CurTime()))..")"
		end
		draw.SimpleText(textToDisplay, "DON_SMALL", ScrW /2, ScrH - 75, color_white, 1, 0)

		surface.SetDrawColor(color_white)
		surface.SetMaterial(screenOverlay) 
		surface.DrawTexturedRect(0, 0, ScrW, ScrH) 

		return --Prevent rest from drawing
	end

	--Draw start screen stuff
	if !self:GetGameStarted() then
		surface.SetDrawColor(LerpColor(math.sin((SysTime() * 3) + 1) / 2,Color(83,255,136), Color(83,192,255)))
		surface.SetMaterial(screenBackground)
		surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * 10) % 360)

		surface.SetDrawColor(color_white)
		surface.SetMaterial(startMaterial) 
		surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1150, 512, tb.textRotation)	

		draw.SimpleText("$"..string.Comma(DON_CONFIG.bet).." PRO SPIEL", "DON_LARGE", ScrW/2 + 5, 350 + 5, Color(60,60,60,255), 1, 0)
		draw.SimpleText("$"..string.Comma(DON_CONFIG.bet).." PRO SPIEL", "DON_LARGE", ScrW/2, 350, color_white, 1, 0)

		draw.SimpleText("Erreiche x10 für den Jackpot!", "DON_MEDIAM", ScrW/2 + 5, ScrH - 450 + 5, Color(60,60,60,255), 1, 0)
		draw.SimpleText("Erreiche x10 für den Jackpot!", "DON_MEDIAM", ScrW/2, ScrH - 450, color_white, 1, 0)

		draw.SimpleText("$"..string.Comma(self:GetJackpot()), "DON_MEDIAM", ScrW/2 + 5, ScrH - 450 + 5 + 75, Color(60,60,60,255), 1, 0)
		draw.SimpleText("$"..string.Comma(self:GetJackpot()), "DON_MEDIAM", ScrW/2, ScrH - 450 + 75, color_white, 1, 0)

		--Draw the current user 
		local textToDisplay = "Derzeitiger Nutzer: "..self:GetUserName()
		if math.ceil((self:GetUserLastInteract() + DON_CONFIG.antiTheftTime) - CurTime()) > 0 then
			textToDisplay = textToDisplay.." ("..math.abs(math.ceil((self:GetUserLastInteract() + DON_CONFIG.antiTheftTime) - CurTime()))..")"
		end
		draw.SimpleText(textToDisplay, "DON_SMALL", ScrW /2, ScrH - 75, color_white, 1, 0)

		surface.SetDrawColor(color_white)
		surface.SetMaterial(screenOverlay) 
		surface.DrawTexturedRect(0, 0, ScrW, ScrH) 

		return --Prevent the rest from drawin
	end

	--Draw in game stuff

	--Draw the background surface
	if multiplier ~= 0 then
		surface.SetDrawColor(LerpColor(multiplier/10, lowEndColor, highEndColor))
		surface.SetMaterial(screenBackground)
		surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * multiplier * 10) % 360)
	else
		surface.SetDrawColor(LerpColor(math.sin((SysTime() * 10) + 1) / 2, Color(160,0,0), Color(255,0,0)))
		surface.SetMaterial(screenBackground)
		surface.DrawTexturedRectRotated(ScrW /2, ScrH /2 , 2350, 2350, (SysTime() * 10) % 360)	
	end

	if multiplier ~= 0 then
		--Draw multiplier
		surface.SetDrawColor(LerpColor(1 - (multiplier/10), lowEndColor, highEndColor))
		surface.SetMaterial(numberMaterials[multiplier])
		surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1024, 1024, tb.textRotation)
	else
		surface.SetDrawColor(Color(255,90,90))
		surface.SetMaterial(numberMaterials[0])
		surface.DrawTexturedRectRotated(ScrW/2, ScrH/2, 1024, 512, tb.textRotation)	
	end

	local bet = DON_CONFIG.bet

	for i = 1, multiplier - 1 do
		bet = bet * 2
	end

	--Draw winning amount so far
	draw.SimpleText("$"..string.Comma(bet), "DON_LARGE", ScrW/2 + 5, 350 + 5, Color(60,60,60,255), 1, 0)
	draw.SimpleText("$"..string.Comma(bet), "DON_LARGE", ScrW/2, 350, color_white, 1, 0)


	--Draw the current user 
	local textToDisplay = "Derzeitger Nutzer: "..self:GetUserName()
	if math.ceil((self:GetUserLastInteract() + DON_CONFIG.antiTheftTime) - CurTime()) > 0 then
		textToDisplay = textToDisplay.." ("..math.abs(math.ceil((self:GetUserLastInteract() + DON_CONFIG.antiTheftTime) - CurTime()))..")"
	end
	draw.SimpleText(textToDisplay, "DON_SMALL", ScrW /2, ScrH - 75, color_white, 1, 0)

	--Draw overlay 
	surface.SetDrawColor(color_white)
	surface.SetMaterial(screenOverlay) 
	surface.DrawTexturedRect(0, 0, ScrW, ScrH) 
end

--Called to update the server of which button the client is looking at
function ENT:CheckSelectedButton(dist, tb)

	--Too far
	if dist > 22500 then return end

	--Calculate ray position and rotation
	local origin = LocalPlayer:EyePos()
	local direction = LocalPlayer:EyeAngles():Forward()
	local planePosition = self:GetPos() + (self:GetAngles():Up() * 30) + (self:GetAngles():Forward() * -15)
	local planeNormal = self:GetUp() - self:GetForward()
	planeNormal:Normalize()

	--Interesect plane
	local hitPos = util.IntersectRayWithPlane(origin, direction, planePosition, planeNormal)

	if hitPos == nil then return end

	--Min = -13.100795 9.520778 31.899216
	--Max = -17.147301 2.431691 27.852707

	local localPosition = self:WorldToLocal(hitPos)

	local inBox = localPosition:WithinAABox(Vector(-17.147301, 1.431691, 27.852707), Vector(-13.100795, 11.520778, 31.899216))

	if tb.cashOutSelected ~= inBox then
		net.Start("DON:setselectedbutton")
			net.WriteEntity(self)
			net.WriteBool(inBox)
		net.SendToServer()
	end

	tb.cashOutSelected = inBox
end


local screenX = 1024 + 128
local screenY = 2048

local xShake = 0
local yShake = 0

local pos, tb
function ENT:Draw()
	pos = self:GetPos()
	tb = self:GetTable()
	self:VisualCutoff(pos, tb)
	if tb.Distance < 1000000 then
		local mult = self:GetMultiplier()

		tb.ScreenZoom = Lerp((10 - mult) * FrameTime(), tb.ScreenZoom, 1)
		tb.textRotation = Lerp((10 - mult) * FrameTime(), tb.textRotation, 0)

		if tb.overrideGlitchMulti then
			tb.ScreenZoom = Lerp(3 * FrameTime(), tb.ScreenZoom, 1)
			tb.textRotation = Lerp(3 * FrameTime(), tb.textRotation, 0)		 
		end

		xShake = 0
		yShake = 0

		local mat = Matrix()
		if tb.ScreenZoom > 1 and mat then
			if mult > 3 and not tb.overrideGlitchMulti then
				xShake = Lerp((tb.ScreenZoom - 1) / 2.5, 0, math.Rand(-75, 75))
				yShake = Lerp((tb.ScreenZoom - 1) / 2.5, 0, math.Rand(-75, 75))
			else
				xShake = Lerp(((tb.ScreenZoom - 1) * tb.glitchMulti) / 2.5, 0, math.Rand(-75, 75))
				yShake = Lerp(((tb.ScreenZoom - 1) * tb.glitchMulti) / 2.5, 0, math.Rand(-75, 75))		
			end

			mat:SetTranslation(Vector((0 + (tb.ScreenZoom * (screenX/2))) - (screenX / 2) + xShake, (0 + (tb.ScreenZoom * (screenY / 2))) - (screenY / 2) + yShake) * -1)
			mat:Scale(Vector(1, 1, 1) * tb.ScreenZoom) 
		end

		--Draw the screen
		render.PushRenderTarget(tb.renderTarget)
			render.Clear(0, 0, 0, 255, true, true)
			render.OverrideAlphaWriteEnable(true, true)
			cam.Start2D()
				cam.PushModelMatrix(mat)
					self:DrawScreen(screenX, screenY, tb)
				cam.PopModelMatrix()
			cam.End2D()
		render.PopRenderTarget()

		--Update material texture
		--self.screenMaterial:SetTexture('$basetexture', self.renderTarget)

		--Check where we are looking
		self:CheckSelectedButton(tb.Distance, tb)
	end

	self:SetSubMaterial(3, "!don_machinescreenmat_"..self:EntIndex())

	--Draw the final result
	self:DrawModel()
end

function ENT:VisualCutoff(pos, tb)
	local cur_time = CurTime()
	if (tb.LastDistanceCheck or 0) > cur_time then return end
	tb.LastDistanceCheck = cur_time + 0.1
	tb.Distance = pos:DistToSqr(LocalPlayer:EyePos())
end

local jackpotTimers = {
	{timer = 3.69, func = function() end},
	{timer = 5.76, func = function() end},
	{timer = 7.61, func = function() end},
	{timer = 9.48, func = function() end},
	{timer = 11.35, func = function() end},
	{timer = 13.21, func = function() end}, 
	{timer = 15.09, func = function(ent)
		if not IsValid(ent) then return end
		ent.glitchMulti = 2
		timer.Create("jackpot_bounce_"..ent:EntIndex(), 468.75 / 1000, 0, function()
			if not IsValid(ent) then return end
			ent.ScreenZoom = (1 + (3 / 4))
			ent.textRotation = math.Rand(-3 * 4, 3 * 4)	
		end) 
	end},
	{timer = 30.09, func = function(ent)
		if not IsValid(ent) then return end
		ent.glitchMulti = 1
	end},
	{timer = 45.09, func = function(ent) 
		if not IsValid(ent) then return end
		ent.jackpotCountdown = CurTime() + 13.97
	end}, 
	{timer = 58, noframeAdvance = true, func = function(ent) --Reset
		if not IsValid(ent) then return end
		timer.Remove("jackpot_bounce_"..ent:EntIndex())
	end}, 
	{timer = 59, func = function(ent) --Reset
		if not IsValid(ent) then return end
		ent.jackpotFrame = 0 
		ent.overrideGlitchMulti = false
	end}, 
} 

--Triggers the jackpot
function ENT:PlayJackpot()
	--Set up a bunch of timers (I know its ugly but honestly who really cares, amirite)

	self.jackpotStartTime = CurTime()

	self.jackpotFrame = 1 --Begin drawing
	self.overrideGlitchMulti = true

	self.overrideGlitchMulti = true
	self.glitchMulti = 2

	--Emit the audio
	self:EmitSound("don_jackpot")
	--Set up the timers
	for k, v in pairs(jackpotTimers) do
		timer.Simple(v.timer, function()
			if not IsValid(self) then return end

			if not v.noframeAdvance then 
				self.jackpotFrame = self.jackpotFrame + 1	
			end
			v.func(self)	
		end)
	end 
end

--Trigger light effect
net.Receive("DON:updateScreenEffect",function()
	local e = net.ReadEntity()
	local power = net.ReadFloat()
	local mult = net.ReadUInt(16)

	if !IsValid(e) or !e.PlayJackpot then return end

	if power < 1 then
		power = (1 + (mult / 4))
	end

	e.ScreenZoom = power
	e.textRotation = math.random(-3 * mult, 3 * mult)
end)

net.Receive("DON:beginjackpot", function()
	local e = net.ReadEntity()
	if !IsValid(e) or !e.PlayJackpot then return end

	--Trigger the jackpot
	e:PlayJackpot()
end)

--Sound related stuff

sound.Add({
	name = "don_jackpot",
	channel = CHAN_AUTO,
	volume = 1,
	level = 75 * DON_CONFIG.Volume,
	pitch = {100},
	sound = "doubleornothing/jackpot.mp3"
})