include("shared.lua")

function ENT:Initialize()
	self.data = {}
	self.data.timer = 0
	self.data.display = false
end

local local_ply
function ENT:Draw()
	self:DrawModel()

	local tb = self:GetTable()
	if tb.data.display == true then
		local_ply = local_ply or LocalPlayer()

		local pos = self:GetPos()
		local dist = pos:DistToSqr(local_ply:GetPos())
		local ang = self:GetAngles()
		
		if dist > 250000 then return end

		local trace = local_ply:GetEyeTrace()
		local localTrace
		if trace.Entity and trace.Entity == self and trace.Entity:EntIndex() == self:EntIndex() then
			localTrace = self:WorldToLocal(trace.HitPos)
			localTrace = localTrace * Vector(40, 40, 40)
		end

		ang:RotateAroundAxis(ang:Up(), 0)
		ang:RotateAroundAxis(ang:Forward(), 90)
		ang:RotateAroundAxis(ang:Right(),-90)

		cam.Start3D2D(self:LocalToWorld(Vector(22,-2.5,70.5)), ang, 0.025)
			local offset = -1090 + (545)
			--background
			draw.RoundedBox(0, 50 + offset, -250,1180, 300, Color(195, 195, 195, 225))

			if tb.data.timer > 60 then
				local minutes = math.floor(tb.data.timer / 60)
				local seconds = tb.data.timer - (60*minutes)
				draw.SimpleTextOutlined("Zeit übrig "..minutes..":"..seconds,"MR_Font192_Screen",80, -80, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,8,Color(1,1,1))
			else
				draw.SimpleTextOutlined("Zeit übrig 0:"..tb.data.timer,"MR_Font192_Screen",80, -80, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,8,Color(1,1,1))
			end
		cam.End3D2D()
	end
end