include("shared.lua")

local max_dist = 40000
function ENT:Initialize()
	local tb = self:GetTable()

	tb.lastDistCheck = CurTime()

	tb.data = {}
	tb.data.status = 1
	tb.data.chipType = 1
	tb.data.betType = 0

	tb.chips = {}
	tb.chips[1] = Material("mr_misc/chip_1.png", "noclamp smooth")
	tb.chips[2] = Material("mr_misc/chip_2.png", "noclamp smooth")
	tb.chips[3] = Material("mr_misc/chip_3.png", "noclamp smooth")
	tb.chips[4] = Material("mr_misc/chip_4.png", "noclamp smooth")
	tb.chips[5] = Material("mr_misc/chip_5.png", "noclamp smooth")

	tb.hideCursor = true
end

local ui = Material("mr_misc/mr_ui.png", "noclamp smooth")
local chip_none = Material("mr_misc/chip_none.png", "noclamp smooth")
function ENT:GetMultiplier(curBet)
	local betName = curBet.name
	if betName == "red" then
		return mr.betRedBlack+1
	elseif betName == "black" then
		return mr.betRedBlack+1
	elseif betName == "odd" then
		return mr.betEvenOdd+1
	elseif betName == "even" then
		return mr.betEvenOdd+1
	elseif betName == "2to1row1" then
		return mr.betRow+1
	elseif betName == "2to1row2" then
		return mr.betRow+1
	elseif betName == "2to1row3" then
		return mr.betRow+1
	elseif betName == "1to6" then
		return mr.betOneThird+1
	elseif betName == "4to9" then
		return mr.betOneThird+1
	elseif betName == "7to12" then
		return mr.betOneThird+1
	else --straight bet
		return mr.betStraight+1
	end

	return false
end

local local_ply, tb
function ENT:Draw()
	self:DrawModel()

	local_ply = local_ply or LocalPlayer()
	tb = self:GetTable()

	self:VisualCutoff(local_ply, self:GetPos(), tb)

	if tb.Distance > max_dist then return end

	local ang = self:GetAngles()
	local trace = local_ply:GetEyeTrace()
	local localTrace
	if trace.Entity == self then
		localTrace = self:WorldToLocal(trace.HitPos)
		localTrace = localTrace * Vector(40, 40, 40)
	end

	ang:RotateAroundAxis(ang:Up(), 0)
	ang:RotateAroundAxis(ang:Forward(), 45)
	ang:RotateAroundAxis(ang:Right(), 0)

	if tb.data.status == 1 then return end

	cam.Start3D2D(self:LocalToWorld(Vector(-3,-8,13.7)), ang, 0.025)

		local offset = -1090 + 545

		--background
		draw.RoundedBox(0, 50 + offset, -250,1210, 800, Color(15, 15, 15, 225))

		draw.RoundedBox(0, 250 + offset, -200,185, 800, Color(225, 25, 25, 225))
		draw.RoundedBox(0, 435 + offset, -200,150, 800, Color(225, 225, 25, 225))
		draw.RoundedBox(0, 585 + offset, -200,150, 800, Color(25, 225, 25, 225))
		draw.RoundedBox(0, 735 + offset, -200,150, 800, Color(25, 25, 225, 225))
		draw.RoundedBox(0, 885 + offset, -200,250, 800, Color(25, 25, 25, 225))

		surface.SetDrawColor(225, 225, 225, 255)
		surface.SetMaterial(ui)
		surface.DrawTexturedRect(-15 + offset, -302,1360, 830)

		for i=1,5,1 do
			draw.SimpleTextOutlined(mr.bets[i],"MR_Font48_Screen",210+offset + (150*i), 475, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,3,Color(1,1,1))
		end

		for i=1,25,1 do
			local curBet = tb.data.curBets[i]
			if curBet then
				if curBet and curBet.type then
					if localTrace and localTrace.x > tb.traces[i].x1 and localTrace.x < tb.traces[i].x2 and localTrace.z > tb.traces[i].z1 and localTrace.z < tb.traces[i].z2 then
						surface.SetDrawColor(255, 255, 255, 255)
						surface.SetMaterial(chip_none)
						surface.DrawTexturedRect(tb.traces[i].x1+140, -tb.traces[i].z1+555,128, 128)
					else
						tb.chipMats = tb.chipMats or {}
						tb.chipMats[curBet.type] = tb.chipMats[curBet.type] or Material("mr_misc/chip_"..curBet.type..".png", "noclamp smooth")
						surface.SetDrawColor(255, 255, 255, 255)
						surface.SetMaterial(tb.chipMats[curBet.type])
						surface.DrawTexturedRect(tb.traces[i].x1+140, -tb.traces[i].z1+555,128, 128)
						draw.SimpleTextOutlined(mr.bets[curBet.type],"MR_Font36_Screen",tb.traces[i].x1+202, -tb.traces[i].z1+620, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,3,Color(1,1,1))
						local mult = self:GetMultiplier(curBet)
						if mult then
							draw.SimpleTextOutlined("x"..mult,"MR_Font32_Screen",tb.traces[i].x1+202, -tb.traces[i].z1+660, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,3,Color(1,1,1))
						end
					end
				end
			end
		end

		if localTrace and localTrace.x > -573 and localTrace.x < 602 and localTrace.z > 110 and localTrace.z < 755 then
			if !tb.hideCursor then
				tb.traceX = localTrace.x
				tb.traceZ = localTrace.z

				surface.SetDrawColor(255, 255, 255, 100)
				tb.chipMats = tb.chipMats or {}
				tb.chipMats[tb.data.chipType] = tb.chipMats[tb.data.chipType] or Material("mr_misc/chip_"..tb.data.chipType..".png", "noclamp smooth")
				surface.SetMaterial(tb.chipMats[tb.data.chipType])
				surface.DrawTexturedRect(localTrace.x + 57, -localTrace.y-353,128, 128)
				draw.SimpleTextOutlined(mr.bets[tb.data.chipType],"MR_Font36_Screen",localTrace.x + 120, -localTrace.y-290, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,3,Color(1,1,1))
			end
		end

		if localTrace then
			tb.hideCursor = false
			for i=1,28,1 do
				local trace = tb.traces[i]
				if localTrace.x > trace.x1 and localTrace.x < trace.x2 and localTrace.z < trace.z1 and localTrace.z > trace.z2 then
					if tb.data.curBets[i] and tb.data.curBets[i].type then
						tb.hideCursor = true
						surface.SetDrawColor(255, 255, 255, 255)
						surface.SetMaterial(chip_none)
						surface.DrawTexturedRect(trace.x1+140, -trace.z1+555,128, 128)
					else
						tb.traceX = localTrace.x
						tb.traceZ = localTrace.z

						surface.SetDrawColor(255, 255, 255, 255)
						tb.chipMats = tb.chipMats or {}
						tb.chipMats[tb.data.chipType] = tb.chipMats[self.data.chipType] or Material("mr_misc/chip_"..tb.data.chipType..".png", "noclamp smooth")
						surface.SetMaterial(tb.chipMats[tb.data.chipType])
						surface.DrawTexturedRect(localTrace.x + 57, -localTrace.y-353,128, 128)
						draw.SimpleTextOutlined(mr.bets[tb.data.chipType],"MR_Font36_Screen",localTrace.x + 120, -localTrace.y-290, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER,3,Color(1,1,1))
					end
				end
			end
		end
	cam.End3D2D()
end

function ENT:VisualCutoff(local_ply, pos, tb)
	local cur_time = CurTime()
	if (tb.LastDistanceCheck or 0) > cur_time then return end
	tb.LastDistanceCheck = cur_time + 0.1
	tb.Distance = pos:DistToSqr(local_ply:EyePos())
end