local a = "PS_Treb"
local use_font = system.IsWindows() and "Trebuchet MS" or "Verdana"

for _, v in ipairs({16, 19, 20, 22, 25, 30, 80}) do
	surface.CreateFont(a.."_S"..v, {font = use_font, size = v, weight = 700})
end

for _, v in ipairs({20, 25, 35}) do
	surface.CreateFont(a.."Out_S"..v, {font = use_font, size = v, weight = 700, outline = true})
end

local meta = FindMetaTable("Panel")
function meta:PS_DrawBoarder(width, col)
	local wide, tall = self:GetWide(), self:GetTall()
	width = width or 1
	col = col or PS.Style_Config.Col.MN.SCBarOutLine
	surface.SetDrawColor(col)
	surface.DrawRect(0, 0, wide, width)
	surface.DrawRect(0, tall - width, wide, width)
	surface.DrawRect(0, 0, width, tall)
	surface.DrawRect(wide - width, 0, width, tall)
end

function meta:PS_PaintListBar(bcol, icol)
	local bcol = bcol or PS.Style_Config.Col.MN.SCBarOutLine
	local icol = icol or color_black
	self.VBar.btnDown.Paint = function(slf, w, h)
		surface.SetDrawColor(bcol.r, bcol.g, bcol.b, 255)
		surface.DrawRect(0, 0, w, h)
		surface.SetDrawColor(icol.r, icol.g, icol.b, 255)
		surface.DrawRect(1, 1, w - 2, h - 2)
	end
	self.VBar.btnUp.Paint = function(slf, w, h)
		surface.SetDrawColor(bcol.r, bcol.g, bcol.b, 255)
		surface.DrawRect(0, 0, w, h)
		surface.SetDrawColor(icol.r, icol.g, icol.b, 255)
		surface.DrawRect(1, 1, w - 2, h - 2)
	end
	self.VBar.btnGrip.Paint = function(slf, w, h)
		surface.SetDrawColor(bcol.r, bcol.g, bcol.b, 255)
		surface.DrawRect(0, 0, w, h)
		surface.SetDrawColor(icol.r, icol.g, icol.b, 255)
		surface.DrawRect(1, 1, w - 2, h - 2)
	end
	self.VBar.Paint = function()
	end
end