local PANEL = {}

local canbuycolor = Color(0, 100, 0, 125)
local cantbuycolor = Color(100, 0, 0, 125)
local ownedcolor = Color(0, 0, 200, 125)

function PANEL:Init()
	self.Info = ""
end

function PANEL:DoClick()
	local ply = LocalPlayer()
	local tm = team.GetName(ply:Team())
	local points = PS.Config.CalculateBuyPrice(ply, self.Data)
	if !ply:PS_HasItem(self.Data.ID) and !ply:PS_HasPoints(points) then
		PS:ShowNotice("Du benötigst $"..string.Comma(points)..", um diesen Gegenstand zu kaufen!")
	end
	local menu = DermaMenu(self)
	menu:SetSkin("PS_DermaMenu")
	if ply:PS_HasItem(self.Data.ID) then
		menu:AddOption("Von "..team.GetName(ply:Team()).." verkaufen", function()
			if !self.Data or !self.Data.Name then return end
			surface.PlaySound("ui/buttonclick.wav")
			if self.Data.SharedInventory then
				PS:ShowAsker("Bist du sicher, dass du "..self.Data.Name.." verkaufen möchtest?", function()
					if !self.Data or !self.Data.ID then return end
					ply:PS_SellItem(self.Data.ID)
				end)
			else
				PS:ShowAsker("Bist du sicher, dass du "..self.Data.Name.." ("..tm..") verkaufen möchtest?", function()
					if !self.Data or !self.Data.ID then return end
					ply:PS_SellItem(self.Data.ID)
				end)
			end
		end):SetIcon("icon16/money.png")
	elseif ply:PS_HasPoints(points) then
		menu:AddOption("Für "..team.GetName(ply:Team()).." kaufen", function()
			if !self.Data or !self.Data.Name then return end
			surface.PlaySound("ui/buttonclick.wav")
			if self.Data.SharedInventory then
				PS:ShowAsker("Bist du sicher, dass du "..self.Data.Name.." kaufen möchtest?", function()
					if !self.Data or !self.Data.ID then return end
					ply:PS_BuyItem(self.Data.ID)
				end)
			else
				PS:ShowAsker("Bist du sicher, dass du "..self.Data.Name.." für "..tm.." kaufen möchtest?", function()
					if !self.Data or !self.Data.ID then return end
					ply:PS_BuyItem(self.Data.ID)
				end)
			end
		end):SetIcon("icon16/cart.png")
	end
	if ply:PS_HasItem(self.Data.ID) then
		menu:AddSpacer()
		if ply:PS_HasItemEquipped(self.Data.ID) then
			menu:AddOption("Ablegen", function()
				if !self.Data or !self.Data.ID then return end
				surface.PlaySound("ui/buttonclick.wav")
				ply:PS_HolsterItem(self.Data.ID)
			end):SetIcon("icon16/delete.png")
		else
			menu:AddOption("Anlegen", function()
				if !self.Data or !self.Data.ID then return end
				surface.PlaySound("ui/buttonclick.wav")
				ply:PS_EquipItem(self.Data.ID)
			end):SetIcon("icon16/add.png")
		end
		if self.Data.Modify then
			menu:AddSpacer()
			menu:AddOption("Modifizieren...", function()
				if !self.Data or !self.Data.ID then return end
				surface.PlaySound("ui/buttonclick.wav")
				PS.Items[self.Data.ID]:Modify(PS.LocalData[self.Data.ID].Modifiers)
			end):SetIcon("icon16/wrench.png")
		end
	end
	menu:Open()
end

function PANEL:SetData(data)
	self.Data = data
	self.Info = data.Name
	if data.Model then
		local DModelPanel = vgui.Create("DModelPanel", self)
		DModelPanel:SetModel(data.Model)
		DModelPanel:Dock(FILL)

		if data.Skin then
			DModelPanel:SetSkin(data.Skin)
		end

		if !IsValid(DModelPanel.Entity) then return end

		local modifications = PS.ModelPanelModifications[data.Model]

		local PrevMins, PrevMaxs = DModelPanel.Entity:GetRenderBounds()
		DModelPanel:SetCamPos(PrevMins:Distance(PrevMaxs) * (modifications and modifications.CamPos or Vector(0.5, 0.5, 0.5)))
		DModelPanel:SetLookAt((PrevMaxs + PrevMins) / (modifications and modifications.LookAt or 2))

		function DModelPanel:LayoutEntity(ent)
			if data.Skin and !ent.SkinIndex then
				ent:SetSkin(data.Skin)
				ent.SkinIndex = ent.Skin
			end

			local model_ent = self.Entity

			data:ModifyClientsideModel(model_ent, ent, Vector(), Angle(), self)

			local size = Vector(1, 1, 1)
			if data.ModelImageSize then
				size = data.ModelImageSize
			end

			local mat = Matrix()
			mat:Scale(size)
			ent:EnableMatrix("RenderMultiply", mat)

			data:PostModifyClientsideModel(model_ent, ent, Vector(), Angle(), self)
		end

		if data.ModelImageColor then
			DModelPanel:SetColor(data.ModelImageColor)
		end

		function DModelPanel:DoClick()
			self:GetParent():DoClick()
		end

		function DModelPanel:OnCursorEntered()
			self:GetParent():OnCursorEntered()
		end

		function DModelPanel:OnCursorExited()
			self:GetParent():OnCursorExited()
		end
	else
		local DImageButton = vgui.Create("DImageButton", self)
		DImageButton:SetMaterial(data.Material)
		DImageButton:Dock(FILL)

		function DImageButton:DoClick()
			self:GetParent():DoClick()
		end

		function DImageButton:OnCursorEntered()
			self:GetParent():OnCursorEntered()
		end

		function DImageButton:OnCursorExited()
			self:GetParent():OnCursorExited()
		end
	end
end

function PANEL:Paint(w, h)
	surface.SetDrawColor(PS.Style_Config.Col.IC.BackGround)
	surface.DrawRect(0, 0, w, h)
end

local adminicon = Material("icon16/user_suit.png")
local allowedicon = Material("icon16/user_grey.png")

local tier1icon = Material("icon16/award_star_bronze_3.png")
local tier2icon = Material("icon16/award_star_silver_3.png")
local tier3icon = Material("icon16/award_star_gold_3.png")

local teamonlyicon = Material("icon16/plugin.png")

function PANEL:PaintOver(w, h)
	local data = self.Data
	local offset = 0

	if data.AdminOnly then
		surface.SetMaterial(adminicon)
		surface.SetDrawColor(color_white)
		surface.DrawTexturedRect(4, 4 + offset, 16, 16)

		offset = offset + 16 + 2
	end

	if data.TeamOnly and !table.IsEmpty(data.TeamOnly) then
		surface.SetMaterial(teamonlyicon)
		surface.SetDrawColor(color_white)
		surface.DrawTexturedRect(4 + 1, 4 + offset, 16, 16)

		offset = offset + 16 + 2
	end

	local icon = data.AllowedUserGroups and #data.AllowedUserGroups > 0 and allowedicon or data.Tier3 and tier3icon or data.Tier2 and tier2icon or data.Tier1 and tier1icon

	if icon then
		surface.SetMaterial(icon)
		surface.SetDrawColor(color_white)
		surface.DrawTexturedRect(4, 4 + offset, 16, 16)
	end
end

function PANEL:OnCursorEntered()
	self.Hovered = true
	PS:SetHoverItem(self.Data.ID)
end

function PANEL:OnCursorExited()
	self.Hovered = false
	PS:RemoveHoverItem()
end

vgui.Register("DPointShopItem", PANEL, "DPanel")