ITEM.ID = "jetpack"
ITEM.Name = 'Jetpack'
ITEM.Price = 800000
ITEM.Model = 'models/thrusters/jetpack.mdl'
ITEM.Bone = 'ValveBiped.Bip01_Spine2'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"
ITEM.Tier2 = true

local model_modifications1 = {
	["models/player/arctic.mdl"] = {
		ang = {270, 0, 261.39001464844},
		pos = {2, 5, 1},
	},	
}

function ITEM:OnEquip(ply, modifications)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications1[ply_model] then
		return PS:ModifyModel(model_modifications1[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {270, 0, 270}, pos = {1, 5, 1}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "panzerung"
ITEM.Name = 'Panzerung'
ITEM.Price = 500000
ITEM.Model = 'models/sal/acc/armor01.mdl'
ITEM.Attachment = 'chest'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamOnly = {
	[TEAM_GANGSTERBOSS] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications9 = {
	["models/humans/mg_mafia/male_08.mdl"] = {
		size = {1.0499999523163, 1, 1},
		ang = {0, 0, 0},
		pos = {0, 0, -54},
	},	
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications9[ply_model] then
		return PS:ModifyModel(model_modifications9[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-0.5, 0, -54.7}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "rucksack01"
ITEM.Name = 'Camping-Rucksack (Rot)'
ITEM.Price = 260000
ITEM.Model = 'models/modified/backpack_1.mdl'
ITEM.Attachment = 'chest'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications3 = {
	["models/player/group01/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/magnusson.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/leet.mdl"] = {
		size = {1.1200000047684, 1, 1},
		ang = {0, 0, 0},
		pos = {0.69999998807907, 0, -2.5},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6},
	},
	["models/player/p2_chell.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6.9000000953674},
	},
	["models/player/alyx.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3.5999999046326},
	},
	["models/player/mossman.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -7.5},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {0.5, 0, -1.3999999761581},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3.2000000476837},
	},
	["models/player/barney.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-0, 0, -3.5},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5.5},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/male_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 15.64999961853},
		pos = {-1.5, 0, -2},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications3[ply_model] then
		return PS:ModifyModel(model_modifications3[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {0, 0, -4}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "rucksack02"
ITEM.Name = 'Camping-Rucksack (Schwarz)'
ITEM.Price = 240000
ITEM.Model = 'models/modified/backpack_1.mdl'
ITEM.Skin = 1
ITEM.Attachment = 'chest'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications4 = {
	["models/player/group01/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/magnusson.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/leet.mdl"] = {
		size = {1.1200000047684, 1, 1},
		ang = {0, 0, 0},
		pos = {0.69999998807907, 0, -2.5},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6},
	},
	["models/player/p2_chell.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6.9000000953674},
	},
	["models/player/alyx.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3.5999999046326},
	},
	["models/player/mossman.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -7.5},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {0.5, 0, -1.3999999761581},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3.2000000476837},
	},
	["models/player/barney.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-0, 0, -3.5},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5.5},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/male_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 15.64999961853},
		pos = {-1.5, 0, -2},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications4[ply_model] then
		return PS:ModifyModel(model_modifications4[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {0, 0, -4}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "rucksack03"
ITEM.Name = 'Camping-Rucksack (Orange)'
ITEM.Price = 220000
ITEM.Model = 'models/modified/backpack_1.mdl'
ITEM.Skin = 2
ITEM.Attachment = 'chest'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications5 = {
	["models/player/group01/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -6.9000000953674},
	},
	["models/player/magnusson.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/leet.mdl"] = {
		size = {1.1200000047684, 1, 1},
		ang = {0, 0, 0},
		pos = {0.69999998807907, 0, -2.5},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6},
	},
	["models/player/p2_chell.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6.9000000953674},
	},
	["models/player/alyx.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3.5999999046326},
	},
	["models/player/mossman.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -7.5},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -6},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {0.5, 0, -1.3999999761581},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3.2000000476837},
	},
	["models/player/barney.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-0, 0, -3.5},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5.5},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/group03/male_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/group03/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 15.64999961853},
		pos = {-1.5, 0, -2},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications5[ply_model] then
		return PS:ModifyModel(model_modifications5[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {0, 0, -4}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "wanderrucksack01"
ITEM.Name = 'Wanderrucksack (Schwarz)'
ITEM.Price = 620000
ITEM.Model = 'models/modified/backpack_2.mdl'
ITEM.Bone = 'ValveBiped.Bip01_Spine2'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications6 = {
	["models/player/group01/female_01.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/leet.mdl"] = {
		ang = {275, 180, 89},
		pos = {4, -4, 0},
	},
	["models/player_moxxi.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {275, 180, 89},
		pos = {1, -3, 0},
	},
	["models/player/p2_chell.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89},
		pos = {2, -2, 0},
	},
	["models/player/alyx.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {275, 180, 89},
		pos = {1, -3, 0},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89.650001525879},
		pos = {3, -3, 0},
	},
	["models/player/kleiner.mdl"] = {
		ang = {275, 180, 89},
		pos = {2, -4, 0},
	},
	["models/player/mossman.mdl"] = {
		ang = {275, 180, 89},
		pos = {-1, -3, 0},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -3, 0},
	},
	["models/player/mechanic.mdl"] = {
		ang = {275, 180, 89},
		pos = {5, -3, 0},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89},
		pos = {3.2999999523163, -3, 0},
	},
	["models/player/swat.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/riot.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/urban.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},											
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications6[ply_model] then
		return PS:ModifyModel(model_modifications6[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {275, 180, 89}, pos = {3, -4, 0}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "wanderrucksack02"
ITEM.Name = 'Wanderrucksack (Grün)'
ITEM.Price = 600000
ITEM.Model = 'models/modified/backpack_2.mdl'
ITEM.Skin = 1
ITEM.Bone = 'ValveBiped.Bip01_Spine2'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications7 = {
	["models/player/group01/female_01.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/leet.mdl"] = {
		ang = {275, 180, 89},
		pos = {4, -4, 0},
	},
	["models/player_moxxi.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {275, 180, 89},
		pos = {1, -3, 0},
	},
	["models/player/p2_chell.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89},
		pos = {2, -2, 0},
	},
	["models/player/alyx.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {275, 180, 89},
		pos = {1, -3, 0},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89.650001525879},
		pos = {3, -3, 0},
	},
	["models/player/kleiner.mdl"] = {
		ang = {275, 180, 89},
		pos = {2, -4, 0},
	},
	["models/player/mossman.mdl"] = {
		ang = {275, 180, 89},
		pos = {-1, -3, 0},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -3, 0},
	},
	["models/player/mechanic.mdl"] = {
		ang = {275, 180, 89},
		pos = {5, -3, 0},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89},
		pos = {3.2999999523163, -3, 0},
	},
	["models/player/swat.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/riot.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/urban.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},											
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications7[ply_model] then
		return PS:ModifyModel(model_modifications7[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {275, 180, 89}, pos = {3, -4, 0}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "wanderrucksack03"
ITEM.Name = 'Wanderrucksack (Rot)'
ITEM.Price = 640000
ITEM.Model = 'models/modified/backpack_2.mdl'
ITEM.Skin = 2
ITEM.Bone = 'ValveBiped.Bip01_Spine2'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications8 = {
	["models/player/group01/female_01.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {275, 180, 89},
		pos = {-0.5, -2, 0},
	},
	["models/player/leet.mdl"] = {
		ang = {275, 180, 89},
		pos = {4, -4, 0},
	},
	["models/player_moxxi.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {275, 180, 89},
		pos = {1, -3, 0},
	},
	["models/player/p2_chell.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89},
		pos = {2, -2, 0},
	},
	["models/player/alyx.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {275, 180, 89},
		pos = {1, -3, 0},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89.650001525879},
		pos = {3, -3, 0},
	},
	["models/player/kleiner.mdl"] = {
		ang = {275, 180, 89},
		pos = {2, -4, 0},
	},
	["models/player/mossman.mdl"] = {
		ang = {275, 180, 89},
		pos = {-1, -3, 0},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -3, 0},
	},
	["models/player/mechanic.mdl"] = {
		ang = {275, 180, 89},
		pos = {5, -3, 0},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.80000001192093, 0.80000001192093},
		ang = {275, 180, 89},
		pos = {3.2999999523163, -3, 0},
	},
	["models/player/swat.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/riot.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/urban.mdl"] = {
		ang = {275, 180, 90},
		pos = {4, -3, 0},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {275, 180, 89},
		pos = {0, -2, 0},
	},											
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications8[ply_model] then
		return PS:ModifyModel(model_modifications8[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {275, 180, 89}, pos = {3, -4, 0}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = 'engelsfluegel'
ITEM.Name = 'Engelsflügel'
ITEM.Price = 40000000
ITEM.Model = 'models/sinful/angel_wings.mdl'
ITEM.Bone = 'ValveBiped.Bip01_Spine2'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"
ITEM.Tier = 1

function ITEM:CanPlayerSee(ply)
	return PS.Config.Tier3Groups[ply:GetUserGroup()] and ply.hasLevel and ply:hasLevel(100) and ply:canAfford(self.Price)
end

function ITEM:OnEquip(ply, modifications)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	return PS:ModifyModel({ang = {90, 0, 270}, pos = {6, 9, 0}}, ply, model, pos, ang)
end

PS:AddItem()

ITEM.ID = "rucksack04"
ITEM.Name = 'Rucksack (Schwarz)'
ITEM.Price = 200000
ITEM.Model = 'models/modified/backpack_3.mdl'
ITEM.Attachment = 'chest'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications1 = {
	["models/player/leet.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player_moxxi.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},	
	["models/player/p2_chell.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-2, 0, -4},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/mossman.mdl"] = {
		size = {0.89999997615814, 1, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-1, 0, -5.8000001907349},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/barney.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-0.80000001192093, 0, -3},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/male_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/gman_high.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3.5},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0},
	},
	["models/player/group01/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications1[ply_model] then
		return PS:ModifyModel(model_modifications1[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-1, 0, -4}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "rucksack05"
ITEM.Name = 'Rucksack (Grau)'
ITEM.Price = 180000
ITEM.Model = 'models/modified/backpack_3.mdl'
ITEM.Skin = 1
ITEM.Attachment = 'chest'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Rücken"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications2 = {
	["models/player/leet.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player_moxxi.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},	
	["models/player/p2_chell.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-2, 0, -4},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -3},
	},
	["models/player/mossman.mdl"] = {
		size = {0.89999997615814, 1, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-1, 0, -5.8000001907349},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -5.5},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/barney.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-0.80000001192093, 0, -3},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -5},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -5},
	},
	["models/player/group03/male_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/group03/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3},
	},
	["models/player/gman_high.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, -3.5},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -1},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0},
	},
	["models/player/group01/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
	["models/player/group01/female_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -6},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications2[ply_model] then
		return PS:ModifyModel(model_modifications2[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-1, 0, -4}}, ply, model, pos, ang)
end
PS:AddItem()