ITEM.ID = "3dbrille"
ITEM.Name = '3D-Brille'
ITEM.Price = 250000
ITEM.Model = 'models/gmod_tower/3dglasses.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Brillen"
ITEM.Tier1 = true

ITEM.TeamExclude = {
	[TEAM_HITMAN] = true,
	[TEAM_LAWYER] = true,
	[TEAM_SEK] = true,
	[TEAM_ZOLL] = true,
}

local model_modifications1 = {
	["models/player/suits/male_04_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, 0.2},
	},
	["models/player/suits/male_06_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.3, 0, 0},
	},
	["models/player/suits/male_09_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, 0},
	},
	["models/player/corpse1.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, 0},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 18.78},
		pos = {-3.2, 0, -1},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-2.5, 0, -1.3},
	},
	["models/player/mechanic.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-2, 0, 1.5},
	},
	["models/player/soldier_stripped.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-2.5, 0, -1.3},
	},
	["models/player/clannypolice/male_04.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-2, 0, 0},
	},
	["models/player/clannypolice/male_09.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-2, 0, 0},
	},
	["models/player/riot.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-1, 0, 0.5},
	},
	["models/player/urban.mdl"] =  {
		ang = {0, 0, 0},
		pos = {1.1, 0, 0.5},
	},
	["models/humans/mg_mafia/male_04.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0},
	},
	["models/humans/mg_mafia/male_06.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-1, 0, -0.6},
	},
	["models/humans/mg_mafia/male_07.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0.89},
	},
	["models/humans/mg_mafia/male_08.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-1.7, 0, -0.8},
	},
	["models/player/phoenix.mdl"] =  {
		size = {1, 1.09, 1},
		ang = {0, 0, 0},
		pos = {-1.2, 0, 1},
	},
	["models/player/guerilla.mdl"] =  {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 1},
	},
	["models/player/arctic.mdl"] =  {
		size = {1, 1.13, 1},
		ang = {0, 0, 0},
		pos = {-1.3, 0, 1},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications1[ply_model] then
		return PS:ModifyModel(model_modifications1[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-1.3, 0, -0.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "affenmaske"
ITEM.Name = 'Affenmaske'
ITEM.Price = 800000
ITEM.Model = 'models/sal/halloween/monkey.mdl'
ITEM.Attachment = 'eyes'
ITEM.Weight = 2
ITEM.Tier3 = true

ITEM.TeamOnly = {
	[TEAM_GANGSTER] = true,
	[TEAM_GANGSTERBOSS] = true,
	[TEAM_THIEF] = true,
	[TEAM_MASTERTHIEF] = true,
	[TEAM_REBEL] = true,
	[TEAM_REBELBOSS] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true
}

local model_modifications2 = {
	["models/player/group03/female_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.2, 0, -2},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.2, 0, -2},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_02.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_03.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_04.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_05.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_07.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/group03/male_09.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2},
	},
	["models/player/gman_high.mdl"] = {
		size = {1.0299999713898, 1, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, -2},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -1},
	},
	["models/player/guerilla.mdl"] = {
		size = {1.1499999761581, 1, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, -1},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -0.80000001192093},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications2[ply_model] then
		return PS:ModifyModel(model_modifications2[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4.3, 0, -2}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "afro"
ITEM.Name = 'Afro'
ITEM.Price = 3000000
ITEM.Model = 'models/gmod_tower/afro.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"
ITEM.Tier3 = true

ITEM.TeamExclude = {
	[TEAM_SEK] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications3 = {
	["models/player/zombie_fast.mdl"] = {
		size = {0.69999998807907, 0.69999998807907, 0.69999998807907},
		ang = {0, 0, 0},
		pos = {-5.2199997901917, 0, 0.5},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-5, 0, 0},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications3[ply_model] then
		return PS:ModifyModel(model_modifications3[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4, 0, 3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "astronautenhelm"
ITEM.Name = 'Astronautenhelm'
ITEM.Price = 4000000
ITEM.Model = 'models/astronauthelmet/astronauthelmet.mdl'
ITEM.Attachment = 'eyes'
ITEM.Weight = 2
ITEM.Tier3 = true

ITEM.TeamExclude = {
	[TEAM_HOBOKING] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications4 = {
	["models/player/corpse1.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-3, 0, -5},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-4, 0, -6},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications4[ply_model] then
		return PS:ModifyModel(model_modifications4[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-3, 0, -6}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "cap01"
ITEM.Name = 'Cap (Schwarz)'
ITEM.Price = 60000
ITEM.Model = 'models/modified/hat07.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications5 = {
	["models/player/group01/male_01.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.3},
		pos = {-4, 0, 1.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/leet.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.3},
		pos = {-4.3, 0, 4},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.4},
		pos = {-4, 0, 1.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 10.96},
		pos = {-3.9, 0, 2},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 15.64},
		pos = {-4.2, 0, 1.65},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 18.78},
		pos = {-5.22, 0, 1.1},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {1.10, 1.10, 1.10},
		ang = {0, 0, 14.09},
		pos = {-4.6, 0, 1.5},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.09, 1.09, 1.09},
		ang = {0, 0, 9.4},
		pos = {-2.9, 0, 3},
	},
	["models/player/hostage/hostage_03.mdl"] = {
		size = {1.06, 1.06, 1.06},
		ang = {0, 0, 10.96},
		pos = {-4, 0, 1.5},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 14.09},
		pos = {-3.5, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 4.3},
	},
	["models/player/barney.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 7.83},
		pos = {-4.3, 0, 2.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications5[ply_model] then
		return PS:ModifyModel(model_modifications5[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 17.22}, pos = {-4, 0, 1.3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "cap02"
ITEM.Name = 'Cap (Weiß)'
ITEM.Price = 60000
ITEM.Model = 'models/modified/hat07.mdl'
ITEM.Skin = 3
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications6 = {
	["models/player/group01/male_01.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.3},
		pos = {-4, 0, 1.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/leet.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.3},
		pos = {-4.3, 0, 4},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.4},
		pos = {-4, 0, 1.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 10.96},
		pos = {-3.9, 0, 2},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 15.64},
		pos = {-4.2, 0, 1.65},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 18.78},
		pos = {-5.22, 0, 1.1},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {1.10, 1.10, 1.10},
		ang = {0, 0, 14.09},
		pos = {-4.6, 0, 1.5},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.09, 1.09, 1.09},
		ang = {0, 0, 9.4},
		pos = {-2.9, 0, 3},
	},
	["models/player/hostage/hostage_03.mdl"] = {
		size = {1.06, 1.06, 1.06},
		ang = {0, 0, 10.96},
		pos = {-4, 0, 1.5},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 14.09},
		pos = {-3.5, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 4.3},
	},
	["models/player/barney.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 7.83},
		pos = {-4.3, 0, 2.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications6[ply_model] then
		return PS:ModifyModel(model_modifications6[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 17.22}, pos = {-4, 0, 1.3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "cap03"
ITEM.Name = 'Cap (Grün)'
ITEM.Price = 55000
ITEM.Model = 'models/modified/hat07.mdl'
ITEM.Skin = 4
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications7 = {
	["models/player/group01/male_01.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.3},
		pos = {-4, 0, 1.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/leet.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.3},
		pos = {-4.3, 0, 4},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.4},
		pos = {-4, 0, 1.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 10.96},
		pos = {-3.9, 0, 2},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 15.64},
		pos = {-4.2, 0, 1.65},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 18.78},
		pos = {-5.22, 0, 1.1},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {1.10, 1.10, 1.10},
		ang = {0, 0, 14.09},
		pos = {-4.6, 0, 1.5},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.09, 1.09, 1.09},
		ang = {0, 0, 9.4},
		pos = {-2.9, 0, 3},
	},
	["models/player/hostage/hostage_03.mdl"] = {
		size = {1.06, 1.06, 1.06},
		ang = {0, 0, 10.96},
		pos = {-4, 0, 1.5},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 14.09},
		pos = {-3.5, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 4.3},
	},
	["models/player/barney.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 7.83},
		pos = {-4.3, 0, 2.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications7[ply_model] then
		return PS:ModifyModel(model_modifications7[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 17.22}, pos = {-4, 0, 1.3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "cap04"
ITEM.Name = 'Cap (Braun)'
ITEM.Price = 50000
ITEM.Model = 'models/modified/hat07.mdl'
ITEM.Skin = 8
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications8 = {
	["models/player/group01/male_01.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.3},
		pos = {-4, 0, 1.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/leet.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.3},
		pos = {-4.3, 0, 4},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {1.08, 1.08, 1.08},
		ang = {0, 0, 3.13},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 9.4},
		pos = {-4, 0, 1.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 10.96},
		pos = {-3.9, 0, 2},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 15.64},
		pos = {-4.2, 0, 1.65},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {1.07, 1.07, 1.07},
		ang = {0, 0, 14.09},
		pos = {-4, 0, 2},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 18.78},
		pos = {-5.22, 0, 1.1},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {1.10, 1.10, 1.10},
		ang = {0, 0, 14.09},
		pos = {-4.6, 0, 1.5},
	},
	["models/player/group01/male_09.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-3.95, 0, 2.2},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.09, 1.09, 1.09},
		ang = {0, 0, 9.4},
		pos = {-2.9, 0, 3},
	},
	["models/player/hostage/hostage_03.mdl"] = {
		size = {1.06, 1.06, 1.06},
		ang = {0, 0, 10.96},
		pos = {-4, 0, 1.5},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 14.09},
		pos = {-3.5, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.05, 1.05, 1.05},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 4.3},
	},
	["models/player/barney.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 7.83},
		pos = {-4.3, 0, 2.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1, 1.1, 1.1},
		ang = {0, 0, 9.39},
		pos = {-4, 0, 3},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications8[ply_model] then
		return PS:ModifyModel(model_modifications8[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 17.22}, pos = {-4, 0, 1.3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "cowboyhut"
ITEM.Name = 'Cowboyhut'
ITEM.Price = 600000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/cowboyhat.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications9 = {
	["models/player/leet.mdl"] = {
		size = {0.87, 0.85, 0.85},
		ang = {0, 0, 0},
		pos = {-2.9, 0, 5.22},
	},
	["models/player/alyx.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 17.22},
		pos = {-5, 0, 3.5},
	},
	["models/player/suits/male_07_open.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 17.22},
		pos = {-5.22, 0, 2.61},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 15.65},
		pos = {-5.22, 0, 2.61},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-2.61, 0, 0},
	},
	["models/player/mossman.mdl"] = {
		size = {0.85, 0.85, 0.85},
		ang = {0, 0, 14.09},
		pos = {-4.3, 0, 3},
	},
	["models/player/mossman_arctic.mdl"] = {
		size = {0.85, 0.85, 0.85},
		ang = {0, 0, 14.09},
		pos = {-4.3, 0, 3},
	},
	["models/player/mechanic.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 14.09},
		pos = {-5.22, 0, 2.61},
	},
	["models/player/barney.mdl"] = {
		size = {0.95, 0.95, 0.95},
		ang = {0, 0, 18.78},
		pos = {-5, 0, 3},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 18.78},
		pos = {-5.22, 0, 1},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 23.48},
		pos = {-5, 0, 3.2},
	},
	["models/player/group03/male_06.mdl"] =  {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 25.04},
		pos = {-5.22, 0, 4},
	},
	["models/player/phoenix.mdl"] =  {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 21.91},
		pos = {-5, 0, 4.8},
	},
	["models/player/guerilla.mdl"] =  {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 17.22},
		pos = {-5, 0, 5.1},
	},
	["models/player/arctic.mdl"] =  {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 21.91},
		pos = {-5, 0, 4.8},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications9[ply_model] then
		return PS:ModifyModel(model_modifications9[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {0.8, 0.8, 0.8}, ang = {0, 0, 0}, pos = {-3, 0, 4}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "deadmau501"
ITEM.Name = 'Deadmau5 (Rot)'
ITEM.Price = 800000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/deadmau5.mdl'
ITEM.Attachment = 'forward'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"
ITEM.Tier1 = true

ITEM.TeamOnly = {
	[TEAM_DJ] = true,
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	return PS:ModifyModel({size = {0.8, 0.8, 0.8}, ang = {0, 0, 0}, pos = {1, 0, 2.7}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "deadmau502"
ITEM.Name = 'Deadmau5 (Schwarz)'
ITEM.Price = 1000000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/deadmau5.mdl'
ITEM.Skin = 6
ITEM.Attachment = 'forward'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"
ITEM.Tier2 = true

ITEM.TeamOnly = {
	[TEAM_DJ] = true,
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	return PS:ModifyModel({size = {0.8, 0.8, 0.8}, ang = {0, 0, 0}, pos = {1, 0, 2.7}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "doktormaske01"
ITEM.Name = 'Doktormaske (Weiß)'
ITEM.Price = 650000
ITEM.Model = 'models/sal/halloween/doctor.mdl'
ITEM.Skin = 1
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Brillen"
ITEM.Tier2 = true

ITEM.TeamExclude = {
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications10 = {
	["models/player/leet.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, -0.5},
	},
	["models/player/hostage/hostage_04.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, -2},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -2},
	},
	["models/player/suits/male_04_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -1.5},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -2.2999999523163},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, -1.8899999856949},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 53.220001220703},
		pos = {-3, 0, -6},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		ang = {0, 0, 20.35000038147},
		pos = {-5, 0, -5},
	},
	["models/player/kleiner.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, -2},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -0.30000001192093},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {-6, 0, -3},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, -0.89999997615814},
	},
	["models/player/guerilla.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -0.69999998807907},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.5, 0, -0.69999998807907},
	},							
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications10[ply_model] then
		return PS:ModifyModel(model_modifications10[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4.5, 0, -2}}, ply, model, pos, ang)
end
PS:AddItem()
