ITEM.ID = "doktormaske02"
ITEM.Name = 'Doktormaske (Schwarz)'
ITEM.Price = 680000
ITEM.Model = 'models/sal/halloween/doctor.mdl'
ITEM.Skin = 2
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Brillen"
ITEM.Tier3 = true

ITEM.TeamExclude = {
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications1 = {
	["models/player/leet.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, -0.5},
	},
	["models/player/hostage/hostage_04.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, -2},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -2},
	},
	["models/player/suits/male_04_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -1.5},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -2.2999999523163},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, -1.8899999856949},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 53.220001220703},
		pos = {-3, 0, -6},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		ang = {0, 0, 20.35000038147},
		pos = {-5, 0, -5},
	},
	["models/player/kleiner.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, -2},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, -0.30000001192093},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {-6, 0, -3},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, -0.89999997615814},
	},
	["models/player/guerilla.mdl"] = {
		size = {1, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -0.69999998807907},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.5, 0, -0.69999998807907},
	},							
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications1[ply_model] then
		return PS:ModifyModel(model_modifications1[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4.5, 0, -2}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "eulenmaske"
ITEM.Name = 'Eulenmaske'
ITEM.Price = 2000000
ITEM.Model = 'models/sal/owl.mdl'
ITEM.Attachment = 'eyes'
ITEM.Weight = 2
ITEM.Tier1 = true

ITEM.TeamExclude = {
	[TEAM_HOBOKING] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications2 = {
	["models/player/leet.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-3.7999999523163, 0, -1},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-3, 0, -2.7999999523163},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-5, 0, -3},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-5, 0, -2},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, -4},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-4.5, 0, -2.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, -2},
	},
	["models/player/guerilla.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-5, 0, -2},
	},
	["models/player/arctic.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-4, 0, -2},
	},	
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications2[ply_model] then
		return PS:ModifyModel(model_modifications2[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {1.2, 1.1, 1.1}, ang = {0, 0, 0}, pos = {-4.1, 0, -3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "fedora01"
ITEM.Name = 'Fedora (Schwarz)'
ITEM.Price = 100000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/fedora.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications3 = {
	["models/player/group01/female_03.mdl"] = {
		size = {0.74, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.5},
	},
	["models/player/group01/male_01.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 2.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 2.6},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/leet.mdl"] = {
		size = {0.87, 0.9, 0.7},
		ang = {0, 0, 0},
		pos = {-3, 0, 3.5},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {0.73, 0.74, 0.7},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 2.6},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/alyx.mdl"] = {
		size = {0.83, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.6, 0, 2.6},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2.7},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 2.6},
	},
	["models/player/suits/male_07_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 2.6},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.6},
	},
	["models/player/suits/male_09_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.2, 0, 2.6},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {0.74, 0.71, 0.7},
		ang = {0, 0, 0},
		pos = {-2.7, 0, 2.6},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.6, 0.6, 0.6},
		ang = {0, 0, 9.4},
		pos = {-3.5, 0, 0},
	},
	["models/player/mossman.mdl"] = {
		size = {0.86, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-4.3, 0, 2.6},
	},
	["models/player/mossman_arctic.mdl"] = {
		size = {0.86, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-4.3, 0, 2.6},
	},
	["models/player/mechanic.mdl"] = {
		size = {0.8, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 4},
	},
	["models/player/barney.mdl"] = {
		size = {0.8, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 2.6},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.67, 0.67, 0.67},
		ang = {0, 0, 0},
		pos = {-4, 0, 1.2},
	},
	["models/player/odessa.mdl"] = {
		size = {0.78, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.2, 0, 2.3},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2.6},
	},
	["models/player/group03/male_02.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 2.6},
	},
	["models/player/group03/male_03.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.6},
	},
	["models/player/group03/male_04.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.65, 0, 2.6},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {0.85, 0.9, 0.75},
		ang = {0, 0, 0},
		pos = {-4, 0, 2},
	},
	["models/player/group03/male_08.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 0},
		pos = {-4, 0, 2},
	},
	["models/player/group03/male_09.mdl"] = {
		size = {0.75, 0.75, 0.75},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2},
	},
	["models/player/phoenix.mdl"] = {
		size = {0.8, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 3},
	},
	["models/player/guerilla.mdl"] = {
		size = {0.8, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-4.1, 0, 3.3},
	},
	["models/player/arctic.mdl"] = {
		size = {0.75, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 3.7},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications3[ply_model] then
		return PS:ModifyModel(model_modifications3[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {0.7, 0.7, 0.7}, ang = {0, 0, 0}, pos = {-3.5, 0, 2.6}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "fedora02"
ITEM.Name = 'Fedora (Weiß)'
ITEM.Price = 120000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/fedora.mdl'
ITEM.Skin = 1
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications4 = {
	["models/player/group01/female_03.mdl"] = {
		size = {0.74, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.5},
	},
	["models/player/group01/male_01.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 2.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 2.6},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/leet.mdl"] = {
		size = {0.87, 0.9, 0.7},
		ang = {0, 0, 0},
		pos = {-3, 0, 3.5},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {0.73, 0.74, 0.7},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 2.6},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/alyx.mdl"] = {
		size = {0.83, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.6, 0, 2.6},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2.7},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 2.6},
	},
	["models/player/suits/male_07_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 2.6},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.6},
	},
	["models/player/suits/male_09_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.2, 0, 2.6},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {0.74, 0.71, 0.7},
		ang = {0, 0, 0},
		pos = {-2.7, 0, 2.6},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.6, 0.6, 0.6},
		ang = {0, 0, 9.4},
		pos = {-3.5, 0, 0},
	},
	["models/player/mossman.mdl"] = {
		size = {0.86, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-4.3, 0, 2.6},
	},
	["models/player/mossman_arctic.mdl"] = {
		size = {0.86, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-4.3, 0, 2.6},
	},
	["models/player/mechanic.mdl"] = {
		size = {0.8, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 4},
	},
	["models/player/barney.mdl"] = {
		size = {0.8, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 2.6},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.67, 0.67, 0.67},
		ang = {0, 0, 0},
		pos = {-4, 0, 1.2},
	},
	["models/player/odessa.mdl"] = {
		size = {0.78, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.2, 0, 2.3},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2.6},
	},
	["models/player/group03/male_02.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 2.6},
	},
	["models/player/group03/male_03.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.6},
	},
	["models/player/group03/male_04.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.65, 0, 2.6},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {0.85, 0.9, 0.75},
		ang = {0, 0, 0},
		pos = {-4, 0, 2},
	},
	["models/player/group03/male_08.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 0},
		pos = {-4, 0, 2},
	},
	["models/player/group03/male_09.mdl"] = {
		size = {0.75, 0.75, 0.75},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2},
	},
	["models/player/phoenix.mdl"] = {
		size = {0.8, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 3},
	},
	["models/player/guerilla.mdl"] = {
		size = {0.8, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-4.1, 0, 3.3},
	},
	["models/player/arctic.mdl"] = {
		size = {0.75, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 3.7},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications4[ply_model] then
		return PS:ModifyModel(model_modifications4[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {0.7, 0.7, 0.7}, ang = {0, 0, 0}, pos = {-3.5, 0, 2.6}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "fedora03"
ITEM.Name = 'Fedora (Grau)'
ITEM.Price = 110000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/fedora.mdl'
ITEM.Skin = 3
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications5 = {
	["models/player/group01/female_03.mdl"] = {
		size = {0.74, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.5},
	},
	["models/player/group01/male_01.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 2.6},
	},
	["models/player/group01/male_06.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 2.6},
	},
	["models/player/group01/male_08.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/leet.mdl"] = {
		size = {0.87, 0.9, 0.7},
		ang = {0, 0, 0},
		pos = {-3, 0, 3.5},
	},
	["models/player/group02/male_06.mdl"] = {
		size = {0.73, 0.74, 0.7},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 2.6},
	},
	["models/player/group02/male_08.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/alyx.mdl"] = {
		size = {0.83, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.6, 0, 2.6},
	},
	["models/player/suits/male_01_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2.7},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.7, 0, 2.6},
	},
	["models/player/suits/male_06_open.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 2.6},
	},
	["models/player/suits/male_07_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 2.6},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.6},
	},
	["models/player/suits/male_09_open.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4.2, 0, 2.6},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {0.74, 0.71, 0.7},
		ang = {0, 0, 0},
		pos = {-2.7, 0, 2.6},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.6, 0.6, 0.6},
		ang = {0, 0, 9.4},
		pos = {-3.5, 0, 0},
	},
	["models/player/mossman.mdl"] = {
		size = {0.86, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-4.3, 0, 2.6},
	},
	["models/player/mossman_arctic.mdl"] = {
		size = {0.86, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-4.3, 0, 2.6},
	},
	["models/player/mechanic.mdl"] = {
		size = {0.8, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 4},
	},
	["models/player/barney.mdl"] = {
		size = {0.8, 0.73, 0.7},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 2.6},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.67, 0.67, 0.67},
		ang = {0, 0, 0},
		pos = {-4, 0, 1.2},
	},
	["models/player/odessa.mdl"] = {
		size = {0.78, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.2, 0, 2.3},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2.6},
	},
	["models/player/group03/male_02.mdl"] = {
		size = {0.75, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 2.6},
	},
	["models/player/group03/male_03.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-4, 0, 2.6},
	},
	["models/player/group03/male_04.mdl"] = {
		size = {0.7, 0.7, 0.7},
		ang = {0, 0, 0},
		pos = {-3.65, 0, 2.6},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {0.85, 0.9, 0.75},
		ang = {0, 0, 0},
		pos = {-4, 0, 2},
	},
	["models/player/group03/male_08.mdl"] = {
		size = {0.8, 0.8, 0.8},
		ang = {0, 0, 0},
		pos = {-4, 0, 2},
	},
	["models/player/group03/male_09.mdl"] = {
		size = {0.75, 0.75, 0.75},
		ang = {0, 0, 0},
		pos = {-3.9, 0, 2},
	},
	["models/player/phoenix.mdl"] = {
		size = {0.8, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-3.6, 0, 3},
	},
	["models/player/guerilla.mdl"] = {
		size = {0.8, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-4.1, 0, 3.3},
	},
	["models/player/arctic.mdl"] = {
		size = {0.75, 0.8, 0.75},
		ang = {0, 0, 0},
		pos = {-3.8, 0, 3.7},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications5[ply_model] then
		return PS:ModifyModel(model_modifications5[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {0.7, 0.7, 0.7}, ang = {0, 0, 0}, pos = {-3.5, 0, 2.6}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "hasenohren"
ITEM.Name = 'Hasenohren'
ITEM.Price = 1000000
ITEM.Model = 'models/captainbigbutt/skeyler/hats/bunny_ears.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Zubehör"
ITEM.Tier2 = true

local model_modifications6 = {
	["models/player/hostage/hostage_04.mdl"] = {
		size = {0.60000002384186, 0.60000002384186, 0.60000002384186},
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.60000002384186, 0.60000002384186, 0.60000002384186},
		ang = {0, 0, 7.8299999237061},
		pos = {-4, 0, -0.5},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.60000002384186, 0.60000002384186, 0.60000002384186},
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},
	["models/player/barney.mdl"] = {
		ang = {0, 253.57000732422, 0},
		pos = {-4, 0, 3.5},
	},	
}

if TEAM_THEATER then
	ITEM.TeamExclude = {}
	ITEM.TeamExclude[TEAM_THEATER] = true
end

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications6[ply_model] then
		return PS:ModifyModel(model_modifications6[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {0.6, 0.6, 0.6}, ang = {0, 0, 0}, pos = {-4, 0, 3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "helm01"
ITEM.Name = 'Helm (Schwarz)'
ITEM.Price = 800000
ITEM.Model = 'models/dean/gtaiv/helmet.mdl'
ITEM.Attachment = 'eyes'
ITEM.Weight = 2

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications7 = {
	["models/player/leet.mdl"] = {
		size = {1.1000000238419, 1, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-4, 0, 1.7000000476837},
	},
	["models/player/suits/male_06_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.20000000298023},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, 0.30000001192093},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 20.35000038147},
		pos = {-5, 0, -3},
	},
	["models/player/mossman.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, 0},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, 1.5},
	},
	["models/player/barney.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.20000000298023},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-4, 0, -1},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.30000001192093},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, 1},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},							
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications7[ply_model] then
		return PS:ModifyModel(model_modifications7[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4, 0, 0}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "helm02"
ITEM.Name = 'Helm (Weiß)'
ITEM.Price = 800000
ITEM.Model = 'models/dean/gtaiv/helmet.mdl'
ITEM.Skin = 2
ITEM.Attachment = 'eyes'
ITEM.Weight = 2

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications8 = {
	["models/player/leet.mdl"] = {
		size = {1.1000000238419, 1, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-4, 0, 1.7000000476837},
	},
	["models/player/suits/male_06_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.20000000298023},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, 0.30000001192093},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 20.35000038147},
		pos = {-5, 0, -3},
	},
	["models/player/mossman.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, 0},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, 1.5},
	},
	["models/player/barney.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.20000000298023},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-4, 0, -1},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.30000001192093},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, 1},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},							
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications8[ply_model] then
		return PS:ModifyModel(model_modifications8[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4, 0, 0}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "helm03"
ITEM.Name = 'Helm (Rot)'
ITEM.Price = 800000
ITEM.Model = 'models/dean/gtaiv/helmet.mdl'
ITEM.Skin = 3
ITEM.Attachment = 'eyes'
ITEM.Weight = 2

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications9 = {
	["models/player/leet.mdl"] = {
		size = {1.1000000238419, 1, 1.1000000238419},
		ang = {0, 0, 0},
		pos = {-4, 0, 1.7000000476837},
	},
	["models/player/suits/male_06_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.20000000298023},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, 0.30000001192093},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 20.35000038147},
		pos = {-5, 0, -3},
	},
	["models/player/mossman.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, 0},
	},
	["models/player/mossman_arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4.3000001907349, 0, 0},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, 1.5},
	},
	["models/player/barney.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.20000000298023},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.80000001192093, 0.80000001192093, 0.80000001192093},
		ang = {0, 0, 0},
		pos = {-4, 0, -1},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 0.30000001192093},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {-5, 0, 1},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-4, 0, 1},
	},							
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications9[ply_model] then
		return PS:ModifyModel(model_modifications9[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-4, 0, 0}}, ply, model, pos, ang)
end
PS:AddItem()
