ITEM.ID = "kopfhoerer03"
ITEM.Name = 'Kopfhörer (Grün)'
ITEM.Price = 285000
ITEM.Model = 'models/modified/headphones.mdl'
ITEM.Skin = 2
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

local model_modifications1 = {
	["models/player/leet.mdl"] = {
		size = {1, 1.1, 1},
		ang = {0, 0, 0},
		pos = {-2.5, 0, 1.5},
	},
	["models/player/hostage/hostage_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/group02/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3.5, 0, -0.2},
	},
	["models/player/suits/male_06_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3.5, 0, 0},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2.5, 0, 0},
	},
	["models/player/corpse1.mdl"] = {
		size = {1, 0.9, 1},
		ang = {0, 0, 0},
		pos = {-3, 0, -0.5},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {1, 0.9, 1},
		ang = {0, 0, 23.48},
		pos = {-2.5, 0, -3},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		size = {1, 1.1, 1},
		ang = {0, 0, 15.65},
		pos = {-4.9, 0, -1},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 6.26},
		pos = {-3.5, 0, 1},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {1, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-3.5, 0, -2},
	},
	["models/player/guard_pack/guard_09.mdl"] = {
		size = {1, 1, 1.2},
		ang = {0, 0, 0},
		pos = {-3, 0, -0.5},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {1, 1, 1.05},
		ang = {0, 0, 0},
		pos = {-3.5, 0, -0.5},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, -0.2},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {1, 1., 1.07},
		ang = {0, 0, 0},
		pos = {-3, 0, -0.3},
	},
	["models/player/group03/male_08.mdl"] = {
		size = {1, 1, 1.05},
		ang = {0, 0, 0},
		pos = {-3.2, 0, -0.5},
	},
	["models/player/gman_high.mdl"] = {
		size = {1, 0.9, 1.07},
		ang = {0, 0, 0},
		pos = {-3, 0.1, -0.2},
	},
	["models/player/phoenix.mdl"] = {
		size = {1, 1, 1.1},
		ang = {0, 0, 0},
		pos = {-3, 0, 0.5},
	},
	["models/player/guerilla.mdl"] = {
		size = {1, 1, 1.1},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 0},
	},
	["models/player/arctic.mdl"] = {
		size = {1, 1, 1-1},
		ang = {0, 0, 0},
		pos = {-3, 0, 0.3},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications1[ply_model] then
		return PS:ModifyModel(model_modifications1[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-3.4, 0, -0.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "kopfhoerer04"
ITEM.Name = 'Kopfhörer (Gelb)'
ITEM.Price = 280000
ITEM.Model = 'models/modified/headphones.mdl'
ITEM.Skin = 3
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

local model_modifications2 = {
	["models/player/leet.mdl"] = {
		size = {1, 1.1, 1},
		ang = {0, 0, 0},
		pos = {-2.5, 0, 1.5},
	},
	["models/player/hostage/hostage_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/group02/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3.5, 0, -0.2},
	},
	["models/player/suits/male_06_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3.5, 0, 0},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2.5, 0, 0},
	},
	["models/player/corpse1.mdl"] = {
		size = {1, 0.9, 1},
		ang = {0, 0, 0},
		pos = {-3, 0, -0.5},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {1, 0.9, 1},
		ang = {0, 0, 23.48},
		pos = {-2.5, 0, -3},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		size = {1, 1.1, 1},
		ang = {0, 0, 15.65},
		pos = {-4.9, 0, -1},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 6.26},
		pos = {-3.5, 0, 1},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {1, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-3.5, 0, -2},
	},
	["models/player/guard_pack/guard_09.mdl"] = {
		size = {1, 1, 1.2},
		ang = {0, 0, 0},
		pos = {-3, 0, -0.5},
	},
	["models/player/group03/male_01.mdl"] = {
		size = {1, 1, 1.05},
		ang = {0, 0, 0},
		pos = {-3.5, 0, -0.5},
	},
	["models/player/group03/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 0, -0.2},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {1, 1., 1.07},
		ang = {0, 0, 0},
		pos = {-3, 0, -0.3},
	},
	["models/player/group03/male_08.mdl"] = {
		size = {1, 1, 1.05},
		ang = {0, 0, 0},
		pos = {-3.2, 0, -0.5},
	},
	["models/player/gman_high.mdl"] = {
		size = {1, 0.9, 1.07},
		ang = {0, 0, 0},
		pos = {-3, 0.1, -0.2},
	},
	["models/player/phoenix.mdl"] = {
		size = {1, 1, 1.1},
		ang = {0, 0, 0},
		pos = {-3, 0, 0.5},
	},
	["models/player/guerilla.mdl"] = {
		size = {1, 1, 1.1},
		ang = {0, 0, 0},
		pos = {-3.5, 0, 0},
	},
	["models/player/arctic.mdl"] = {
		size = {1, 1, 1-1},
		ang = {0, 0, 0},
		pos = {-3, 0, 0.3},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications2[ply_model] then
		return PS:ModifyModel(model_modifications2[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-3.4, 0, -0.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "krone"
ITEM.Name = 'Krone'
ITEM.Price = 1000000
ITEM.Model = 'models/lordvipes/peachcrown/peachcrown.mdl'
ITEM.Attachment = 'mouth'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"
ITEM.Tier2 = true

ITEM.TeamOnly = {
	[TEAM_MAYOR] = true,
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	return PS:ModifyModel({size = {0.9, 0.8, 0.8}, ang = {0, 0, 3.13}, pos = {-4, 0.4, 5.3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "labertaschenhut"
ITEM.Name = 'Labertaschenhut'
ITEM.Price = 900000
ITEM.Model = 'models/duncehat/duncehat.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"
ITEM.Tier2 = true

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications3 = {
	["models/player/leet.mdl"] = {
		ang = {0, 0, 7.8299999237061},
		pos = {-3, 0, 4},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 25},
		pos = {-3.5, 0, 0},
	},
	["models/player/suits/male_08_open.mdl"] = {
		ang = {0, 0, 25},
		pos = {-3.5, 0, 0},
	},
	["models/player/suits/male_09_open.mdl"] = {
		ang = {0, 0, 25},
		pos = {-3.5, 0, 0},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 25},
		pos = {-1.7000000476837, 0, 0},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 32.869998931885},
		pos = {-3, 0, -2},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 25},
		pos = {-4.3000001907349, 0, 2},
	},
	["models/player/barney.mdl"] = {
		ang = {0, 0, 25},
		pos = {-3.2000000476837, 0, 1},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 25},
		pos = {-3.4000000953674, 0, -1},
	},
	["models/player/group03/male_01.mdl"] = {
		ang = {0, 0, 25},
		pos = {-3, 0, 0},
	},
	["models/player/group03/male_06.mdl"] = {
		ang = {0, 0, 25},
		pos = {-3.5, 0, 1},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.0499999523163, 1, 1},
		ang = {0, 0, 25},
		pos = {-3, 0, 1.2000000476837},
	},
	["models/player/guerilla.mdl"] = {
		size = {1.1000000238419, 1, 1},
		ang = {0, 0, 25},
		pos = {-3, 0, 1},
	},				
}

function ITEM:OnEquip(ply, modifications)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications3[ply_model] then
		return PS:ModifyModel(model_modifications3[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 25}, pos = {-3, 0, 1}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "luxusbrille"
ITEM.Name = 'Luxusbrille'
ITEM.Price = 180000
ITEM.Model = 'models/captainbigbutt/skeyler/accessories/glasses02.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Brillen"
ITEM.TeamExclude = {
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_ZOLL] = true,
}

local model_modifications4 = {
	["models/player/leet.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-0.5, 0, 0.5},
	},
	["models/player/hostage/hostage_04.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-0.5, 0, -1},
	},
	["models/player/suits/male_04_open.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-2, 0, -0.5},
	},
	["models/player/suits/male_05_open.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/suits/male_07_open.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/suits/male_08_open.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {0, 0, -0.5},
	},
	["models/player/corpse1.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-1.5, 0, -0.3},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 37.57},
		pos = {-2, 0, -2},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 18.78},
		pos = {-2.4, 0, -2.4},
	},
	["models/player/mechanic.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-2, 0, 1},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 10.96},
		pos = {-2, 0, -2},
	},
	["models/player/clannypolice/male_02.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-1.8, 0, -1},
	},
	["models/player/clannypolice/male_04.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 7.83},
		pos = {-1.5, 0, -0.7},
	},
	["models/player/clannypolice/male_05.mdl"] = {
		size = {0.9, 0.9, 1},
		ang = {0, 0, 7.83},
		pos = {-1.9, 0, -1},
	},
	["models/player/clannypolice/male_07.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 6.26},
		pos = {-1.5, 0, -1.5},
	},
	["models/player/clannypolice/male_08.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/humans/mg_mafia/male_07.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-1.2, 0, -1.5},
	},
	["models/humans/mg_mafia/male_08.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-1.54, 0, -1.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-0.5, 0, 0.2},
	},
	["models/player/guerilla.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0.3},
	},
	["models/player/arctic.mdl"] = {
		size = {0.9, 0.9, 0.9},
		ang = {0, 0, 0},
		pos = {-1, 0, 0.4},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications4[ply_model] then
		return PS:ModifyModel(model_modifications4[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {0.9, 0.9, 0.9}, ang = {0, 0, 0}, pos = {-1, 0, -1}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "militaershut"
ITEM.Name = 'Militärshut'
ITEM.Price = 220000
ITEM.Model = 'models/fallout 3/polish_beret.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

if TEAM_THEATER then
	ITEM.TeamExclude[TEAM_THEATER] = true
end

local model_modifications5 = {			
	["models/player/leet.mdl"] = {
		size = {1.2000000476837, 1.0499999523163, 1},
		ang = {0, 0, 0},
		pos = {-2.5, 1.5, 5},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.2000000476837, 1.0499999523163, 1},
		ang = {0, 0, 0},
		pos = {-2, 1.5, 3},
	},
	["models/player/zombie_fast.mdl"] = {
		ang = {0, 0, 18.780000686646},
		pos = {-4, 1.5, 0},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 1.3999999761581, 4},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {-3, 1.5, 0.5},
	},
	["models/player/group03/male_06.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 3.2999999523163},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},
	["models/player/guerilla.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},
	["models/player/arctic.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-3, 1.5, 4},
	},		
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications5[ply_model] then
		return PS:ModifyModel(model_modifications5[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {1.2, 1.05, 1}, ang = {0, 0, 0}, pos = {-3, 1.5, 3}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "muetze01"
ITEM.Name = 'Mütze (Rot)'
ITEM.Price = 90000
ITEM.Model = 'models/modified/hat03.mdl'
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications6 = {
	["models/player/leet.mdl"] = {
		size = {1.2000000476837, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.0999999046326, 0, 4.4000000953674},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.0499999523163, 1, 1},
		ang = {0, 0, 0},
		pos = {-3.2000000476837, 0, 2},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.94999998807907, 0.80000001192093},
		ang = {0, 0, 17.219999313354},
		pos = {-4, 0, -1},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 0.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, 3},
	},	
	["models/player/guerilla.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 3},
	},			
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications6[ply_model] then
		return PS:ModifyModel(model_modifications6[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {1.1, 1, 1}, ang = {0, 0, 0}, pos = {-4.5, 0, 2.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "muetze02"
ITEM.Name = 'Mütze (Blau)'
ITEM.Price = 85000
ITEM.Model = 'models/modified/hat03.mdl'
ITEM.Skin = 1
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications7 = {
	["models/player/leet.mdl"] = {
		size = {1.2000000476837, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.0999999046326, 0, 4.4000000953674},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.0499999523163, 1, 1},
		ang = {0, 0, 0},
		pos = {-3.2000000476837, 0, 2},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.94999998807907, 0.80000001192093},
		ang = {0, 0, 17.219999313354},
		pos = {-4, 0, -1},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 0.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, 3},
	},	
	["models/player/guerilla.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 3},
	},			
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications7[ply_model] then
		return PS:ModifyModel(model_modifications7[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {1.1, 1, 1}, ang = {0, 0, 0}, pos = {-4.5, 0, 2.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "muetze03"
ITEM.Name = 'Mütze (Weiß)'
ITEM.Price = 80000
ITEM.Model = 'models/modified/hat03.mdl'
ITEM.Skin = 3
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications8 = {
	["models/player/leet.mdl"] = {
		size = {1.2000000476837, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.0999999046326, 0, 4.4000000953674},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.0499999523163, 1, 1},
		ang = {0, 0, 0},
		pos = {-3.2000000476837, 0, 2},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.94999998807907, 0.80000001192093},
		ang = {0, 0, 17.219999313354},
		pos = {-4, 0, -1},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 0.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, 3},
	},	
	["models/player/guerilla.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 3},
	},			
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications8[ply_model] then
		return PS:ModifyModel(model_modifications8[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {1.1, 1, 1}, ang = {0, 0, 0}, pos = {-4.5, 0, 2.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "muetze04"
ITEM.Name = 'Mütze (Grau)'
ITEM.Price = 90000
ITEM.Model = 'models/modified/hat03.mdl'
ITEM.Skin = 4
ITEM.Attachment = 'eyes'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Kopf"

ITEM.TeamExclude = {
	[TEAM_TERROR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_POLICE] = true,
	[TEAM_CHIEF] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true,
	[TEAM_SEK] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_MAFIOSO] = true,
	[TEAM_MAFIABOSS] = true,
}

local model_modifications9 = {
	["models/player/leet.mdl"] = {
		size = {1.2000000476837, 1, 1},
		ang = {0, 0, 0},
		pos = {-4.0999999046326, 0, 4.4000000953674},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		size = {1.0499999523163, 1, 1},
		ang = {0, 0, 0},
		pos = {-3.2000000476837, 0, 2},
	},
	["models/player/zombie_fast.mdl"] = {
		size = {0.80000001192093, 0.94999998807907, 0.80000001192093},
		ang = {0, 0, 17.219999313354},
		pos = {-4, 0, -1},
	},
	["models/player/mechanic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/soldier_stripped.mdl"] = {
		size = {0.89999997615814, 0.89999997615814, 0.89999997615814},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 0.5},
	},
	["models/player/phoenix.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4, 0, 3},
	},	
	["models/player/guerilla.mdl"] = {
		size = {1.2000000476837, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-5, 0, 3},
	},
	["models/player/arctic.mdl"] = {
		size = {1.1000000238419, 1.1000000238419, 1},
		ang = {0, 0, 0},
		pos = {-4.5, 0, 3},
	},			
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications9[ply_model] then
		return PS:ModifyModel(model_modifications9[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({size = {1.1, 1, 1}, ang = {0, 0, 0}, pos = {-4.5, 0, 2.5}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "mundschutz01"
ITEM.Name = 'Mundschutz (Blau)'
ITEM.Price = 320000
ITEM.Model = 'models/rebs/maske/maske.mdl'
ITEM.Attachment = 'mouth'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Mund"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications10 = {
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, -0.5},
	},
	["models/player/magnusson.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.8, 0, -0.6},
	},
	["models/player/leet.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.7, 0, 1.3},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, 0.5},
	},
	["models/player/suits/male_02_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0},
	},
	["models/player/suits/male_03_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0.2},
	},
	["models/player/suits/male_04_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0.5},
	},
	["models/player/suits/male_05_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0.2},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0.1, 0.2},
	},
	["models/player/suits/male_08_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0.1},
	},
	["models/player/suits/male_09_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0.5},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0.2, 0.2},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {0.5, 0, 0.3},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, -0.5},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 2},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -0.2},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/breen.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0.2, -0.2},
	},
	["models/player/clannypolice/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.3, 0, 0},
	},
	["models/player/clannypolice/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0.5},
	},
	["models/player/clannypolice/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0, 0},
	},
	["models/player/clannypolice/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0},
	},
	["models/player/clannypolice/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0.1, 0},
	},
	["models/player/clannypolice/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0.3},
	},
	["models/player/swat.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, 1},
	},
	["models/player/riot.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, 1},
	},
	["models/player/urban.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, 0.6},
	},
	["models/taggart/police01/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0, 0},
	},
	["models/taggart/police01/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0},
	},
	["models/taggart/police01/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0},
	},
	["models/taggart/police01/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0},
	},
	["models/taggart/police01/male_03.md"] = {
		ang = {0, 0, 0},
		pos = {-0.9, -0.1, 0},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.7, 0, 0.3},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.8, 0.2, -0.5},
	},
	["models/humans/mg_mafia/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {0.3, 0, 0},
	},
	["models/humans/mg_mafia/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.9, 0.1, 0},
	},
	["models/humans/mg_mafia/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, 1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.7, 0, 1.5},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.8, 0, 1.5},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications10[ply_model] then
		return PS:ModifyModel(model_modifications10[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-0.3, 0, 0}}, ply, model, pos, ang)
end
PS:AddItem()


ITEM.ID = "mundschutz02"
ITEM.Name = 'Mundschutz (Schwarz)'
ITEM.Price = 340000
ITEM.Model = 'models/rebs/maske/maske.mdl'
ITEM.Skin = 1
ITEM.Attachment = 'mouth'
ITEM.MaxEquip = 1
ITEM.EquipGroup = "Mund"

ITEM.TeamExclude = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
}

local model_modifications11 = {
	["models/player/group01/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, -0.5},
	},
	["models/player/magnusson.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.8, 0, -0.6},
	},
	["models/player/leet.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.7, 0, 1.3},
	},
	["models/player_moxxi.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, 0.5},
	},
	["models/player/suits/male_02_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0},
	},
	["models/player/suits/male_03_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0.2},
	},
	["models/player/suits/male_04_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0.5},
	},
	["models/player/suits/male_05_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0.2},
	},
	["models/player/suits/male_07_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0.1, 0.2},
	},
	["models/player/suits/male_08_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0.1},
	},
	["models/player/suits/male_09_open.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0.5},
	},
	["models/player/eli.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0.2, 0.2},
	},
	["models/player/hostage/hostage_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {0.5, 0, 0.3},
	},
	["models/jessev92/kuma/characters/osama_ply.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, -0.5},
	},
	["models/player/mechanic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 2},
	},
	["models/player/monk.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, -0.2},
	},
	["models/player/soldier_stripped.mdl"] = {
		ang = {0, 0, 0},
		pos = {-2, 0, -1},
	},
	["models/player/breen.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0.2, -0.2},
	},
	["models/player/clannypolice/male_02.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.3, 0, 0},
	},
	["models/player/clannypolice/male_04.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.2, 0, 0.5},
	},
	["models/player/clannypolice/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0, 0},
	},
	["models/player/clannypolice/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0},
	},
	["models/player/clannypolice/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0.1, 0},
	},
	["models/player/clannypolice/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0.3},
	},
	["models/player/swat.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, 1},
	},
	["models/player/riot.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, 1},
	},
	["models/player/urban.mdl"] = {
		ang = {0, 0, 0},
		pos = {0, 0, 0.6},
	},
	["models/taggart/police01/male_05.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.6, 0, 0},
	},
	["models/taggart/police01/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.5, 0, 0},
	},
	["models/taggart/police01/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1.7, 0, 0},
	},
	["models/taggart/police01/male_09.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0},
	},
	["models/taggart/police01/male_03.md"] = {
		ang = {0, 0, 0},
		pos = {-0.9, -0.1, 0},
	},
	["models/player/group03/female_01.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.7, 0, 0.3},
	},
	["models/player/group03/female_03.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.8, 0.2, -0.5},
	},
	["models/humans/mg_mafia/male_06.mdl"] = {
		ang = {0, 0, 0},
		pos = {0.3, 0, 0},
	},
	["models/humans/mg_mafia/male_07.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.9, 0.1, 0},
	},
	["models/humans/mg_mafia/male_08.mdl"] = {
		ang = {0, 0, 0},
		pos = {-1, 0, 0},
	},
	["models/player/phoenix.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.5, 0, 1},
	},
	["models/player/guerilla.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.7, 0, 1.5},
	},
	["models/player/arctic.mdl"] = {
		ang = {0, 0, 0},
		pos = {-0.8, 0, 1.5},
	},
}

function ITEM:OnEquip(ply)
	if ply:Alive() then
		ply:PS_AddClientsideModel(self.ID)
	end
end

function ITEM:OnHolster(ply)
	ply:PS_RemoveClientsideModel(self.ID)
end

function ITEM:ModifyClientsideModel(ply, model, pos, ang)
	local ply_model = ply:GetModel()
	if model_modifications11[ply_model] then
		return PS:ModifyModel(model_modifications11[ply_model], ply, model, pos, ang)
	end
	return PS:ModifyModel({ang = {0, 0, 0}, pos = {-0.3, 0, 0}}, ply, model, pos, ang)
end
PS:AddItem()
