surface.CreateFont("DBonus_SegoeUI_16", {font = "Segoe UI", size = 16, weight = 500, antialias = true})
surface.CreateFont("DBonus_SegoeUI_20", {font = "Segoe UI", size = 20, weight = 600, antialias = true})
surface.CreateFont("DBonus_SegoeUI_30", {font = "Segoe UI", size = 30, weight = 550, antialias = true})
surface.CreateFont("DBonus_SegoeUI_55", {font = "Segoe UI", size = 55, weight = 500, antialias = true})
surface.CreateFont("DBonus_SegoeUI_85", {font = "Segoe UI", size = 85, weight = 500, antialias = true})

local daily_login_hide = CreateClientConVar("cl_daily_login_hide", 0, FCVAR_ARCHIVE)

local dmenu
local function OpenDailyLoginMenu()
	if daily_login_hide:GetBool() or IsValid(dmenu) then return end
	local day_count = #DBonus.Bonuses
	local max_reward = 0
	for i=1, #DBonus.Bonuses do
		local max = #DBonus.Bonuses[i]
		if max > max_reward then
			max_reward = max
		end
	end
	local cur_day = net.ReadUInt(5)
	local can_claim = net.ReadBool()
	local size_x, size_y = math.Clamp(100 + day_count * 120, 220, ScrW()), 125 + (max_reward * 110)
	dmenu = vgui.Create("DFrame")
	dmenu:SetTitle("")
	dmenu:ShowCloseButton(false)
	dmenu:SetDraggable(false)
	dmenu:SetSize(size_x, size_y)
	dmenu:Center()
	dmenu:MakePopup()
	dmenu:ParentToHUD()
	local char1, char2 = string.char(226, 152, 145), string.char(226, 152, 146)
	dmenu.Paint = function(self, wide, tall)
		draw.RoundedBoxEx(8, 0, 0, wide, 40, Color(47, 54, 76, 255), true, true)
		draw.SimpleText("Tägliche Login-Belohnung", "DBonus_SegoeUI_20", wide / 2, 0, color_white, TEXT_ALIGN_CENTER)
		draw.SimpleText("Schau morgen nochmal vorbei, um neue Belohnungen zu erhalten!", "DBonus_SegoeUI_16", wide / 2, 22, color_white, TEXT_ALIGN_CENTER)
		draw.RoundedBoxEx(8, 0, tall - 85, wide, 70, Color(47, 54, 76, 255), false, false, true, true)
		surface.SetDrawColor(20, 24, 33, 255)
		surface.DrawRect(0, 40, wide, tall - 125)
		for i=1, #DBonus.Bonuses do
			draw.SimpleText("Tag "..i, "DBonus_SegoeUI_20", i * 120 - 50, tall - 85, color_white)
			surface.SetDrawColor(25, 29, 38, 255)
			surface.DrawRect(i * 120 - 70, 40, 110, tall - 125)
			for a=1, #DBonus.Bonuses[i] do
				local bonus = DBonus.Bonuses[i]
				DBonus.RewardPaint[bonus[a].Type](self, i * 120 - 70, tall - 80 - a * 110, bonus[a])
			end
			if cur_day >= i then
				draw.SimpleText(char1, "DBonus_SegoeUI_30", i * 120 - 5, tall - 90, Color(0, 200, 0, 255))
			else
				draw.SimpleText(char2, "DBonus_SegoeUI_30", i * 120 - 5, tall - 90, Color(200, 0, 0, 255))
				surface.SetDrawColor(0, 0, 0, 170)
				surface.DrawRect(i * 120 - 70, 40, 110, tall - 125)
			end
		end
	end
	local button = vgui.Create("DButton", dmenu)
	button:SetFont("DBonus_SegoeUI_16")
	if can_claim then
		button:SetText("Belohnung einfordern")
	else
		button:SetText("Fenster schließen")
	end
	button:SetColor(Color(250, 250, 250, 255))
	button:SetSize(125, 30)
	button:SetPos(dmenu:GetWide() / 2 - button:GetWide() / 2, dmenu:GetTall() - 60)
	button.Paint = function(self, wide, tall)
		surface.SetDrawColor(self:IsHovered() and Color(99, 102, 111, 255) or Color(69, 72, 81, 255))
		surface.DrawRect(0, 0, wide, tall)
		surface.SetDrawColor(50, 50, 50, 255)
		surface.DrawOutlinedRect(0, 0, wide, tall)
	end
	button.DoClick = function(self)
		surface.PlaySound("ui/buttonclick.wav")
		if can_claim then
			net.Start("DBonus_ClaimBonus")
			net.SendToServer()
		end
		dmenu:Close()
	end
	local nametext = vgui.Create("DLabel", dmenu)
	nametext:SetFont("DBonus_SegoeUI_16")
	nametext:SetSize(530, 30)
	nametext:SetPos(dmenu:GetWide() / 2 - nametext:GetWide() / 2, dmenu:GetTall() - 37)
	nametext:SetText("Tipp: Wenn du in deinem Namen den \"[MG]\"-Tag trägst, erhältst du eine "..DBonus.BonusText.."% höhere Belohnung!")
	nametext:SetColor(Color(250, 250, 250, 255))
end
net.Receive("DBonus_OpenMenu", OpenDailyLoginMenu)