-- Farbiger Chat

net.Receive("DarkRP_ColoredText", function()
	local text = net.ReadTable()
	chat.AddText(unpack(text))
	chat.PlaySound()
end)

-- Behebt, dass clientside Ragdolls alle unterschiedliche Gewichte aufweisen.

hook.Add("CreateClientsideRagdoll", "DarkRP_ClientsideRagdollWeight", function(ent, rag)
	if ent:IsPlayer() then
		local phys = rag:GetPhysicsObject()
		if phys:IsValid() then
			phys:SetInertia(Vector(1, 1, 1))
			for i=1, rag:GetPhysicsObjectCount() do
				if IsValid(rag:GetPhysicsObject(i-1)) then
					rag:GetPhysicsObject(i-1):SetMass(12.7)
				end
			end
		end
	end
end)

-- Double Money-Events

surface.CreateFont("bonus_money_font", {font = "BebasNeue", size = 20, weight = 500, blursize = 0, scanlines = 0, antialias = true})

local hook_added = false
local screen_messages = {}
local function DrawBonusMoney()
	if table.IsEmpty(screen_messages) then
		hook_added = false
		hook.Remove("HUDPaint", "DarkRP_DrawBonusMoney")
	end
	local sys_time = SysTime()
	local font = "bonus_money_font"
	local scrh = ScrH()
	local offset = 0
	for k, v in pairs(screen_messages) do
		local time_left = v[2]
		if time_left < sys_time then
			screen_messages[k] = nil
		end
		local alpha = 255 - ((time_left - sys_time) * 255)
		local txt = v[1]
		surface.SetFont(font)
		local size = surface.GetTextSize(txt)
		draw.SimpleTextOutlined(txt, font, 320 - size / 2, (scrh - 161) + offset, Color(100, 255, 100, 255 - alpha), TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, Color(0, 0, 0, 255 - alpha))
		offset = offset - 20
	end
end

net.Receive("DarkRP_AddMoney", function()
	local money = net.ReadUInt(32)
	if money == 0 then return end
	table.insert(screen_messages, 1, {"+$"..string.Comma(money).." Bonus", SysTime() + 5})
	if !hook_added then
		hook_added = true
		hook.Add("HUDPaint", "DarkRP_DrawBonusMoney", DrawBonusMoney, HOOK_MONITOR_LOW or 2)
	end
end)