local mode = false
local entities = {}

local all_entities = {
	["glorifiedbanking_atm"] = true,
	["car_dealer"] = true,
	["npc_dealer"] = true,
	["vendingmachine_food"] = true,
	["vendingmachine_medic"] = true,
	["dumpster"] = true,
	["economy_alarm"] = true,
	["economy_bank"] = true,
	["npc_family"] = true,
	["npc_plantmarket"] = true,
	["gaspump"] = true,
	["itemstore_bank"] = true,
	["npc_dmv"] = true,
	["zrush_fuelbuyer_npc"] = true,
	["ammocrate"] = true,
	["armory"] = true,
	["wheel_of_luck"] = true,
	["double_or_nothing"] = true,
	["mr_roulette_base"] = true,
	["tow_platform"] = true,
	["mining_rock"] = true,
	["zmlab_methdropoff"] = true,
	["3d2dtext"] = true,
	["player"] = true,
}

concommand.Add("mg_admin_mode", function(ply)
	if !IsValid(ply) or !MG_DeveloperGroups[ply:GetUserGroup()] then return end
	mode = !mode
	if mode then
		entities = {}

		surface.CreateFont("MG_AdminMode", {font = "Roboto", size = 14, weight = 600, shadow = true})

		local function IsOnScreen(pos)
			local pos_x = pos.x
			local pos_y = pos.y
			return pos_x > 0 and pos_x < ScrW() and pos_y > 0 and pos_y < ScrH()
		end

		hook.Add("NetworkEntityCreated", "MG_AdminMode", function(ent)
			if all_entities[ent:GetClass()] then
				table.insert(entities, ent)
			end
		end)

		for _, v in ipairs(ents.GetAll()) do
			if all_entities[v:GetClass()] then
				table.insert(entities, v)
			end
		end

		local local_ply = LocalPlayer()
		hook.Add("HUDPaint", "MG_AdminMode", function()
			for _, ent in ipairs(entities) do
				if IsValid(ent) and local_ply != ent then
					local player = ent:IsPlayer()
					local pos = (player and ent:EyePos() or ent:GetPos()):ToScreen()
					if IsOnScreen(pos) then
						draw.SimpleText(player and ent:Name() or ent.PrintName or ent:GetClass(), "MG_AdminMode", pos.x, pos.y - 15, player and Color(0, 200, 0) or color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
						draw.RoundedBox(0, pos.x - 2, pos.y - 2, 4, 4, color_white)
					end
				else
					table.RemoveByValue(entities, ent)
				end
			end
		end)
	else
		entities = {}

		hook.Remove("HUDPaint", "MG_AdminMode")
		hook.Remove("NetworkEntityCreated", "MG_AdminMode")
	end

	chat.AddText(Color(0, 0, 0), "Adminmodus "..(mode and "aktiviert" or "deaktiviert")..".")
end)