local function ModernGamingOptions(CPanel)
	CPanel:AddControl("Label", {Text = "HUD:"})
	CPanel:AddControl("CheckBox", {Label = "Lockdown-Anzeige anzeigen", Command = "cl_lockdown"})
	CPanel:AddControl("CheckBox", {Label = "Spielzeit anzeigen", Command = "utime_enable"})
	CPanel:AddControl("CheckBox", {Label = "Levelleiste anzeigen", Command = "cl_progressbar"})
	CPanel:AddControl("CheckBox", {Label = "Befehle im Kontextmenü anzeigen", Command = "cl_cmenu_commands"})
	CPanel:AddControl("CheckBox", {Label = "Wirtschafts-HUD anzeigen", Command = "cl_showeconomy"})
	CPanel:AddControl("CheckBox", {Label = "Aussehen des Wirtschafts-HUDs", Command = "cl_economy_hud_simple", Type = "Int", Min = "0", Max = "2"})
	CPanel:AddControl("CheckBox", {Label = "Mapabstimmungen-HUD anzeigen", Command = "cl_showvotemap"})
	CPanel:AddControl("CheckBox", {Label = "Rebellions & Bandenkriegs-Informationen anzeigen", Command = "cl_showwarinfo"})
	CPanel:AddControl("CheckBox", {Label = "Geschwindigkeitsanzeige in Autos anzeigen", Command = "cl_speedometer"})
	CPanel:AddControl("CheckBox", {Label = "Tankfülle in Autos anzeigen", Command = "cl_fuelmeter"})
	CPanel:AddControl("CheckBox", {Label = "Installierte Türalarmanlagen anzeigen", Command = "cl_showalarm"})
	CPanel:AddControl("Label", {Text = "Anzeige:"})
	CPanel:AddControl("CheckBox", {Label = "Türbesitzer an der Vorderseite der Türen anzeigen", Command = "cl_showdoordisplay"})
	CPanel:AddControl("CheckBox", {Label = "Nur anzeigen, wenn man auf die Tür guckt", Command = "cl_doordisplay_performance"})
	CPanel:AddControl("CheckBox", {Label = "Feeds von Terminals nur beim Angucken anzeigen", Command = "cl_terminal_performance_mode"})
	CPanel:AddControl("CheckBox", {Label = "Pinkelflecken verbergen", Command = "cl_hidepiss"})
	CPanel:AddControl("Label", {Text = "Benachrichtigungen:"})
	CPanel:AddControl("CheckBox", {Label = "Wirtschaftsbenachrichtigungen erhalten", Command = "cl_economynotifications"})
	CPanel:AddControl("CheckBox", {Label = "Raidbenachrichtigungen erhalten", Command = "cl_raidnotifications"})
	CPanel:AddControl("CheckBox", {Label = "Tonbenachrichtigungen bei\nRebellionen und Bandenkriegen", Command = "cl_warsoundnotification"})
	CPanel:AddControl("Label", {Text = "Autohändler:"})
	CPanel:AddControl("CheckBox", {Label = "Bei Zugriff auf Autohändler in der Garage starten", Command = "car_dealer_startininventory"})
	CPanel:AddControl("CheckBox", {Label = "Im Shop automatisch die erste Kategorie wählen", Command = "car_dealer_categoryautoselect"})
	CPanel:AddControl("Label", {Text = "Familie:"})
	CPanel:AddControl("CheckBox", {Label = "Familien-Einladungen automatisch ignorieren", Command = "cl_family_ignoreinvites"})
	CPanel:AddControl("Label", {Text = "Party:"})
	CPanel:AddControl("CheckBox", {Label = "Party-Einladungen automatisch ignorieren", Command = "cl_ignorepartyinvites"})
	CPanel:AddControl("CheckBox", {Label = "Party-Anfragen automatisch ignorieren", Command = "cl_ignorepartyasks"})
	CPanel:AddControl("CheckBox", {Label = "Partyspielerlistung darstellen", Command = "cl_showparty"})
	CPanel:AddControl("CheckBox", {Label = "Ringe unter Partymitgliedern", Command = "cl_showpartyrings"})
	CPanel:AddControl("CheckBox", {Label = "Leben in der Partyspielerlistung anzeigen", Command = "cl_showpartyhealth"})
	CPanel:AddControl("CheckBox", {Label = "Rüstung in der Partyspielerlistung anzeigen", Command = "cl_showpartyarmor"})
	CPanel:AddControl("CheckBox", {Label = "Größe der Partyspielerlistung limitieren", Command = "cl_limitpartypanels"})
	CPanel:AddControl("CheckBox", {Label = "Erweiterte Partyspielerlistung benutzen", Command = "cl_extendedpartypanels"})
	CPanel:AddControl("Label", {Text = "NLR:"})
	CPanel:AddControl("CheckBox", {Label = "NLR-Zone als Sphäre zeichnen (FPS beeinträchtigend)", Command = "cl_nlr_sphere"})
	CPanel:AddControl("Slider", {Label = "NLR-Sphäre Komplexität (FPS beinträchtigend)", Command = "cl_nlr_spherecomplexity", Type = "Int", Min = "20", Max = "100"})
	CPanel:AddControl("Slider", {Label = "NLR-Kreis Komplexität (FPS beinträchtigend)", Command = "cl_nlr_circlecomplexity", Type = "Int", Min = "10", Max = "100"})
	CPanel:AddControl("CheckBox", {Label = "NLR-Timer anzeigen", Command = "cl_nlr_timer"})
	CPanel:AddControl("Label", {Text = "Fadenkreuz:"})
	CPanel:AddControl("CheckBox", {Label = "Fadenkreuz für Waffen deaktivieren", Command = "mg_m9k_disable_crosshair"})
	CPanel:AddControl("CheckBox", {Label = "Standardmäßiges Fadenkreuz für Waffen benutzen", Command = "mg_m9k_alternate_crosshair"})
	CPanel:AddControl("Slider", {Label = "Fadenkreuz-Größe", Command = "mg_m9k_crosshair_size", Type = "Float", Min = "0.1", Max = "3"})
	CPanel:AddControl("Slider", {Label = "Fadenkreuz-Dicke", Command = "mg_m9k_crosshair_thickness", Type = "Float", Min = "0.1", Max = "1"})
	CPanel:AddControl("Slider", {Label = "Fadenkreuz-Zieltransparenz", Command = "mg_m9k_aiming_crosshair_opacity", Type = "Float", Min = "0", Max = "1"})
	CPanel:AddControl("Slider", {Label = "Fadenkreuz-Farbe (r)", Command = "mg_m9k_crosshair_color_r", Type = "Int", Min = "0", Max = "255"})
	CPanel:AddControl("Slider", {Label = "Fadenkreuz-Farbe (g)", Command = "mg_m9k_crosshair_color_g", Type = "Int", Min = "0", Max = "255"})
	CPanel:AddControl("Slider", {Label = "Fadenkreuz-Farbe (b)", Command = "mg_m9k_crosshair_color_b", Type = "Int", Min = "0", Max = "255"})
	CPanel:AddControl("Button", {Text = "Fadenkreuz zurücksetzen", Command = "mg_m9k_crosshair_reset"})
	CPanel:AddControl("Label", {Text = ""})
	CPanel:AddControl("Label", {Text = "Experimentell:"})
	CPanel:AddControl("CheckBox", {Label = "Multicore Rendering aktivieren", Command = "mg_multicore"})
	CPanel:AddControl("CheckBox", {Label = "Standardmäßig verwenden", Command = "mg_multicore_save"})
	CPanel:AddControl("Label", {Text = "Multicore Rendering sorgt dafür, dass alle CPU-Kerne voll ausgelastet werden.\nDie FPS verdoppelt sich oft bei Aktivierung.\nUnter bestimmten Vorraussetzungen oder Systemkonfigurationen, kann dies zu Spielabstürzen führen."})
	CPanel:AddControl("CheckBox", {Label = "3D Skybox zeichnen", Command = "r_3dsky"})
end

CreateClientConVar("mg_multicore", 0, false)
CreateClientConVar("mg_multicore_save", 0)

cvars.AddChangeCallback("mg_multicore", function(name, old, new)
	if tonumber(new) != 0 then
		RunConsoleCommand("cl_threaded_bone_setup", 1)
		RunConsoleCommand("cl_threaded_client_leaf_system", 1)
		RunConsoleCommand("r_threaded_client_shadow_manager", 1)
		RunConsoleCommand("r_threaded_particles", 1)
		RunConsoleCommand("r_threaded_renderables", 1)
		RunConsoleCommand("r_queued_ropes", 1)
		RunConsoleCommand("studio_queue_mode", 1)
		RunConsoleCommand("mat_queue_mode", -1)
		RunConsoleCommand("gmod_mcore_test", 1)
	else
		RunConsoleCommand("gmod_mcore_test", 0)
	end
end)

if GetConVar("mg_multicore_save"):GetBool() then
	RunConsoleCommand("mg_multicore", 1)
end

cvars.AddChangeCallback("mg_multicore_save", function(name, old, new)
	if (tonumber(new) or 0) != 0 then
		RunConsoleCommand("mg_multicore", 1)
	end
end)

local function PopulateOptionMenus()
	spawnmenu.AddToolMenuOption("Optionen", "Modern Gaming", "Einstellungen", "Einstellungen", "", "", ModernGamingOptions)
end
hook.Add("PopulateToolMenu", "ToolMenu_AddModernGamingSettings", PopulateOptionMenus)