timer.Simple(0, function()
	local only_melee = {
		[TEAM_HOBO] = true,
		[TEAM_HOBOKING] = true
	}

	local only_light = {
		[TEAM_CITIZEN] = true,
		[TEAM_PRIEST] = true,
		[TEAM_MAYOR] = true,
		[TEAM_POLICE] = true,
		[TEAM_JAILGUARD] = true,
		[TEAM_ZOLL] = true,
		[TEAM_DEALER] = true,
		[TEAM_METHCOOK] = true,
		[TEAM_REPAIR] = true,
		[TEAM_REFFINERY] = true,
		[TEAM_GARDENER] = true,
		[TEAM_MINER] = true,
		[TEAM_COOK] = true,
		[TEAM_DJ] = true,
		[TEAM_THIEF] = true,
		[TEAM_MASTERTHIEF] = true,
		[TEAM_BANKER] = true,
		[TEAM_DOCTOR] = true,
		[TEAM_LAWYER] = true,
		[TEAM_DRIVER] = true,
	}

	if TEAM_THEATER then
		only_light[TEAM_THEATER] = true
	end

	local only_shotguns = {
		[TEAM_CHIEF] = true
	}

	local default_weapons = {}
	for _, v in ipairs(GAMEMODE.Config.DefaultWeapons) do
		default_weapons[v] = true
	end

	local function LoadoutOnly(ply, wep)
		local class = wep:GetClass()
		if default_weapons[class] then
			return true
		end
		local tm = ply:Team()
		local weps = RPExtraTeams[tm] and RPExtraTeams[tm].weapons
		if weps and table.HasValue(weps, class) then
			return true
		end
		if wep:GetNW2Bool("Armory") then
			return true
		end
		return false
	end

	local specific_weaponry = {
		[TEAM_SEK] = function(ply, wep)
			return LoadoutOnly(ply, wep) or !MG_IsMelee(wep) and !MG_IsLight(wep) and !MG_IsHeavy(wep) and !MG_IsExplosive(wep)
		end,
		[TEAM_SEKSNIPER] = function(ply, wep)
			return LoadoutOnly(ply, wep) or !MG_IsMelee(wep) and !MG_IsLight(wep) and !MG_IsHeavy(wep) and !MG_IsExplosive(wep)
		end,
		[TEAM_SEKLEADER] = function(ply, wep)
			return LoadoutOnly(ply, wep) or !MG_IsMelee(wep) and !MG_IsLight(wep) and !MG_IsHeavy(wep) and !MG_IsExplosive(wep)
		end,
		[TEAM_SECRETSERVICE] = function(ply, wep)
			return !MG_IsHeavy(wep) and !MG_IsExplosive(wep) or wep:GetNW2Bool("Armory")
		end
	}

	local handcuff_teams = {
		[TEAM_ZOLL] = true,
		[TEAM_JAILGUARD] = true,
		[TEAM_POLICE] = true,
		[TEAM_CHIEF] = true,
		[TEAM_SEK] = true,
		[TEAM_SEKSNIPER] = true,
		[TEAM_SEKLEADER] = true,
		[TEAM_SECRETSERVICE] = true,
		[TEAM_THIEF] = true,
		[TEAM_MASTERTHIEF] = true,
		[TEAM_GANGSTER] = true,
		[TEAM_GANGSTERBOSS] = true,
		[TEAM_MAFIOSO] = true,
		[TEAM_MAFIABOSS] = true,
		[TEAM_REBEL] = true,
		[TEAM_REBELBOSS] = true,
		[TEAM_TERROR] = true,
		[TEAM_STAFF] = true,
		[TEAM_OWNER] = true,
		[TEAM_SECURITY] = true,
	}

	local function IsHandcuffs(wep)
		return MG_Handcuffs[wep:GetClass()]
	end

	local function IsAllowed(ply, wep)
		local tm = ply:Team()
		if only_melee[tm] and (MG_IsExplosive(wep) or MG_IsLight(wep) or MG_IsHeavy(wep)) then
			return false
		end
		if only_light[tm] and (MG_IsExplosive(wep) or MG_IsHeavy(wep)) then
			return false
		end
		if only_shotguns[tm] and (MG_IsExplosive(wep) or MG_IsHeavy(wep)) then
			local _, cat = MG_IsHeavy(wep)
			if cat != "M9K Shotguns" then
				return false
			end
		end
		if !handcuff_teams[tm] and IsHandcuffs(wep) then
			return false
		end
		local func = specific_weaponry[tm]
		if func and !func(ply, wep) then
			return false
		end
		return true
	end

	hook.Add("StartCommand", "DarkRP_WeaponRestrictions", function(ply, cmd)
		if !cmd:KeyDown(IN_ATTACK) and !cmd:KeyDown(IN_ATTACK2) and !cmd:KeyDown(IN_RELOAD) then return end
		if ply:IsAdmin() then return end
		local wep = ply:GetActiveWeapon()
		if wep:IsValid() and !IsAllowed(ply, wep) then
			cmd:RemoveKey(IN_ATTACK)
			cmd:RemoveKey(IN_ATTACK2)
			if (ply.NextWarning or 0) > CurTime() then return end
			ply.NextWarning = CurTime() + 1.5
			timer.Simple(0, function()
				if ply:GetActiveWeapon() != wep then return end
				surface.PlaySound("buttons/button10.wav")
				notification.AddLegacy("Dein Job hat dir nie gelernt, wie man diese Waffe verwendet!", NOTIFY_ERROR, 4)
			end)
		end
	end)
end)