local ammo_types  = {
	["pistol"] = true,
	["357"] = true,
	["smg1"] = true,
	["ar2"] = true,
	["lmg"] = true,
	["buckshot"] = true,
	["sniperpenetratedround"] = true
}

timer.Simple(0, function()
	DarkRP.declareChatCommand{
		command = "takeammo",
		description = "Take all ammo from a spawned weapon.",
		delay = 1.5
	}

	DarkRP.declareChatCommand{
		command = "splitAmmo",
		description = "Split ammo into two ammo boxes.",
		delay = 1.5
	}

	DarkRP.declareChatCommand{
		command = "dropAmmo",
		description = "Drop all ammo from the weapon you are currently holding.",
		delay = 1.5
	}
end)

if CLIENT then
	properties.Add("takeAmmo", {
		MenuLabel = "Munition entnehmen",
		Order = 2005,
		MenuIcon = "icon16/box.png",
		Filter  = function(self, ent, ply)
			if !IsValid(ent) then return false end
			return ent.IsSpawnedWeapon
		end,
		Action = function(self, ent)
			if !IsValid(ent) then return end
			RunConsoleCommand("darkrp", "takeammo", ent:EntIndex())
		end
	})

	properties.Add("splitAmmo", {
		MenuLabel = "Munition aufteilen",
		Order = 2006,
		MenuIcon = "icon16/arrow_divide.png",
		Filter  = function(self, ent, ply)
			if !IsValid(ent) then return false end
			return ent.IsSpawnedAmmo
		end,
		Action = function(self, ent)
			if !IsValid(ent) then return end
			RunConsoleCommand("darkrp", "splitammo", ent:EntIndex())
		end
	})

	properties.Add("makeWeapon", {
		MenuLabel = "Waffen entnehmen",
		Order = 2007,
		MenuIcon = "icon16/cog.png",
		Filter  = function(self, ent, ply)
			if !IsValid(ent) then return false end
			return ent.IsSpawnedShipment
		end,
		Action = function(self, ent)
			if !IsValid(ent) then return end
			RunConsoleCommand("darkrp", "makeweapon", ent:EntIndex())
		end
	})
else
	timer.Simple(0, function()
		local function TakeAmmo(ply, args)
			local id = tonumber(args) or -1
			local ent = Entity(id)
			ent = IsValid(ent) and ent or ply:GetEyeTrace().Entity
			if !IsValid(ent) or !ent.IsSpawnedWeapon or ent.PlayerUse == false then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("invalid_x", DarkRP.getPhrase("arguments"), ""))
				return
			end
			local pos = ent:GetPos()
			if pos:DistToSqr(ply:GetShootPos()) > 16900 or !pos:isInSight({ent, ply} , ply) then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("distance_too_big"))
				return
			end
			local wep = weapons.GetStored(ent:GetWeaponClass())
			if wep then
				local ammo_typ = wep.Primary and wep.Primary.Ammo and string.lower(wep.Primary.Ammo)
				if ammo_types[ammo_typ] then
					if ent.ammoadd > 0 then
						local ammo = ply:GetAmmoCount(ammo_typ) + (ent.ammoadd or 0)
						ply:SetAmmo(ammo, ammo_typ)
						hook.Run("onPlayerTookAmmo", ply, wep, (ent.ammoadd or 0), ammo_typ)
						ent.ammoadd = 0
						DarkRP.notify(ply, 0, 3, "Munition entnommen.")
					else
						DarkRP.notify(ply, 1, 4, "Hier ist keine Munition mehr!")
					end
				else
					DarkRP.notify(ply, 1, 4, "Kann hier keine Munition entnehmen!")
				end
			else
				DarkRP.notify(ply, 1, 4, "Kann hier keine Munition entnehmen!")
			end
		end
		DarkRP.defineChatCommand("takeammo", TakeAmmo, 0.3)

		local function SplitAmmo(ply, args)
			local id = tonumber(args) or -1
			local ent = Entity(id)
			ent = IsValid(ent) and ent or ply:GetEyeTrace().Entity
			if !IsValid(ent) or !ent.IsSpawnedAmmo or ent.PlayerUse == false then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("invalid_x", DarkRP.getPhrase("arguments"), ""))
				return
			end
			if ent.amountGiven < 2 or ent.USED then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("shipment_cannot_split"))
				return
			end
			local pos = ent:GetPos()
			if pos:DistToSqr(ply:GetShootPos()) > 16900 or !pos:isInSight({ent, ply} , ply) then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("distance_too_big"))
				return
			end
			local ammo = math.floor(ent.amountGiven / 2)
			ent.amountGiven = ent.amountGiven - ammo
			local ammo = ents.Create("spawned_ammo")
			ammo:SetModel(ent:GetModel())
			ammo:SetPos(ent:GetPos())
			ammo.nodupe = true
			ammo.amountGiven, ammo.ammoType = ent.amountGiven, ent.ammoType
			ammo:Spawn()
		end
		DarkRP.defineChatCommand("splitammo", SplitAmmo, 0.3)

		local function CheckAmmo(ply, wep)
			local job_tbl = ply:getJobTable()
			local min_ammo = 0
			if job_tbl and job_tbl.ammo then
				local ammo_typ = game.GetAmmoName(wep:GetPrimaryAmmoType())
				ammo_typ = ammo_typ and string.lower(ammo_typ)
				for k, v in pairs(job_tbl.ammo) do
					if k == ammo_typ then
						min_ammo = v
						break
					end
				end
			end
			if PoliceEquip then
				local tb = PoliceEquip.Armory.GiveWeapons[ply:Team()]
				if tb then
					local ammo_typ = game.GetAmmoName(wep:GetPrimaryAmmoType())
					ammo_typ = ammo_typ and string.lower(ammo_typ)
					for typ, amt in pairs(tb.ammo or {}) do
						if ammo_typ == typ and min_ammo < amt then
							min_ammo = amt
							break
						end
					end
				end
			end
			return min_ammo
		end

		local function DropAmmo(ply, args)
			local wep = ply:GetActiveWeapon()
			if !wep:IsValid() then DarkRP.notify(ply, 1, 4, "Du hast keine Waffe ausgerüstet!") return end
			local ammo_typ = wep.Primary and wep.Primary.Ammo and string.lower(wep.Primary.Ammo)
			if ammo_types[ammo_typ] then
				local amount = ply:GetAmmoCount(ammo_typ) - CheckAmmo(ply, wep)
				if amount > 0 then
					local found
					for _, v in pairs(GAMEMODE.AmmoTypes) do
						if string.lower(v.ammoType) != ammo_typ then continue end
						found = v
						break
					end
					if !found then
						DarkRP.notify(ply, 1, 4, "Diese Munitionsart kann nicht fallen gelassen werden!")
						return
					end
					timer.Simple(1, function()
						local secure_ammo = CheckAmmo(ply, wep)
						amount = ply:GetAmmoCount(ammo_typ) - secure_ammo
						if amount > 0 then
							if IsValid(ply) and IsValid(wep) and wep:GetModel() != "" and !IsValid(ply:GetObserverTarget()) then
								local trace = {}
								trace.start = ply:EyePos()
								trace.endpos = trace.start + ply:GetAimVector() * 85
								trace.filter = ply
								local tr = util.TraceLine(trace)
								local ammo = ents.Create("spawned_ammo")
								ammo:SetModel(found.model)
								ammo:SetPos(tr.HitPos)
								ammo.nodupe = true
								ammo.amountGiven, ammo.ammoType = amount, found.ammoType
								ammo:Spawn()
								DarkRP.placeEntity(ammo, tr, ply)
								ply:SetAmmo(secure_ammo, ammo_typ)
								hook.Run("onPlayerDroppedAmmo", ply, wep, ammo)
							end
						else
							DarkRP.notify(ply, 1, 4, "Diese Waffe hat zu wenig Munition!")
						end
					end)
				else
					DarkRP.notify(ply, 1, 4, "Diese Waffe hat zu wenig Munition!")
				end
			else
				DarkRP.notify(ply, 1, 4, "Diese Waffe kann keine Munition fallen lassen!")
			end
		end
		DarkRP.defineChatCommand("dropammo", DropAmmo, 1.5)

		local function makeWeapon(ply, args)
			local id = tonumber(args) or -1
			local ent = Entity(id)

			ent = IsValid(ent) and ent or ply:GetEyeTrace().Entity

			if !IsValid(ent) or !ent.IsSpawnedShipment then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("invalid_x", DarkRP.getPhrase("arguments"), ""))
				return
			end

			if ent.locked or ent.USED then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("shipment_cannot_split"))
				return
			end

			local pos = ent:GetPos()

			if pos:DistToSqr(ply:GetShootPos()) > 16900 or not pos:isInSight({ent, ply} , ply) then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("distance_too_big"))
				return
			end

			if !ent.locked then
				ent:Destruct()
			end
		end
		DarkRP.defineChatCommand("makeweapon", makeWeapon, 0.3)
	end)
end