CreateConVar("mg_movemode", 0, {FCVAR_NOTIFY, FCVAR_ARCHIVE})

-- NoClip, welches funktioniert
hook.Add("PlayerNoClip", "DarkRP_NoClip", function(ply)
	if GetConVar("sbox_noclip"):GetBool() then return end
	if !ply:IsAdmin() or !ply:Alive() then return false end
	for k, v in pairs(hook.GetTable().PlayerNoClip) do
		if k == "DarkRP_NoClip" then continue end
		if v(ply) == false then return false end
	end
	return true
end, HOOK_MONITOR_HIGH or -2)

-- Brechstangenzeiten konfigurieren

local lockpicktime_door = 20
local lockpicktime_vehicle = 30
local lockpicktime_lockupgrade = 60
hook.Add("lockpickTime", "DarkRP_RestrictLockpick", function(ply, ent)
	if IsValid(ent) and ent:IsVehicle() then
		local speed = ent:GetNW2Bool("MG_CarDealer_LockUpgrade") and lockpicktime_lockupgrade or lockpicktime_vehicle
		speed = hook.Run("lockpickTimeVehicle", ply, ent, speed) or speed
		return speed
	else
		local speed = lockpicktime_door * (ent:GetNW2Bool("LockUpgrade") and 1.75 or 1)
		speed = hook.Run("lockpickTimeDoor", ply, ent, speed) or speed
		return speed
	end
end)

-- Automatischer Abbruch eines Auftrags bei zu langem AFK-seins

hook.Add("playerSetAFK", "DarkRP_RemovePendingHits", function(ply, bool)
	local name = "DarkRP_RemovePendingHits_"..ply:SteamID()
	timer.Remove(name)
	if !bool then return end
	timer.Create(name, 300, 1, function()
		if !IsValid(ply) or !ply:getDarkRPVar("AFK") then return end
		for _, v in ipairs(player.GetAll()) do
			if v:getDarkRPVar("hasHit") and v:getDarkRPVar("hitTarget") == ply then
				v:abortHit("Das Ziel ist seit längerer Zeit AFK.")
			end
		end
	end)
end)

timer.Simple(0, function()
	-- Aufträge gegen Teammitglieder

	local whitelist = {
		[TEAM_OWNER] = true,
		[TEAM_STAFF] = true,
		[TEAM_EVENT] = true
	}

	hook.Add("canRequestHit", "DarkRP_BlockHits", function(hitman, customer, target)
		if IsValid(target) then
			local tm = target:Team()
			if (whitelist[tm] or MG_DeveloperGroups[target:GetUserGroup()] or target == customer or target:getDarkRPVar("AFK")) then
				return false, "Dieses Ziel ist immun!"
			end
		end
	end)

	-- Neue Emotionen

	DarkRP.addPlayerGesture(ACT_GMOD_TAUNT_ROBOT, "Roboter")
	DarkRP.addPlayerGesture(ACT_GMOD_TAUNT_SALUTE, "Salutieren")
	DarkRP.addPlayerGesture(ACT_GMOD_GESTURE_RANGE_FRENZY, "Durchdrehen")

	-- Entfernte Befehle

	concommand.Remove("rp_lookup")
	concommand.Remove("rp_resetallmoney")

	DarkRP.removeChatCommand("addspawn")
	DarkRP.removeChatCommand("setspawn")
	DarkRP.removeChatCommand("removespawn")

	-- Umsetzung von DarkRP.findPlayer ohne Steamnamen-Einbindung

	function DarkRP.findPlayer(info)
		if !info or info == "" then return nil end
		local pls = player.GetAll()
		for k=1, #pls do
			local v = pls[k]
			if tonumber(info) == v:UserID() then
				return v
			end
			if info == v:SteamID() then
				return v
			end
			if string.find(string.lower(v:Name()), string.lower(tostring(info)), 1, true) != nil then
				return v
			end
		end
		return nil
	end

	-- Animationen einschränken

	local commands = concommand.GetTable()
	if SERVER then
		local func = commands["_darkrp_doanimation"]
		if func then
			concommand.Add("_darkrp_doanimation", function(ply, cmd, args)
				if !IsValid(ply) then return end
				local wep = ply:GetActiveWeapon()
				if !wep:IsValid() or wep:GetClass() != "keys" then return end
				if ply:InVehicle() and !ply:GetAllowWeaponsInVehicle() then return end
				func(ply, cmd, args)
			end)
		else
			print("_darkrp_doanimation concommand is missing!")
		end
	else
		local func = commands["_darkrp_animationmenu"]
		if func then
			concommand.Add("_darkrp_animationmenu", function(ply, cmd, args)
				local wep = ply:GetActiveWeapon()
				if !wep:IsValid() or wep:GetClass() != "keys" then return end
				if ply:InVehicle() and !ply:GetAllowWeaponsInVehicle() then return end
				func(ply, cmd, args)
			end)
		else
			print("_darkrp_animationmenu concommand is missing!")
		end
	end

	-- Ersatz für Werbungsbefehl

	DarkRP.removeChatCommand("advert")

	if SERVER then
		local function PlayerAdvertise(ply, args)
			if args == "" then
				DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("invalid_x", DarkRP.getPhrase("arguments"), ""))
				return ""
			end
			local DoSay = function(text)
				if text == "" then
					DarkRP.notify(ply, 1, 4, DarkRP.getPhrase("invalid_x", DarkRP.getPhrase("arguments"), ""))
					return
				end
				local col = team.GetColor(ply:Team())
				local col2 = Color(255, 255, 0, 255)
				local name = ply:Name()
				local phrase = DarkRP.getPhrase("advert")
				for _, v in ipairs(player.GetAll()) do
					DarkRP.talkToPerson(v, col, phrase.." "..name, col2, text, ply)
				end
			end
			return args, DoSay
		end
		DarkRP.defineChatCommand("advert", PlayerAdvertise, 1.5)
	end

	DarkRP.declareChatCommand{
		command = "advert",
		description = "Advertise something to everyone in the server.",
		delay = 1.5
	}
end)