MG_VIPGroups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["admin_vip"] = true,
	["moderator_vip"] = true,
	["vip++"] = true,
	["vip+"] = true,
	["vip"] = true
}

MG_Tier1Groups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["admin_vip"] = true,
	["moderator_vip"] = true,
	["vip++"] = true,
	["vip+"] = true,
	["vip"] = true
}

MG_Tier2Groups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["admin_vip"] = true,
	["moderator_vip"] = true,
	["vip++"] = true,
	["vip+"] = true
}

MG_Tier3Groups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["admin_vip"] = true,
	["moderator_vip"] = true,
	["vip++"] = true
}

MG_ModGroups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["superadmin"] = true,
	["admin_vip"] = true,
	["admin"] = true,
	["moderator_vip"] = true,
	["moderator"] = true
}

MG_AdminGroups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["superadmin"] = true,
	["admin_vip"] = true,
	["admin"] = true
}

MG_SuperAdminGroups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["community-manager"] = true,
	["teamleiter"] = true,
	["developer"] = true,
	["superadmin_vip"] = true,
	["superadmin"] = true
}

MG_OwnerGroups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["teamleiter"] = true
}

MG_DeveloperGroups = {
	["owner"] = true,
	["stellv. owner"] = true,
	["infrastrukturadmin"] = true,
	["developer"] = true
}

MG_MeleeWeapons = {
	["weapon_fists"] = true,

	["m9k_knife"] = true,
	["m9k_machete"] = true,
	["m9k_damascus"] = true,
	["m9k_harpoon"] = true,
	["m9k_baseball_bat"] = true,
	["m9k_hatchet"] = true,
	["m9k_sledgehammer"] = true,
	["m9k_spade"] = true,
}

MG_ExplosiveWeapons = {
	["weapon_breach"] = true,

	["m9k_orbital_strike"] = true,
	["m9k_suicide_bomb"] = true,
	["m9k_ied_detonator"] = true,
	["m9k_ex41"] = true,
	["m9k_m202"] = true,
	["m9k_m61_frag"] = true,
	["m9k_m79gl"] = true,
	["m9k_matador"] = true,
	["m9k_milkormgl"] = true,
	["m9k_nitro"] = true,
	["m9k_proxy_mine"] = true,
	["m9k_rpg7"] = true,
	["m9k_sticky_grenade"] = true,
	["m9k_nerve_gas"] = true
}

MG_LW_Categories = {
	["M9K Pistols"] = true,
	["M9K Submachine Guns"] = true
}

MG_HW_Categories = {
	["M9K Assault Rifles"] = true,
	["M9K Machine Guns"] = true,
	["M9K Shotguns"] = true,
	["M9K Sniper Rifles"] = true
}

MG_Handcuffs = {
	["weapon_cuff_elastic"] = true,
	["weapon_cuff_police"] = true,
	["weapon_cuff_standard"] = true,
	["weapon_cuff_tactical"] = true
}

function MG_IsMelee(wep)
	if !wep then return end
	return MG_MeleeWeapons[isstring(wep) and wep or wep:GetClass()]
end

function MG_IsExplosive(wep)
	if !wep then return end
	return MG_ExplosiveWeapons[isstring(wep) and wep or wep:GetClass()]
end

function MG_IsLight(wep)
	if !wep then return end
	local cat = isstring(wep) and wep or wep.Category or ""
	return MG_LW_Categories[cat], cat
end

function MG_IsHeavy(wep)
	if !wep then return end
	local cat = isstring(wep) and wep or wep.Category or ""
	return MG_HW_Categories[cat], cat
end

function MG_IsHandcuffs(wep)
	if !wep then return end
	return MG_Handcuffs[isstring(wep) and wep or wep:GetClass()]
end