timer.Simple(0, function()
	hook.Remove("PlayerTick", "TickWidgets")
	hook.Remove("LoadGModSave", "LoadGModSave")
	timer.Remove("HostnameThink")

	hook.Remove("Move", "DruggedPlayer")
	hook.Remove("SetupMove", "DarkRP_WeaponSpeed")
	hook.Remove("SetupMove", "DarkRP_DoorRamJump")

	local reg = debug.getregistry()
	local GetActiveWeapon = reg.Player.GetActiveWeapon
	local GetTable = reg.Entity.GetTable
	local GetClass = reg.Entity.GetClass
	local OnGround = reg.Entity.OnGround
	local SetMaxClientSpeed = reg.CMoveData.SetMaxClientSpeed
	local GetMaxClientSpeed = reg.CMoveData.GetMaxClientSpeed
	local SetButtons = reg.CMoveData.SetButtons
	local GetButtons = reg.CMoveData.SetButtons

	local bit = bit
	local IN_JUMP = IN_JUMP

	local wep, tb
	local function SetupMove(ply, mv)
		wep = GetActiveWeapon(ply)
		tb = GetTable(wep)
		if !tb or !tb.DarkRPBased or !tb.dt or !tb.dt.Ironsights or !tb.dt.Ironsights then return end
		SetMaxClientSpeed(mv, GetMaxClientSpeed(mv) / 3)
		if GetClass(wep) != "door_ram" then return end
		if OnGround(ply) then
			SetButtons(mv, bit.band(GetButtons(mv), bit.bnot(IN_JUMP)))
		end
	end
	hook.Add("SetupMove", "DarkRP_SetupMove", SetupMove)

	if SERVER then
		concommand.Remove("_sendAllDoorData")
	end

	if CLIENT then
		hook.Remove("PostDrawEffects", "RenderWidgets")

        hook.Remove("RenderScreenspaceEffects", "RenderColorModify")
        hook.Remove("RenderScreenspaceEffects", "RenderBloom")
        hook.Remove("RenderScreenspaceEffects", "RenderToyTown")
        hook.Remove("RenderScreenspaceEffects", "RenderTexturize")
        hook.Remove("RenderScreenspaceEffects", "RenderSunbeams")
        hook.Remove("RenderScreenspaceEffects", "RenderSobel")
        hook.Remove("RenderScreenspaceEffects", "RenderSharpen")
        hook.Remove("RenderScreenspaceEffects", "RenderMaterialOverlay")
        hook.Remove("RenderScreenspaceEffects", "RenderMotionBlur")
        hook.Remove("RenderScene", "RenderStereoscopy")
        hook.Remove("RenderScene", "RenderSuperDoF")
        hook.Remove("GUIMousePressed", "SuperDOFMouseDown")
        hook.Remove("GUIMouseReleased", "SuperDOFMouseUp")
        hook.Remove("PreventScreenClicks", "SuperDOFPreventClicks")
        hook.Remove("PostRender", "RenderFrameBlend")
        hook.Remove("PreRender", "PreRenderFrameBlend")
        hook.Remove("Think", "DOFThink")
        hook.Remove("RenderScreenspaceEffects", "RenderBokeh")
        hook.Remove("NeedsDepthPass", "NeedsDepthPass_Bokeh")
	end

	hook.Add("DarkRPPreLoadModules", "MG_Voice_Optimisations", function()
		hook.Remove("DarkRPPreLoadModules", "MG_Voice_Optimisations")

		DarkRP.voiceCheckTimeDelay = 0.4
	end)

	local entityMeta = FindMetaTable("Entity")

	local GetTable = entityMeta.GetTable
	local GetOwner = entityMeta.GetOwner

	function entityMeta:__index(key)
		-- Modern Gaming Performance

		local val = entityMeta[key]
		if val != nil then return val end

		local tab = GetTable(self)
		if tab then
			local val = tab[key]
			if val != nil then return val end
		end

		if key == "Owner" then return GetOwner(self) end

		return nil
	end

	local plyMeta = FindMetaTable("Player")

	function plyMeta:__index(key)
		-- Modern Gaming Performance

		local val = plyMeta[key]
		if val != nil then return val end

		local val = entityMeta[key]
		if val != nil then return val end

		local tab = GetTable(self)
		if tab then
			return tab[key]
		end

		return nil
	end

	local weaponMeta = FindMetaTable("Weapon")

	function weaponMeta:__index(key)
		-- Modern Gaming Performance

		local val = weaponMeta[key]
		if val != nil then return val end

		local val = entityMeta[key]
		if val != nil then return val end

		local tab = GetTable(self)
		if tab != nil then
			local val = tab[key]
			if val != nil then return val end
		end

		if key == "Owner" then return GetOwner(self) end

		return nil
	end

	function GAMEMODE:Move(ply, mv)
		if player_manager.RunClass(ply, "Move", mv) then return true end
	end

	function GAMEMODE:FinishMove(ply, mv)
		if player_manager.RunClass(ply, "FinishMove", mv) then return true end
	end

	function drive.CalcView(ply, view)
	end

	function drive.CreateMove(cmd)
	end
end)