local V = {
	Name = "Mitsubishi Evo X Police", 
	Class = "prop_vehicle_jeep",
	Category = "Modern Gaming",
	Author = "TheDanishMaster, Turn 10",
	Information = "A drivable Mitsubishi Evo X Police by TheDanishMaster",
	Model = "models/tdmcars/emergency/mitsu_evox.mdl",
	KeyValues = {
		vehiclescript =	"scripts/vehicles/tdmcars/mitsu_evox.txt"
	}
}
list.Set("Vehicles", "mitsuevoxpoltdm", V)

local V = {
	Name = "Dodge Charger SRT8 2012 Police", 
	Class = "prop_vehicle_jeep",
	Category = "Modern Gaming",
	Author = "TheDanishMaster, Turn 10",
	Information = "A drivable Dodge Charger SRT8 2012 Police by TheDanishMaster",
	Model = "models/tdmcars/emergency/dod_charger12.mdl",
	KeyValues = {
		vehiclescript =	"scripts/vehicles/tdmcars/charger2012.txt",
		EnableGun = "0"
	}
}
list.Set("Vehicles", "charger12poltdm", V)

local V = {
	Name = "SEK-Einsatzwagen",
	Class = "prop_vehicle_jeep",
	Category = "Modern Gaming",
	Author = "SentryGunMan, Criterion",
	Information = "vroom vroom",
	Model =	"models/sentry/swatvan.mdl",
	KeyValues = {
		vehiclescript =	"scripts/vehicles/sentry/vswat.txt"
	}
}
list.Set("Vehicles", "vswat", V)

local V = {
	Name = "Maserati Ghibli S", 
	Class = "prop_vehicle_jeep",
	Category = "Modern Gaming",
	Author = "TheDanishMaster, Turn 10",
	Information = "A drivable Maserati Ghibli S by TheDanishMaster",
	Model = "models/tdmcars/mas_ghibli.mdl",
	KeyValues = {
		vehiclescript = "scripts/vehicles/tdmcars/mas_ghibli.txt"
	}
}
list.Set("Vehicles", "mas_ghiblitdm", V)

local V = {
	Name = "Abschleppwagen", 
	Class = "prop_vehicle_jeep",
	Category = "Modern Gaming",
	Author = "SgtSgt, Rockstar Games",
	Information = "GTA4 Tow Truck upload for OtherGaming.eu",
	Model = "models/sickness/towtruckdr.mdl",	
	SeatType = "jeep_seat",
	Horn = {Sound = "vu_horn_double.wav", Pitch = 90},
	KeyValues = {
		vehiclescript =	"scripts/vehicles/tow.txt"
	}
}
list.Set("Vehicles", "sicknesstowtruck", V)

local V = {
	Name = "Krankenwagen", 
	Class = "prop_vehicle_jeep",
	Category = "Modern Gaming",
	Author = "LoneWolfie",
	Information = "A f350 by Lonewolfie",
	Model = "models/lonewolfie/ford_f350_ambu.mdl",		
	KeyValues = {
		vehiclescript = "scripts/vehicles/lwcars/ford_f350_ambu.txt"
	}
}
list.Set("Vehicles", "ford_f350_ambu_lw", V)

local function CustomExit(ply, veh)
	if veh:GetModel() == "models/sickness/towtruckdr.mdl" then
		ply:SetPos(veh:GetPos() + Vector(0, 100, 20))
	end
end
hook.Add("PlayerLeaveVehicle", "DarkRP_VehicleTowing", CustomExit)

local function SaveVehVCMod(ply, seat, veh)
	if IsValid(veh) and veh:GetModel() == "models/lonewolfie/ford_f350_ambu.mdl" then
		ply.LastVeh = veh
		local seats = ply.LastVeh:VC_getSeatsAvailable()
		if IsValid(seats[3]) and seat == seats[3] then return false end
	end
end
hook.Add("VC_canEnterPassengerSeat", "DarkRP_VehicleSaveVehVCMod", SaveVehVCMod)


local function SaveVeh(ply, veh)
	if IsValid(veh) and veh:GetModel() == "models/lonewolfie/ford_f350_ambu.mdl" then
		ply.LastVeh = veh
	end
end
hook.Add("PlayerEnteredVehicle", "DarkRP_VehicleSaveVeh", SaveVeh)

local function CustomSeatBlock(ply, seat_from, seat_to)
	if IsValid(ply.LastVeh) and ply.LastVeh:GetModel() == "models/lonewolfie/ford_f350_ambu.mdl" then
		local seats = ply.LastVeh:VC_getSeatsAvailable()
		if IsValid(seats[3]) and seat_to == seats[3] then return false end
	end
end
hook.Add("VC_canSwitchSeat", "DarkRP_VehicleAmbulance", CustomSeatBlock)

sound.Add({
	name = "lt_slowdown",
	channel = CHAN_STATIC,
	volume = 1,
	soundlevel = 100,
	sound =  "vehicles/lt/lt_slowdown.wav" 
})

sound.Add({
	name = "lt_throttle_2nd",
	channel = CHAN_STATIC,
	volume = 1,
	soundlevel = 100,
	sound =  "vehicles/lt/lt_throttle_2nd.wav" 
})

sound.Add({
	name = "lt_throttle_1st",
	channel = CHAN_STATIC,
	volume = 1,
	soundlevel = 100,
	sound =  "vehicles/lt/lt_throttle_1st.wav" 
})

sound.Add({
	name = "lt_reverse",
	channel = CHAN_STATIC,
	volume = 1,
	soundlevel = 100,
	sound =  "vehicles/lt/lt_reverse.wav" 
})

sound.Add({
	name = "lt_idle",
	channel = CHAN_STATIC,
	volume = 1,
	soundlevel = 100,
	sound =  "vehicles/lt/lt_idle_loop.wav" 
})

sound.Add({
	name = "lt_start",
	channel = CHAN_STATIC,
	volume = 1,
	soundlevel = 100,
	sound =  "vehicles/lt/lt_start.wav" 
})