local AllowedJobs = {}

local DisallowedJobs = {
	[TEAM_HOBO] = true,
	[TEAM_HOBOKING] = true,
	[TEAM_STRAY] = true,
	[TEAM_POLICEDOG] = true
}

for k, v in pairs(RPExtraTeams) do
	if !DisallowedJobs[k] then
		table.insert(AllowedJobs, k)
	end
end

DarkRP.createEntity("Hausalarmanlage", {
	ent = "house_alarm",
	model = "models/items/combine_rifle_cartridge01.mdl",
	price = 2000,
	max = 1,
	cmd = "buyhausalarmanlage",
	category = "Sicherheit"
})

DarkRP.createEntity("Verbessertes Türschloss", {
	ent = "house_lock",
	model = "models/props_wasteland/prison_padlock001a.mdl",
	price = 2500,
	max = 1,
	cmd = "buyverbessertestürschloss",
	category = "Sicherheit"
})

DarkRP.createEntity("Autoalarmanlage", {
	ent = "vehicle_alarm",
	model = "models/props_c17/consolebox03a.mdl",
	price = 1500,
	max = 1,
	cmd = "buyautoalarmanlage",
	category = "Sicherheit"
})

DarkRP.createEntity("Metalldetektor", {
	ent = "metal_detector",
	model = "models/props_wasteland/interior_fence002e.mdl",
	price = 3000,
	max = 2,
	cmd = "buymetaldetektor",
	allowed = {TEAM_ZOLL, TEAM_JAILGUARD, TEAM_SECURITY},
	category = "Sicherheit"
})

DarkRP.createEntity("Bewegungsmelder", {
	ent = "protect_scanner",
	model = "models/items/battery.mdl",
	price = 1000,
	max = 3,
	cmd = "buybewegungsmelder",
	allowed = {TEAM_ZOLL, TEAM_JAILGUARD, TEAM_SECURITY},
	category = "Sicherheit"
})

DarkRP.createEntity("Kamera", {
	ent = "protect_camera",
	model = "models/tools/camera/camera.mdl",
	price = 750,
	max = 2,
	cmd = "buykamera",
	allowed = {TEAM_ZOLL, TEAM_JAILGUARD, TEAM_SECURITY},
	category = "Sicherheit"
})

DarkRP.createEntity("Terminal", {
	ent = "protect_terminal",
	model = "models/props_phx/rt_screen.mdl",
	price = 1000,
	max = 2,
	cmd = "buyterminal",
	allowed = {TEAM_ZOLL, TEAM_JAILGUARD, TEAM_SECURITY},
	category = "Sicherheit"
})

DarkRP.createEntity("Gelddrucker", {
	ent = "money_printer",
	model = "models/props_c17/consolebox01a.mdl",
	price = 2000,
	max = 4,
	cmd = "buygelddrucker",
	allowed = AllowedJobs,
	category = "Generell"
})

DarkRP.createEntity("Mikrowelle", {
	ent = "microwave",
	model = "models/props/cs_office/microwave.mdl",
	price = 4000,
	max = 1,
	cmd = "buymikrowelle",
	allowed = TEAM_COOK,
	category = "Koch"
})

hook.Add("playerBoughtCustomEntity", "DarkRP_Microwave", function(ply, ent_tbl, ent)
	if ent:GetClass() == "microwave" then
		ent.SalePrice = function(self, actor)
			return actor != self:Getowning_ent() and self:Getprice() or GAMEMODE.Config.microwavefoodcost
		end
	end
end)

DarkRP.createEntity("Kleiner Verbandskasten (10%)", {
	ent = "health_10",
	model = "models/healthvial.mdl",
	price = 2500,
	max = 10,
	cmd = "buykleinerverbandskasten",
	allowed = TEAM_DOCTOR,
	category = "Arzt"
})

DarkRP.createEntity("Großer Verbandskasten (25%)", {
	ent = "health_25",
	model = "models/items/healthkit.mdl",
	price = 5000,
	max = 10,
	cmd = "buygroßerverbandskasten",
	allowed = TEAM_DOCTOR,
	category = "Arzt"
})

DarkRP.createEntity("Heilstation", {
	ent = "healthstation",
	model = "models/props_combine/health_charger001.mdl",
	price = 6000,
	max = 1,
	cmd = "buyheilstation",
	allowed = TEAM_DOCTOR,
	category = "Arzt"
})

DarkRP.createEntity("Aspirin", {
	ent = "drug_aspirin",
	model = "models/jaanus/aspbtl.mdl",
	price = 6000,
	max = 10,
	cmd = "buyaspirin",
	allowed = TEAM_DOCTOR,
	category = "Arzt"
})

DarkRP.createEntity("Kleine Rüstung (25%)", {
	ent = "armor_25",
	model = "models/props_junk/cardboard_box004a.mdl",
	price = 10000,
	max = 10,
	cmd = "buykleinerüstung",
	allowed = TEAM_MARKET,
	category = "Schwarzmarkt"
})

DarkRP.createEntity("Volle Rüstung (100%)", {
	ent = "armor_100",
	model = "models/props_junk/cardboard_box002a.mdl",
	price = 30000,
	max = 10,
	cmd = "buyvollerüstung",
	allowed = TEAM_MARKET,
	category = "Schwarzmarkt"
})

DarkRP.createEntity("Radiokonsole", {
	ent = "wdj_mastercontroller",
	model = "models/props/de_nuke/NuclearControlBox.mdl",
	price = 1000,
	max = 1,
	cmd = "buyradiokonsole",
	allowed = TEAM_DJ,
	category = "DJ"
})

DarkRP.createEntity("Radio", {
	ent = "wdj_radio",
	model = "models/props_lab/citizenradio.mdl",
	price = 800,
	max = 4,
	cmd = "buyradio",
	allowed = TEAM_DJ,
	category = "DJ"
})

DarkRP.createEntity("Benzinkanister", {
	ent = "gas",
	model = "models/props_junk/gascan001a.mdl",
	price = 5000,
	max = 10,
	cmd = "buybenzinkanister",
	allowed = TEAM_REPAIR,
	category = "Mechaniker"
})

DarkRP.createEntity("Kleiner Reparatursatz (15%)", {
	ent = "repair_kit_15",
	model = "models/vcmod/vcmod_wrench.mdl",
	price = 5000,
	max = 10,
	cmd = "buykleinerreparatursatz",
	allowed = TEAM_REPAIR,
	category = "Mechaniker"
})

DarkRP.createEntity("Großer Reparatursatz (30%)", {
	ent = "repair_kit_30",
	model = "models/vcmod/vcmod_wrenchset.mdl",
	price = 8000,
	max = 10,
	cmd = "buygroßerreparatursatz",
	allowed = TEAM_REPAIR,
	category = "Mechaniker"
})

DarkRP.createEntity("Ersatzreifen", {
	ent = "spare_tire",
	model = "models/xeon133/racewheel/race-wheel-35.mdl",
	price = 4000,
	max = 10,
	cmd = "buyersatzreifen",
	allowed = TEAM_REPAIR,
	category = "Mechaniker"
})

DarkRP.createEntity("Verkaufsbehälter", {
	ent = "sell_container",
	model = "models/props_junk/cardboard_box003a.mdl",
	price = 1000,
	max = 2,
	cmd = "buyverkaufsbehälter",
	allowed = TEAM_GARDENER,
	category = "Gärtner"
})

DarkRP.createEntity("Maschinenbaukasten", {
	ent = "zrush_machinecrate",
	model = "models/zerochain/props_oilrush/zor_machinecrate.mdl",
	price = 400,
	max = 4,
	cmd = "buymaschinenbaukasten",
	allowed = TEAM_REFFINERY,
	category = "Ölraffinerist"
})

DarkRP.createEntity("Ölfass", {
	ent = "zrush_barrel",
	model = "models/zerochain/props_oilrush/zor_barrel.mdl",
	price = 500,
	max = 6,
	cmd = "buyölfass",
	allowed = TEAM_REFFINERY,
	category = "Ölraffinerist"
})

DarkRP.createEntity("10x Rohre", {
	ent = "zrush_drillpipe_holder",
	model = "models/zerochain/props_oilrush/zor_drillpipe_holder.mdl",
	price = 250,
	max = 4,
	cmd = "buyrohre",
	allowed = TEAM_REFFINERY,
	category = "Ölraffinerist"
})

DarkRP.createEntity("Bergbaukiste", {
	ent = "mining_crate",
	model = "models/prop/crates/miningcrate.mdl",
	price = 2000,
	max = 1,
	cmd = "buybergbaukiste",
	allowed = TEAM_MINER,
	category = "Bergmann"
})

DarkRP.createEntity("Marihuanapflanze", {
	ent = "weed_plant",
	model = "models/nater/weedplant_pot_growing7.mdl",
	price = 2500,
	max = 4,
	cmd = "buymarihuanapflanze",
	allowed = TEAM_DEALER,
	category = "Drogenhändler"
})

DarkRP.createEntity("Thermolampe", {
	ent = "grow_lamp",
	model = "models/props/cs_militia/light_shop2.mdl",
	price = 1000,
	max = 2,
	cmd = "buythermolampe",
	allowed = TEAM_DEALER,
	category = "Drogenhändler"
})

DarkRP.createEntity("Zauberpulver", {
	ent = "weed_powder",
	model = "models/props_lab/jar01b.mdl",
	price = 800,
	max = 4,
	cmd = "buyzauberpulver",
	allowed = TEAM_DEALER,
	category = "Drogenhändler"
})

DarkRP.createEntity("Methlabor", {
	ent = "zmlab_combiner",
	model = "models/zerochain/zmlab/zmlab_combiner.mdl",
	price = 8000,
	max = 2,
	cmd = "buymethlabor",
	allowed = TEAM_METHCOOK,
	category = "Methkoch"
})

DarkRP.createEntity("Freezer", {
	ent = "zmlab_freezer",
	model = "models/zerochain/zmlab/zmlab_frezzer.mdl",
	price = 2500,
	max = 1,
	cmd = "buyfreezer",
	allowed = TEAM_METHCOOK,
	category = "Methkoch"
})

DarkRP.createEntity("Filter", {
	ent = "zmlab_filter",
	model = "models/zerochain/zmlab/zmlab_filter.mdl",
	price = 2000,
	max = 2,
	cmd = "buyfilter",
	allowed = TEAM_METHCOOK,
	category = "Methkoch"
})

DarkRP.createEntity("Methylamin", {
	ent = "zmlab_methylamin",
	model = "models/zerochain/zmlab/zmlab_methylamin.mdl",
	price = 400,
	max = 4,
	cmd = "buymethylamin",
	allowed = TEAM_METHCOOK,
	category = "Methkoch"
})

DarkRP.createEntity("Aluminium", {
	ent = "zmlab_aluminium",
	model = "models/zerochain/zmlab/zmlab_aluminiumbox.mdl",
	price = 200,
	max = 8,
	cmd = "buyaluminium",
	allowed = TEAM_METHCOOK,
	category = "Methkoch"
})

DarkRP.createEntity("Wasser", {
	ent = "drug_water",
	model = "models/drug_mod/the_bottle_of_water.mdl",
	price = 2000,
	max = 10,
	cmd = "buywasser",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("Alkohol", {
	ent = "drug_alcohol",
	model = "models/drug_mod/alcohol_can.mdl",
	price = 750,
	max = 10,
	cmd = "buyalkohol",
	allowed = {TEAM_DEALER, TEAM_COOK, TEAM_DJ},
	category = "Drogen"
})

DarkRP.createEntity("Zigaretten", {
	ent = "drug_cigarette",
	model = "models/boxopencigshib.mdl",
	price = 3000,
	max = 10,
	cmd = "buyzigaretten",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("Marihuana", {
	ent = "drug_weed",
	model = "models/katharsmodels/contraband/zak_wiet/zak_wiet.mdl",
	price = 4000,
	max = 10,
	cmd = "buymarihuana",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("PCP", {
	ent = "drug_pcp",
	model = "models/druglab/mdma/mdma.mdl",
	price = 5000,
	max = 10,
	cmd = "buypcp",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("LSD", {
	ent = "drug_lsd",
	model = "models/smile/smile.mdl",
	price = 5000,
	max = 10,
	cmd = "buylsd",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("Kokain", {
	ent = "drug_cocaine",
	model = "models/cocn.mdl",
	price = 6000,
	max = 10,
	cmd = "buykokain",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("Crystal Meth", {
	ent = "drug_meth",
	model = "models/katharsmodels/contraband/metasync/blue_sky.mdl",
	price = 6000,
	max = 10,
	cmd = "buymeth",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("Magic Mushroom", {
	ent = "drug_mushroom",
	model = "models/druglab/shrooms/shrooms.mdl",
	price = 7500,
	max = 10,
	cmd = "buymushroom",
	allowed = TEAM_DEALER,
	category = "Drogen"
})

DarkRP.createEntity("Heroin", {
	ent = "drug_heroine",
	model = "models/katharsmodels/syringe_out/syringe_out.mdl",
	price = 8000,
	max = 10,
	cmd = "buyheroin",
	allowed = TEAM_DEALER,
	category = "Drogen",
	vip = true,
})

DarkRP.createEntity("Spendentruhe", {
	ent = "donation_box",
	model = "models/props/cs_militia/footlocker01_open.mdl",
	price = 1000,
	max = 1,
	cmd = "buyspendentruhe",
	allowed = {TEAM_HOBO, TEAM_HOBOKING},
	category = "Obdachloser"
})

DarkRP.createEntity("Kleiner Behälter", {
	ent = "itemstore_box_small",
	model = "models/props/cs_office/cardboard_box02.mdl",
	price = 1500,
	max = 1,
	cmd = "buykleinerbehälter",
	category = "Verstauung"
})

DarkRP.createEntity("Großer Behälter", {
	ent = "itemstore_box_large",
	model = "models/props/cs_office/cardboard_box01.mdl",
	price = 2500,
	max = 2,
	cmd = "buygroßerbehälter",
	allowed = TEAM_BANKER,
	category = "Verstauung"
})

DarkRP.createEntity("Kartenlesegerät", {
	ent = "glorifiedbanking_cardreader",
	model = "models/sterling/glorifiedpig_cardreader.mdl",
	price = 2000,
	max = 1,
	cmd = "buykartenlesegerät",
	allowed = {TEAM_ZOLL, TEAM_BANKER, TEAM_GUN, TEAM_MARKET, TEAM_DOCTOR, TEAM_COOK, TEAM_REPAIR},
	category = "Verkauf"
})

print("Modern Roleplay - Entities initialisiert!")