TEAM_CITIZEN = DarkRP.createJob("Bürger", {
	color = Color(20, 150, 20, 255),
	model = {
		"models/player/group01/female_01.mdl",
		"models/player/group01/female_02.mdl",
		"models/player/group01/female_03.mdl",
		"models/player/group01/female_04.mdl",
		"models/player/group01/female_06.mdl",
		"models/player/group01/male_01.mdl",
		"models/player/group01/male_02.mdl",
		"models/player/group01/male_03.mdl",
		"models/player/group01/male_04.mdl",
		"models/player/group01/male_05.mdl",
		"models/player/group01/male_06.mdl",
		"models/player/group01/male_07.mdl",
		"models/player/group01/male_08.mdl",
		"models/player/group01/male_09.mdl"
	},
	description = [[Die Bürger sind der Grundbaustein der Stadt.]],
	weapons = {},
	command = "bürger",
	max = 0,
	salary = 80,
	admin = 0,
	vote = false,
	hasLicense = false,
	candemote = false,
	category = "Neutral",
	sortOrder = 1,
})

TEAM_PRIEST = DarkRP.createJob("Priester", {
	color = Color(51, 255, 204, 255),
	model = "models/player/magnusson.mdl",
	description = [[Die Priester halten den Glauben zur Kirche aufrecht und machen Veranstaltungen.]],
	weapons = {"weapon_bible"},
	command = "priester",
	max = 3,
	salary = 800,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 2,
	vip = true,
})

TEAM_HITMAN = DarkRP.createJob("Auftragsmörder", {
	color = Color(128, 153, 0, 255),
	model = "models/player/leet.mdl",
	description = [[Der Auftragsmörder nimmt Tötungsaufträge von Mitbürgern an und führt diese aus, um so Geld zu verdienen.
	Sollte er während eines Auftrags sein Leben verlieren oder inhaftiert werden, verliert er seinen Job.]],
	weapons = {"lockpick"},
	command = "auftragsmörder",
	max = 1,
	salary = 50,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 3,
	level = 10,
})

TEAM_LAWYER = DarkRP.createJob("Anwalt", {
	color = Color(255, 204, 51, 255),
	model = "models/player/hostage/hostage_04.mdl",
	description = [[Der Anwalt holt Personen gegen Geld aus dem Gefängnis raus.]],
	weapons = {},
	command = "anwalt",
	max = 1,
	salary = 250,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 4,
})

TEAM_BANKER = DarkRP.createJob("Banker", {
	color = Color(0, 255, 102, 255),
	model = "models/player/hostage/hostage_01.mdl",
	description = [[Der Banker lagert Geld und Gegenstände aller Art gegen eine kleine Gebühr ein.]],
	weapons = {},
	command = "banker",
	max = 3,
	salary = 200,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 5,
})

if theater and theater.settings and theater.settings.maps[game.GetMap()] then
	TEAM_THEATER = DarkRP.createJob("Kinobesitzer", {
		color = Color(153, 204, 204, 255),
		model = "models/player_moxxi.mdl",
		description = [[Der Kinobesitzer spielt mehr oder weniger lustige Videos im örtlichen Kino ab.]],
		weapons = {},
		command = "kinobesitzer",
		max = 1,
		salary = 400,
		admin = 0,
		vote = false,
		hasLicense = false,
		category = "Neutral",
		sortOrder = 6,
	})
end

TEAM_DJ = DarkRP.createJob("DJ", {
	color = Color(153, 102, 255, 255),
	model = "models/player/p2_chell.mdl",
	description = [[Der DJ spielt Musik für die Massen ab.]],
	weapons = {},
	command = "dj",
	max = 1,
	salary = 300,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 7,
})

TEAM_DRIVER = DarkRP.createJob("Taxifahrer", {
	color = Color(102, 102, 153, 255),
	model = {
		"models/player/group02/male_02.mdl",
		"models/player/group02/male_04.mdl",
		"models/player/group02/male_06.mdl",
		"models/player/group02/male_08.mdl"
	},
	description = [[Der Taxifahrer kutschiert Personen von A nach B und verlangt als Gegenleistung eine kleine Gebühr.]],
	weapons = {},
	command = "taxifahrer",
	max = 1,
	salary = 220,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 8,
	level = 5,
})

TEAM_GARDENER = DarkRP.createJob("Gärtner", {
	color = Color(0, 153, 102, 255),
	model = "models/player/alyx.mdl",
	description = [[Der Gärtner züchtet Pflanzen und verkauft deren Erträge dann später am Pflanzenmarkt.]],
	weapons = {"weapon_watercan", "weapon_hoe"},
	command = "gärtner",
	max = 4,
	salary = 100,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 9,
})

TEAM_REFFINERY = DarkRP.createJob("Ölraffinerist", {
	color = Color(245, 184, 0, 255),
	model = {
		"models/player/suits/male_01_open.mdl",
		"models/player/suits/male_02_open.mdl",
		"models/player/suits/male_03_open.mdl",
		"models/player/suits/male_04_open.mdl",
		"models/player/suits/male_05_open.mdl",
		"models/player/suits/male_06_open.mdl",
		"models/player/suits/male_07_open.mdl",
		"models/player/suits/male_08_open.mdl",
		"models/player/suits/male_09_open.mdl"
	},
	description = [[Der Ölraffinerist verkauft Treibstof, indem er Öl mit Pumpe, Bohrer und Brenner abbaut und es dann verarbeitet.]],
	weapons = {},
	command = "ölraffinerist",
	max = 3,
	salary = 120,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 10,
})

TEAM_MINER = DarkRP.createJob("Bergmann", {
	color = Color(140, 130, 70, 255),
	model = "models/player/eli.mdl",
	description = [[Der Bergmann baut Erz an Erzvenen welche an einem Punkt versammelt sind, ab und verkauft es dann, um Profit daraus zu schlagen.]],
	weapons = {"mining_pickaxe"},
	command = "bergmann",
	max = 3,
	salary = 90,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 11,
})

TEAM_METHCOOK = DarkRP.createJob("Methkoch", {
	color = Color(224, 224, 102, 255),
	model = {
		"models/player/hostage/hostage_02.mdl",
		"models/player/hostage/hostage_03.mdl",
	},
	description = [[Der Methkoch stellt chemisch Meth her und verkauft es anschließend.]],
	weapons = {},
	command = "methkoch",
	max = 3,
	salary = 50,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 12,
})

TEAM_HOBO = DarkRP.createJob("Obdachloser", {
	color = Color(80, 45, 0, 255),
	model = "models/player/corpse1.mdl",
	description = [[Die Obdachlosen sind der Abschaum der Gesellschaft.
	Sie haben keine Rechte oder Ansprüche.]],
	weapons = {"weapon_pee", "weapon_boots"},
	command = "obdachloser",
	max = 8,
	salary = 0,
	admin = 0,
	vote = false,
	hasLicense = false,
	hobo = true,
	category = "Neutral",
	sortOrder = 13,
})

TEAM_HOBOKING = DarkRP.createJob("Obdachlosenkönig", {
	color = Color(100, 45, 0, 255),
	model = "models/player/zombie_fast.mdl",
	description = [[Der Obdachlosenkönig ist der König aller Obdachlosen.
	Er plant waghalsige Aktionen und kann eine Zuflucht für alle Obdachlosen bereit stellen.]],
	weapons = {"weapon_pee", "m9k_knife", "weapon_boots"},
	command = "obdachlosenkönig",
	max = 1,
	salary = 0,
	admin = 0,
	vote = false,
	hasLicense = false,
	hobo = true,
	NeedToChangeFrom = TEAM_HOBO,
	category = "Neutral",
	sortOrder = 14,
	level = 10,
})

TEAM_STRAY = DarkRP.createJob("Streuner", {
	color = Color(100, 30, 0, 255),
	model = "models/falloutdog/falloutdog.mdl",
	description = [[Der Streuner ist ein streunender, auf der Straße lebender Hund.
	Niemand muss ihm Beachtung schenken, er kann aber auch von einem Mitbürger adoptiert werden.]],
	weapons = {"weapon_dog", "weapon_pee"},
	command = "streuner",
	max = 2,
	salary = 0,
	admin = 0,
	vote = false,
	hasLicense = false,
	hobo = true,
	category = "Neutral",
	sortOrder = 15,
	res = {
		spawn = false,
		weapons = false,
		nodoor = false,
		nouse = true,
		doorpurchase = false,
		doorpurchasereason = "Du bist ein Hund und dich interessiert der Kauf dieser Tür nicht!",
		pickup = true,
		chatsounds = false,
		cansit = false,
		talk = false,
		flashlight = false,
		zoom = false,
		buy = false,
		cars = false,
		drive = false,
		items = false,
		taser = true,
		arrestable = false,
		arrestablereason = "Hunde können nicht inhaftiert werden!",
		wantable = false,
		wantablereason = "Nach Hunden kann nicht gefahndet werden!",
		wanted = false,
		wantedreason = "Hunde können nicht fahnden!",
		warrantable = true,
		warrantablereason = "Gegen Hunde kann kein Durchsuchungsbefehl angefordert werden!",
		warrant = false,
		warrantreason = "Hunde können keine Durchsuchungsbefehle anfordern!",
	},
	health = 200,
	footstep = true,
	walkspeed = 0.6,
	runspeed = 1.15,
	hullmins = Vector(-16, -16, 0),
	hullmaxs = Vector(16, 16, 36),
	hullduckmins = Vector(-16, -16, 0),
	hullduckmaxs = Vector(16, 16, 24),
	height = 0.45,
	heightduck = 0.45,
	jumppower = 1.35,
	vip = true,
})

TEAM_TERROR = DarkRP.createJob("Terrorist", {
	color = Color(255, 0, 102, 255),
	model = "models/jessev92/kuma/characters/osama_ply.mdl",
	description = [[Der Terrorist sorgt für Terror in der ganzen Stadt und wird von allen verabscheut.]],
	weapons = {"weapon_cuff_tactical"},
	command = "terrorist",
	max = 2,
	salary = 20,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Neutral",
	sortOrder = 16,
	vip = true,
})

TEAM_DOCTOR = DarkRP.createJob("Arzt", {
	color = Color(47, 79, 79, 255),
	model = "models/player/kleiner.mdl",
	description = [[Der Arzt hat die Aufgabe die Bürger der Stadt bei Gesundheit zu halten.]],
	weapons = {"med_kit"},
	command = "arzt",
	max = 3,
	salary = 340,
	admin = 0,
	vote = false,
	hasLicense = false,
	medic = true,
	category = "Verkäufer",
	sortOrder = 1,
})

TEAM_COOK = DarkRP.createJob("Koch", {
	color = Color(238, 99, 99, 255),
	model = {
		"models/player/mossman.mdl",
		"models/player/mossman_arctic.mdl",
	},
	description = [[Der Koch versorgt die ganze Stadt mit überlebensnotwendiger Nahrung.]],
	weapons = {},
	command = "koch",
	max = 3,
	salary = 320,
	admin = 0,
	vote = false,
	hasLicense = false,
	cook = true,
	category = "Verkäufer",
	sortOrder = 2,
})

TEAM_REPAIR = DarkRP.createJob("Mechaniker", {
	color = Color(102, 51, 51, 255),
	model = "models/player/mechanic.mdl",
	description = [[Der Mechaniker repariert Autos und betankt diese.
	Außerdem schleppt er Autos auf Anfrage ab oder zieht diese gegen eine Gebühr aus misslichen Lagen heraus.]],
	weapons = {"vc_wrench", "weapon_fuel"},
	command = "mechaniker",
	max = 2,
	salary = 140,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Verkäufer",
	sortOrder = 3,
	level = 5,
})

TEAM_GUN = DarkRP.createJob("Waffenhändler", {
	color = Color(255, 140, 0, 255),
	model = "models/player/monk.mdl",
	description = [[Der Waffenhändler verkauft Waffen von groß bis klein an die Stadt.]],
	weapons = {},
	command = "waffenhändler",
	max = 2,
	salary = 200,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Verkäufer",
	sortOrder = 4,
	level = 10,
})

TEAM_MARKET = DarkRP.createJob("Schwarzmarkthändler", {
	color = Color(0, 0, 0, 255),
	model = "models/player/barney.mdl",
	description = [[Der Schwarzmarkthändler verkauft illegale Spezialausrüstung.]],
	weapons = {},
	command = "schwarzmarkthändler",
	max = 2,
	salary = 150,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Verkäufer",
	sortOrder = 5,
	level = 10,
})

TEAM_DEALER = DarkRP.createJob("Drogenhändler", {
	color = Color(204, 204, 0, 255),
	model = "models/player/soldier_stripped.mdl",
	description = [[Der Drogenhändler handelt mit illegalen Drogen und macht so sein Geld.]],
	weapons = {"weapon_watercan"},
	command = "drogenhändler",
	max = 4,
	salary = 60,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Verkäufer",
	sortOrder = 6,
})

TEAM_SECURITY = DarkRP.createJob("Sicherheitsmann", {
	color = Color(204, 102, 255, 255),
	model = "models/player/odessa.mdl",
	description = [[Der Sicherheitsmann kann angeheuert werden, um eine Gruppe oder ein Privatgrundstück vor Eindringlingen zu schützen.]],
	weapons = {"stunstick", "weaponchecker", "weapon_cuff_elastic"},
	command = "sicherheitsmann",
	max = 8,
	salary = 400,
	admin = 0,
	vote = false,
	hasLicense = true,
	category = "Sicherheit",
	sortOrder = 1,
})

TEAM_MAYOR = DarkRP.createJob("Bürgermeister", {
	color = Color(150, 20, 20, 255),
	model = "models/player/breen.mdl",
	description = [[Der Bürgermeister hat das Recht jeden Staatsbeamten zu befehligen.
	Er legt Gesetze und Steuern fest, stellt Waffenlizenzen aus, veranlasst Lotterien und ist für Lockdowns verantwortlich.]],
	weapons = {"radio_device"},
	command = "bürgermeister",
	max = 1,
	salary = 2000,
	admin = 0,
	vote = false,
	hasLicense = false,
	mayor = true,
	category = "Staat",
	sortOrder = 1,
	level = 5,
})

TEAM_SECRETSERVICE = DarkRP.createJob("Geheimdienst", {
	color = Color(200, 20, 20, 255),
	model = "models/player/guard_pack/guard_09.mdl",
	description = [[Der Geheimdienst hat die Pflicht den Bürgermeister vor allerlei Gefahren zu beschützen.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "weapon_taser", "stunstick", "weapon_cuff_police", "m9k_vector"},
	command = "geheimdienst",
	max = 2,
	salary = 500,
	admin = 0,
	vote = false,
	hasLicense = true,
	category = "Staat",
	sortOrder = 2,
	ammo = {
		["smg1"] = 120,
	},
	customCheck = function(ply)
		return team.NumPlayers(TEAM_MAYOR) > 0
	end,
	CustomCheckFailMsg = function(ply)
	 	return "Es muss ein Bürgermeister präsent sein, damit dieser Job ausgeübt werden kann!"
	end,
	level = 10,
})

local police_skin_vars = {
	{86400, 1},
	{259200, 2},
	{604800, 3},
	{1209600, 4},
}

local chief_skin_vars = {
	{86400, 5},
	{172800, 6},
	{259200, 7},
	{345600, 8},
	{432000, 9},
	{518400, 10},
	{604800, 11},
	{1209600, 12},
}

hook.Add("PlayerSetModel", "DarkRP_SetSkin", function(ply)
	local tm = ply:Team()
	if tm == TEAM_POLICE or tm == TEAM_JAILGUARD then
		if ply.GetUTimeTotalTime then
			local skin = 1
			local last = 0
			for k, v in ipairs(police_skin_vars) do
				if ply:GetUTimeTotalTime() >= v[1] and last < v[1] then
					skin = v[2]
					last = v[1]
				end
			end
			ply:SetSkin(skin)
		else
			ply:SetSkin(1)
		end
	elseif tm == TEAM_CHIEF then
		if ply.GetUTimeTotalTime then
			local skin = 5
			local last = 0
			for k, v in ipairs(chief_skin_vars) do
				if ply:GetUTimeTotalTime() >= v[1] and last < v[1] then
					skin = v[2]
					last = v[1]
				end
			end
			ply:SetSkin(skin)
		else
			ply:SetSkin(5)
		end
	else
		ply:SetSkin(0)
	end
end)

TEAM_POLICE = DarkRP.createJob("Polizist", {
	color = Color(25, 25, 170, 255),
	model = {
		"models/player/clannypolice/male_02.mdl",
		"models/player/clannypolice/male_04.mdl",
		"models/player/clannypolice/male_05.mdl",
		"models/player/clannypolice/male_06.mdl",
		"models/player/clannypolice/male_07.mdl",
		"models/player/clannypolice/male_08.mdl",
		"models/player/clannypolice/male_09.mdl"
	},
	description = [[Die Polizei hat die Aufgabe die Stadt vor Verbrechern zu beschützen.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "weapon_taser", "weapon_emp", "weapon_tow", "stunstick", "weapon_cuff_police", "m9k_usp", "door_ram", "weapon_fine"},
	command = "polizist",
	max = 8,
	salary = 300,
	admin = 0,
	vote = false,
	hasLicense = true,
	category = "Staat",
	sortOrder = 3,
	ammo = {
		["pistol"] = 60,
	},
	level = 5,
})

TEAM_CHIEF = DarkRP.createJob("Wachtmeister", {
	color = Color(20, 20, 255, 255),
	model = {
		"models/player/clannypolice/male_02.mdl",
		"models/player/clannypolice/male_04.mdl",
		"models/player/clannypolice/male_05.mdl",
		"models/player/clannypolice/male_06.mdl",
		"models/player/clannypolice/male_07.mdl",
		"models/player/clannypolice/male_08.mdl",
		"models/player/clannypolice/male_09.mdl"
	},
	description = [[Der Wachtmeister hat die Kontrolle über alle Polizisten.
	Er kann Waffenlizenzen ausstellen und Gefängnispositionen verändern.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "stunstick", "weapon_taser", "weapon_emp", "weapon_tow", "weapon_cuff_police", "m9k_model500", "door_ram", "weapon_fine"},
	command = "wachtmeister",
	max = 1,
	salary = 350,
	admin = 0,
	vote = false,
	hasLicense = true,
	chief = true,
	NeedToChangeFrom = TEAM_POLICE,
	category = "Staat",
	sortOrder = 4,
	ammo = {
		["357"] = 20,
	},
	skin = 5,
	level = 10,
})

TEAM_JAILGUARD = DarkRP.createJob("Gefängniswärter", {
	color = Color(46, 0, 184, 255),
	model = {
		"models/player/clannypolice/male_02.mdl",
		"models/player/clannypolice/male_04.mdl",
		"models/player/clannypolice/male_05.mdl",
		"models/player/clannypolice/male_06.mdl",
		"models/player/clannypolice/male_07.mdl",
		"models/player/clannypolice/male_08.mdl",
		"models/player/clannypolice/male_09.mdl"
	},
	description = [[Der Gefängniswärter wacht über die Gefängnisse und entscheidet darüber wer Eintritt hat und wer nicht.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "stunstick", "weapon_taser", "weapon_cuff_police", "m9k_colt1911"},
	command = "gefängniswärter",
	max = 2,
	salary = 400,
	admin = 0,
	vote = false,
	hasLicense = true,
	category = "Staat",
	sortOrder = 5,
	ammo = {
		["pistol"] = 28,
	},
	level = 5,
})

TEAM_SEK = DarkRP.createJob("SEK-Einheit", {
	color = Color(0, 0, 204, 255),
	model = "models/player/swat.mdl",
	description = [[Das SEK greift ausschließlich bei Notfällen ein und versucht gezielt bewaffnete/gefährliche Verbrecher auszuschalten.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "stunstick", "weapon_emp", "keypad_cracker", "riot_shield", "m9k_glock", "m9k_mp5", "weapon_cuff_police", "door_ram"},
	command = "sek",
	max = 4,
	salary = 250,
	admin = 0,
	vote = false,
	hasLicense = true,
	category = "Staat",
	sortOrder = 6,
	ammo = {
		["pistol"] = 64,
		["smg1"] = 120,
	},
	level = 10,
})

TEAM_SEKSNIPER = DarkRP.createJob("SEK-Scharfschütze", {
	color = Color(0, 0, 204, 255),
	model = "models/player/riot.mdl",
	description = [[Der SEK-Scharfschütze gibt dem SEK Unterstützung mit dem Scharfschützengewehr.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "stunstick", "weapon_emp", "m9k_ump45", "m9k_m98b", "weapon_cuff_police", "door_ram"},
	command = "sekscharfschütze",
	max = 1,
	salary = 280,
	admin = 0,
	vote = false,
	hasLicense = true,
	NeedToChangeFrom = {TEAM_SEK, TEAM_SEKLEADER},
	category = "Staat",
	sortOrder = 7,
	ammo = {
		["smg1"] = 50,
		["SniperPenetratedRound"] = 30,
	},
	level = 10,
})	

TEAM_SEKLEADER = DarkRP.createJob("SEK-Leiter", {
	color = Color(0, 0, 255, 255),
	model = "models/player/urban.mdl",
	description = [[Der SEK-Leiter ist der Anführer aller SEK-Einheiten und kann notfalls auch den Wachtmeister und die Polizisten befehligen.]],
	weapons = {"arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "stunstick", "weapon_emp", "keypad_cracker", "weapon_breach", "heavy_shield", "m9k_m92beretta", "m9k_m4a1", "weapon_cuff_police", "door_ram"},
	command = "sekleiter",
	max = 1,
	salary = 320,
	admin = 0,
	vote = false,
	hasLicense = true,
	NeedToChangeFrom = {TEAM_SEK, TEAM_SEKSNIPER},
	category = "Staat",
	sortOrder = 8,
	ammo = {
		["pistol"] = 30,
		["ar2"] = 120,
		["breach_charges"] = 10
	},
	level = 15,
})

TEAM_POLICEDOG = DarkRP.createJob("Polizeihund", {
	color = Color(25, 100, 170, 255),
	model = "models/falloutdog/falloutdog.mdl",
	description = [[Der Polizeihund arbeitet für den Staat.
	Er unterstützt Investigationen und Einsätze.]],
	weapons = {"weapon_dog", "weapon_pee"},
	command = "polizeihund",
	max = 1,
	salary = 200,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Staat",
	sortOrder = 9,
	res = {
		spawn = false,
		weapons = false,
		nodoor = false,
		nouse = true,
		doorpurchase = false,
		doorpurchasereason = "Du bist ein Hund und dich interessiert der Kauf dieser Tür nicht!",
		pickup = true,
		chatsounds = false,
		cansit = false,
		talk = false,
		flashlight = false,
		zoom = false,
		buy = false,
		cars = false,
		drive = false,
		items = false,
		taser = true,
		arrestable = false,
		arrestablereason = "Hunde können nicht inhaftiert werden!",
		wantable = false,
		wantablereason = "Nach Hunden kann nicht gefahndet werden!",
		wanted = false,
		wantedreason = "Hunde können nicht fahnden!",
		warrantable = true,
		warrantablereason = "Gegen Hunde kann kein Durchsuchungsbefehl angefordert werden!",
		warrant = false,
		warrantreason = "Hunde können keine Durchsuchungsbefehle anfordern!",
	},
	health = 250,
	footstep = true,
	walkspeed = 0.65,
	runspeed = 1.2,
	hullmins = Vector(-16, -16, 0),
	hullmaxs = Vector(16, 16, 36),
	hullduckmins = Vector(-16, -16, 0),
	hullduckmaxs = Vector(16, 16, 24),
	height = 0.45,
	heightduck = 0.45,
	jumppower = 1.4,
	level = 10,
})

TEAM_ZOLL = DarkRP.createJob("Zoll", {
	color = Color(0, 153, 255, 255),
	model = {
		"models/taggart/police01/male_05.mdl",
		"models/taggart/police01/male_07.mdl",
		"models/taggart/police01/male_08.mdl",
		"models/taggart/police01/male_09.mdl",
		"models/taggart/police01/male_03.mdl",
	},
	description = [[Der Zoll errichtet Straßensperren und verlangt für die Durchlassung bis zu $2.000 von Passanten oder $4.000 bei Autos.]],
	weapons = {"arrest_stick", "weaponchecker", "radio_device", "stunstick", "weapon_taser", "weapon_emp", "weapon_tow", "m9k_sig_p229r", "weapon_cuff_police", "door_ram", "weapon_fine"},
	command = "zoll",
	max = 3,
	salary = 340,
	admin = 0,
	vote = false,
	hasLicense = true,
	category = "Staat",
	sortOrder = 10,
	ammo = {
		["pistol"] = 48,
	},
	level = 5,
})

TEAM_GANGSTER = DarkRP.createJob("Gangster", {
	color = Color(75, 75, 75, 255),
	model = {
		"models/player/group03/female_01.mdl",
		"models/player/group03/female_02.mdl",
		"models/player/group03/female_03.mdl",
		"models/player/group03/female_04.mdl",
		"models/player/group03/female_06.mdl",
		"models/player/group03/male_01.mdl",
		"models/player/group03/male_02.mdl",
		"models/player/group03/male_03.mdl",
		"models/player/group03/male_04.mdl",
		"models/player/group03/male_05.mdl",
		"models/player/group03/male_06.mdl",
		"models/player/group03/male_07.mdl",
		"models/player/group03/male_08.mdl",
		"models/player/group03/male_09.mdl"
	},
	description = [[Die Gangster versetzen die ganze Stadt in Angst und Schrecken.]],
	weapons = {"weaponchecker", "radio_device"},
	command = "gangster",
	max = 6,
	salary = 40,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Gang",
	sortOrder = 1
})

TEAM_GANGSTERBOSS = DarkRP.createJob("Gangsterboss", {
	color = Color(50, 50, 50, 255),
	model = "models/player/gman_high.mdl",
	description = [[Der Gangsterboss befehligt die Gangster, plant gewaltsame Einbrüche, Raubzüge und Geiselnahmen.]],
	weapons = {"unarrest_stick", "weapon_cuff_standard", "lockpick", "weaponchecker", "radio_device"},
	command = "gangsterboss",
	max = 1,
	salary = 75,
	admin = 0,
	vote = false,
	hasLicense = false,
	NeedToChangeFrom = TEAM_GANGSTER,
	category = "Gang",
	sortOrder = 2,
	level = 5,
})

TEAM_MAFIOSO = DarkRP.createJob("Mafioso", {
	color = Color(175, 175, 175, 255),
	model = {
		"models/humans/mg_mafia/male_02.mdl",
		"models/humans/mg_mafia/male_04.mdl",
		"models/humans/mg_mafia/male_06.mdl",
		"models/humans/mg_mafia/male_07.mdl",
		"models/humans/mg_mafia/male_09.mdl"
	},
	description = [[Die Mafia plant organisiert aus Verbrechen Gewinn zu schlagen.]],
	weapons = {"weaponchecker", "radio_device"},
	command = "mafioso",
	max = 6,
	salary = 160,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Gang",
	sortOrder = 3
})

TEAM_MAFIABOSS = DarkRP.createJob("Mafiaboss", {
	color = Color(130, 130, 130, 255),
	model = "models/humans/mg_mafia/male_08.mdl",
	description = [[Der Mafiaboss befehligt die Mafia, nimmt Schutzgeld, plant gewaltsame Einbrüche, Raubzüge und Geiselnahmen.]],
	weapons = {"unarrest_stick", "weapon_cuff_standard", "lockpick", "weaponchecker", "radio_device"},
	command = "mafiaboss",
	max = 1,
	salary = 240,
	admin = 0,
	vote = false,
	hasLicense = false,
	NeedToChangeFrom = TEAM_MAFIOSO,
	category = "Gang",
	sortOrder = 4,
	level = 5,
})

TEAM_REBEL = DarkRP.createJob("Rebell", {
	color = Color(255, 130, 0, 255),
	model = "models/player/phoenix.mdl",
	description = [[Die Rebellen rebellieren gegen den Staat und sorgen für mächtig Ärger in der Stadt.]],
	weapons = {"weaponchecker", "radio_device"},
	command = "rebell",
	max = 6,
	salary = 30,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Gang",
	sortOrder = 5
})

TEAM_REBELBOSS = DarkRP.createJob("Rebellenboss", {
	color = Color(255, 100, 0, 255),
	model = "models/player/guerilla.mdl",
	description = [[Der Rebellenboss befehligt die Rebellen, plant gewaltsame Einbrüche und Geiselnahmen.
	Außerdem rebelliert er gegen den Staat.]],
	weapons = {"unarrest_stick", "weapon_cuff_standard", "lockpick", "weaponchecker", "radio_device"},
	command = "rebellenboss",
	max = 1,
	salary = 50,
	admin = 0,
	vote = false,
	hasLicense = false,
	NeedToChangeFrom = TEAM_REBEL,
	category = "Gang",
	sortOrder = 6,
	level = 5,
})

TEAM_THIEF = DarkRP.createJob("Dieb", {
	color = Color(102, 0, 153, 255),
	model = "models/player/arctic.mdl",
	description = [[Die Diebe bestehlen unahnende Mitbürger und brechen möglichst unauffällig in Gebäude anderer ein um deren Inhalte zu stehlen.]],
	weapons = {"weapon_pickpocket", "weaponchecker", "radio_device"},
	command = "dieb",
	max = 8,
	salary = 50,
	admin = 0,
	vote = false,
	hasLicense = false,
	category = "Gang",
	sortOrder = 7
})

TEAM_MASTERTHIEF = DarkRP.createJob("Meisterdieb", {
	color = Color(102, 0, 123, 255),
	model = "models/player/arctic.mdl",
	description = [[Der Meisterdieb ist der eventuelle Anführer der Diebe.
	Er kann die Diebe anführen oder es auch sein lassen.]],
	weapons = {"weapon_pickpocket", "lockpick", "weapon_cuff_elastic", "weaponchecker", "radio_device"},
	command = "meisterdieb",
	max = 1,
	salary = 60,
	admin = 0,
	vote = false,
	hasLicense = false,
	NeedToChangeFrom = TEAM_THIEF,
	category = "Gang",
	sortOrder = 8,
	level = 5,
})

TEAM_OWNER = DarkRP.createJob("Owner on Duty", {
	color = Color(102, 0, 51, 255),
	model = {
		"models/player/lich_king_wow_masked.mdl",
		"models/player/lich_king_wow_maskless.mdl"
	},
	description = [[>>Nur für Leitungsebene vorgesehen<<]],
	weapons = {"stunstick", "arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "weapon_taser", "weapon_emp", "m9k_minigun", "weapon_keypadchecker", "vc_wrench", "weapon_fuel", "door_ram", "med_kit"},
	command = "ood",
	max = 1,
	salary = 500,
	admin = 1,
	vote = false,
	hasLicense = true,
	candemote = false,
	category = "Verwaltung",
	sortOrder = 1,
	ammo = {
		["ar2"] = 1000
	},
	customCheck = function(ply)
		return MG_OwnerGroups[ply:GetUserGroup()]
	end,
	CustomCheckFailMsg = function(ply)
	 	return "Du musst Owner sein, um diesen Job ausüben zu können!"
	end
})

TEAM_STAFF = DarkRP.createJob("Staff on Duty", {
	color = Color(245, 0, 61, 255),
	model = "models/player/combine_super_soldier.mdl",
	description = [[>>Nur für Teammitglieder<<.
	Nur bei aktiver Administration.]],
	weapons = {"stunstick", "arrest_stick", "unarrest_stick", "weaponchecker", "radio_device", "weapon_taser", "weapon_emp", "weapon_keypadchecker", "vc_wrench", "weapon_fuel", "door_ram", "med_kit"},
	command = "sod",
	max = 4,
	salary = 400,
	admin = 1,
	vote = false,
	hasLicense = true,
	candemote = false,
	category = "Verwaltung",
	sortOrder = 2,
	PlayerSetModel = function(ply)
		if !MG_AdminGroups[ply:GetUserGroup()] then
			return "models/player/combine_soldier_prisonguard.mdl"
		end
	end,
	customCheck = function(ply)
		return MG_ModGroups[ply:GetUserGroup()]
	end,
	CustomCheckFailMsg = function(ply)
	 	return "Du musst Teammitglied sein, um diesen Job ausüben zu können!"
	end
})

TEAM_EVENT = DarkRP.createJob("Event", {
	color = Color(20, 235, 20, 255),
	model = {
		"models/player/group01/female_01.mdl",
		"models/player/group01/female_02.mdl",
		"models/player/group01/female_03.mdl",
		"models/player/group01/female_04.mdl",
		"models/player/group01/female_06.mdl",
		"models/player/group01/male_01.mdl",
		"models/player/group01/male_02.mdl",
		"models/player/group01/male_03.mdl",
		"models/player/group01/male_04.mdl",
		"models/player/group01/male_05.mdl",
		"models/player/group01/male_06.mdl",
		"models/player/group01/male_07.mdl",
		"models/player/group01/male_08.mdl",
		"models/player/group01/male_09.mdl"
	},
	description = [[Wird nur während Events benutzt.]],
	weapons = {"radio_device"},
	command = "event",
	max = 0,
	salary = 0,
	admin = 0,
	vote = false,
	hasLicense = false,
	candemote = false,
	category = "Event",
	sortOrder = 1,
	res = {
		spawn = true,
		weapons = true,
		nodoor = false,
		nouse = false,
		doorpurchase = true,
		pickup = true,
		chatsounds = true,
		cansit = true,
		talk = true,
		flashlight = true,
		zoom = true,
		buy = true,
		cars = true,
		drive = true,
		items = false,
		arrestable = false,
		arrestablereason = "Dieser Spieler nimmt an einem Event teil!",
		wantable = false,
		wantablereason = "Dieser Spieler nimmt an einem Event teil!",
		wanted = false,
		wantedreason = "Dieser Spieler nimmt an einem Event teil!",
		warrantable = false,
		warrantablereason = "Dieser Spieler nimmt an einem Event teil!",
	},
	customCheck = function(ply)
		return MG_ModGroups[ply:GetUserGroup()]
	end,
	CustomCheckFailMsg = function(ply)
	 	return "Nur Teammitglieder können diesen Beruf setzen!"
	end
})

GAMEMODE.DefaultTeam = TEAM_CITIZEN

GAMEMODE.CivilProtection = {
	[TEAM_MAYOR] = true,
	[TEAM_SECRETSERVICE] = true,
	[TEAM_SEKLEADER] = true,
	[TEAM_SEKSNIPER] = true,
	[TEAM_SEK] = true,
	[TEAM_CHIEF] = true,
	[TEAM_POLICE] = true,
	[TEAM_POLICEDOG] = true,
	[TEAM_JAILGUARD] = true,
	[TEAM_ZOLL] = true
}

DarkRP.addHitmanTeam(TEAM_HITMAN)

hook.Add("playerCanChangeTeam", "DarkRP_VIPRestrictions", function(ply, tm, force)
	if force then return end
	local job_tbl = RPExtraTeams[tm]
	if job_tbl.vip and !MG_VIPGroups[ply:GetUserGroup()] then
		return false, "Du musst VIP sein, um "..team.GetName(tm).." auszuüben!"
	end
end)

print("Modern Roleplay - Jobs initialisiert!")