surface.CreateFont("AW_TrebuchetMS20", {font = "Trebuchet MS", size = 20, weight = 900})

local info, barstart, text, textw
local font = "AW_TrebuchetMS20"
local text2 = "Drücke F2, um dies zu melden."
local text3 = "Staftat wird gemeldet..."
local text4 = "Du hast gesehen, wie %s die Straftat %q begangen hat."

local canaccept = false
local function AcceptReport(ply, button)
	if canaccept and button == KEY_F2 then
		AutoWanted.AcceptReport()
	end
end

local c1 = HSVToColor(80, 0.5, 0.4)
local c2 = HSVToColor(80, 0.5, 0.7)
local c3 = HSVToColor(80, 0.5, 0.2)
local boxh = 58
local function DrawReportHUD()
	if !info then return end
	ply = LocalPlayer()
	if !ply:Alive() or !IsValid(info.cr) then
		info = nil
		return
	end
	local w, h = ScrW(), ScrH()
	local boxw = textw + 8
	draw.RoundedBox(4, w - boxw - 40, h / 2, boxw, boxh, c1)
	surface.SetTextColor(c2)
	surface.SetFont(font)
	surface.SetTextPos(w - boxw - 36, h / 2 + 4)
	surface.DrawText(text)
	draw.RoundedBox(2, w - boxw - 36, h / 2 + 50, boxw - 8, 6, c3)
	if barstart then
		local response = AutoWanted.ResponseTime
		local cur_time = CurTime()
		local barw = math.Clamp(((cur_time - barstart) / response) * (boxw - 8), 4, boxw - 8)
		draw.RoundedBox(2, w - boxw - 36, h / 2 + 50, barw, 6, c2)
		if cur_time > barstart + response then
			info = nil
		end
		surface.SetTextPos(w - boxw / 2 - 40 - 131 / 2, h / 2 + 28)
		surface.DrawText(text3)
	else
		surface.SetTextPos(w - boxw / 2 - 40 - 163 / 2, h / 2 + 28)
		surface.DrawText(text2)
	end
end

net.Receive("AutoWanted_StartTimer", function()
	local criminal = net.ReadEntity()
	local reason = net.ReadString()
	if !IsValid(criminal) then return end
	barstart = nil
	info = {cr = criminal, re = reason}
	text = string.format(text4, info.cr:Name(), info.re)
	surface.SetFont(font)
	textw = surface.GetTextSize(text)
	canaccept = true
	timer.Create("AutoWanted_Report", AutoWanted.ReactTime, 1, function()
		info = nil
		canaccept = false
	end)
	hook.Add("PlayerButtonDown", "AutoWanted_ButtonPress", AcceptReport)
	hook.Add("HUDPaint", "AutoWanted_PaintHUD", DrawReportHUD)
end)

net.Receive("AutoWanted_AbortTimer", function()
	timer.Remove("AutoWanted_Report")
	canaccept = false
	info = nil
	text = nil
	hook.Remove("PlayerButtonDown", "AutoWanted_ButtonPress")
	hook.Remove("HUDPaint", "AutoWanted_PaintHUD")
end)

function AutoWanted.AcceptReport()
	timer.Remove("AutoWanted_Report")
	canaccept = false
	barstart = CurTime()
	RunConsoleCommand("wanted_acceptwanted")
end