local PANEL = {}
function PANEL:Init()
	self:SetTitle("")
	self:SetSize(600, 400)
	self:ShowCloseButton(false)
	self:MakePopup()
	self.Paint = MG_Theme.Theme.Frame.Paint
	self.PaintOver = MG_Theme.Theme.Frame.PaintOver
	self:Center()
	local Close = vgui.Create("DButton", self)
	Close:SetSize(50, 20)
	Close:SetPos(self:GetWide() - 52, 2)
	Close:SetText("X")
	Close:SetFont("MG_Theme_Close")
	Close:SetTextColor(color_white)
	Close.Paint = function(self, w, h)
		local col
		if self:IsHovered() then
			col = Color(255, 100, 100)
		else
			col = Color(200, 50, 50)
		end
		draw.RoundedBox(4, 0, 0, w, h, col)
	end
	Close.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		self:Remove()
	end
	self.PlayerList = self:Add("DListView")
	self.PlayerList:Dock(LEFT)
	self.PlayerList:SetMultiSelect(false)
	self.PlayerList:AddColumn("Person")
	self.PlayerList:AddColumn("Job")
	self.PlayerList:SetWidth(400)
	self.PnlList = self:Add("DPanelList")
	self.PnlList:DockMargin(2, 0, 0, 0)
	self.PnlList:Dock(FILL)
	self.ReasonEntry = self:Add("DTextEntry")
	self.ReasonEntry:SetText("Grund")
	self.ReasonEntry.OldMousePressed = self.ReasonEntry.OnMousePressed
	function self.ReasonEntry:OnMousePressed(...)
		self:OldMousePressed(...)
		if (self:GetValue() == "Grund") then
			self:SetValue("")
		end
	end
	MG_Theme.Theme.TextEntry.Setup(self.ReasonEntry)
	self.PnlList:AddItem(self.ReasonEntry)
	self.Btn = self:Add("DButton")
	self.Btn:SetText("")
	self.PnlList:AddItem(self.Btn)
	MG_Theme.Theme.Button.SetupTheme(self.Btn)
	self.Btn:SetTextColor(color_white)
	self.Btn.DoClick = function()
		local reason = self.ReasonEntry:GetText()
		if string.lower(reason) == "grund" or string.lower(reason) == "du musst einen grund angeben!" then
			self.ReasonEntry:SetText("Du musst einen Grund angeben!")
			return
		end
		if self.PlayerList:GetSelectedLine() then
			surface.PlaySound("ui/buttonclick.wav")
			net.Start("dm_demote")
				net.WriteEntity(self.Players[self.PlayerList:GetSelectedLine()])
				net.WriteString(self.ReasonEntry:GetText())
			net.SendToServer()
			self:Remove()
		end
	end
end

function PANEL:UpdatePlayers(lst, header, accept)
	self:SetTitle(header)
	self.Btn:SetText(accept)
	self.Players = lst
	for _,v in ipairs(lst) do
		if !IsValid(v) then continue end
		self.PlayerList:AddLine(v:Name(), v:getDarkRPVar("job"))
	end
	MG_Theme.Theme.ListView.SetupTheme(self.PlayerList)
end
vgui.Register("DemoteMenu", PANEL, "DFrame")

local demotemenu
net.Receive("dm_open", function()
	local header = net.ReadString()
	local accept = net.ReadString()
	local players = net.ReadTable()
	if IsValid(demotemenu) then demotemenu:Close() end
	demotemenu = vgui.Create("DemoteMenu")
	demotemenu:UpdatePlayers(players, header, accept)
end)

net.Receive("dm_msgbox", function()
	local str = net.ReadString()
	Derma_Message(str, "Entlassungsbenachrichtigung", "Bestätigen")
end)