local weapon = weapons.GetStored
local entity = scripted_ents.GetStored

mg_weapon_override = mg_weapon_override or false

local function ModifyEntities()
	-- Kamera-Beschränkung
	weapon("gmod_camera").PrintName = "Kamera"
	weapon("gmod_camera").Tick = function(self)
		if CLIENT and self.Owner != LocalPlayer() then return end
		local cmd = self.Owner:GetCurrentCommand()
		if !cmd or !cmd:KeyDown(IN_ATTACK2) then return end
		self:SetZoom(math.Clamp(self:GetZoom() + cmd:GetMouseY() * FrameTime() * 6.6, 1, 140))
		self:SetRoll(self:GetRoll() + cmd:GetMouseX() * FrameTime() * 1.65)
	end

	-- DarkRP Waffen-Editierungen
	weapon("keys").PrintName = "Schlüssel"
	weapon("keys").Instructions = "Linksklick zum Abschließen.\nRechtsklick zum Aufschließen.\nNachladen auf eine Tür für Tür-Einstellungen oder Gestenmenü."
	weapon("keys").Purpose = "Hiermit können Türen auf/abgeschlossen werden oder Gesten vorgespielt werden."
	weapon("keys").Primary.Delay = 0.6
	weapon("keys").Secondary.Delay = 0.6
	weapon("weaponchecker").PrintName = "Waffenchecker"
	weapon("weaponchecker").Instructions = "Linksklick, um Person nach Waffen zu durchsuchen.\nRechtklick, um jegliche Waffen zu konfiszieren.\nNachladen, um Waffen wieder retour zu geben."
	weapon("weaponchecker").Purpose = "Dient zum Überprüfen und Konfiszieren von Waffen anderer Personen."
	weapon("pocket").PrintName = "Tasche"
	weapon("pocket").Instructions = "Linksklick, um Sachen aufzuheben.\nRechtsklick, um Sachen aus der Tasche zu werfen.\nNachladen, um ein Menü mit Überblick auf die Inhalte der Tasche anzeigen zu lassen."
	weapon("pocket").Purpose = "Hiermit können Gegenstände in deine Tasche aufgenommen werden."
	weapon("door_ram").PrintName = "Rammbock"
	weapon("door_ram").Instructions = "Linksklick, um Türen aufzubrechen, Props zu entfrieren oder Personen aus Fahrzeugen zu werfen.\nRechtsklick zum Bereithalten."
	weapon("door_ram").Purpose = "Dient zum Aufbrechen von Türen, zum Entfrieren von Props oder zum Rauswerfen von Personen aus Fahrzeugen."
	weapon("stunstick").PrintName = "Schlagstock"
	weapon("stunstick").Instructions = "Linksklick zum Disziplinieren.\nRechtsklick für einen schädlichen Elektroschlag."
	weapon("stunstick").Purpose = "Dient zum Disziplinieren anderer Personen und zum Konfiszieren illegaler Gegenstände.\nFür das Konfiszieren illegaler Gegenstände erhält man Geld."
	weapon("arrest_stick").PrintName = "Haftstab"
	weapon("arrest_stick").Instructions = "Linksklick zum Inhaftieren einer Person.\nRechtsklick zum Wechseln zwischen dem Haft und Frei-Stab."
	weapon("arrest_stick").Purpose = "Dient zum Inhaftieren von Straftätern.\nEin Häftling erhält eine höhere Haftstrafe bei erneuter Anwendung."
	weapon("unarrest_stick").PrintName = "Freistab"
	weapon("unarrest_stick").Instructions = "Linksklick, um Häftlinge aus der Haft zu entlassen.\nRechtsklick zum Wechseln zwischen dem Haft und Frei-Stab."
	weapon("unarrest_stick").Purpose = "Dient zum Befreien von Häftlingen aus dem Gefängnis."
	weapon("med_kit").Instructions = "Linksklick, um Verletzte zu heilen.\nRechtsklick, um dich selbst zu heilen."
	weapon("med_kit").Purpose = "Heilt verletzte Mitbürger."
	weapon("med_kit").Description = nil
	weapon("lockpick").PrintName = "Brechstange"
	weapon("lockpick").SlotPos = 100
	weapon("lockpick").Instructions = "Linksklick oder Rechtsklick zum Aufbrechen von Türen/Fading Doors."
	weapon("weapon_keypadchecker").Instructions = "Linksklick auf ein Keypad oder auf eine Fading Door um sie zu überprüfen.\nRechtsklick, um die gesammelten Informationen zurückzusetzen."

	weapon("weaponchecker").MinCheckTime = 1
	weapon("weaponchecker").MaxCheckTime = 1
	weapon("weaponchecker").MinConfiscateTime = 3
	weapon("weaponchecker").MaxConfiscateTime = 3
	weapon("weapon_m42").DarkRPViewModelBoneManipulations = nil

	-- Waffenrad-Bilder
	if CLIENT then
		weapon("keys").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_key")
		weapon("pocket").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_pocket")
		weapon("weaponchecker").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_check")
		weapon("arrest_stick").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_arrest")
		weapon("arrest_stick").BounceWeaponIcon = false
		weapon("unarrest_stick").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_unarrest")
		weapon("unarrest_stick").BounceWeaponIcon = false
		weapon("stunstick").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_stun")
		weapon("stunstick").BounceWeaponIcon = false
		weapon("med_kit").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_medkit")
		weapon("med_kit").BounceWeaponIcon = false
		weapon("door_ram").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_ram")
		weapon("door_ram").BounceWeaponIcon = false
		weapon("lockpick").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_lockpick")
		weapon("lockpick").BounceWeaponIcon = false
		weapon("weapon_fists").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_fist")
		weapon("weapon_pee").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_piss")
		weapon("weapon_pickpocket").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_theft")
		weapon("weapon_boots").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_shoe")
		weapon("weapon_dog").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_dog")
		weapon("weapon_boots").BounceWeaponIcon = false
		weapon("weapon_taser").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_taser")
		weapon("weapon_taser").BounceWeaponIcon = false
		weapon("weapon_emp").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_emp")
		weapon("weapon_emp").BounceWeaponIcon = false
		weapon("weapon_tow").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_tow")
		weapon("weapon_tow").BounceWeaponIcon = false
		weapon("weapon_breach").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_slam")
		weapon("weapon_breach").BounceWeaponIcon = false
		weapon("weapon_watercan").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_watercan")
		weapon("weapon_watercan").BounceWeaponIcon = false
		weapon("weapon_popcorn").WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_popcorn")
		weapon("weapon_popcorn").BounceWeaponIcon = false

		local anim = weapon("animation_base")
		if anim then
			anim.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_actions")
		end

		local hoe = weapon("weapon_hoe")
		if hoe then
			hoe.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_hoe")
			hoe.BounceWeaponIcon = false
		end

		local pickaxe = weapon("mining_pickaxe")
		if pickaxe then
			pickaxe.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_pickaxe")
			pickaxe.BounceWeaponIcon = false
		end

		local inv = weapon("itemstore_pickup")
		if inv then
			inv.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_backpack")
		end

		local radio = weapon("radio_device")
		if radio then
			radio.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_radio")
			radio.BounceWeaponIcon = false
		end

		local keypad_cracker = weapon("keypad_cracker")
		if keypad_cracker then
			keypad_cracker.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_keypad")
			keypad_cracker.BounceWeaponIcon = false
			keypad_cracker.KeyCrackTime = 18
			keypad_cracker.Slot = 3
			keypad_cracker.SlotPos = 100
		end

		local jerry_can = weapon("weapon_fuel")
		if jerry_can then
			jerry_can.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_jerry")
			jerry_can.BounceWeaponIcon = false
		end

		local cuffs = weapon("weapon_cuff_base")
		if cuffs then
			cuffs.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_cuffs")
		end

		local bible = weapon("weapon_bible")
		if bible then
			bible.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_bible")
		end

		local shield = weapon("heavy_shield")
		if shield then
			shield.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_hshield")
			shield.BounceWeaponIcon = false
		end

		local shield = weapon("riot_shield")
		if shield then
			shield.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_rshield")
			shield.BounceWeaponIcon = false
		end

		local shield = weapon("deployable_shield")
		if shield then
			shield.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_dshield")
			shield.BounceWeaponIcon = false
		end

		local fine = weapon("weapon_fine")
		if fine then
			fine.WepSelectIcon = surface.GetTextureID("mg_weaponicons/icon_fine")
			fine.BounceWeaponIcon = false
		end

		-- Glorified Banking-Übersetzungen
		local atm = entity("glorifiedbanking_atm")
		if atm then
			atm.PrintName = "ATM"
		end

		local card_reader = entity("glorifiedbanking_cardreader")
		if card_reader then
			card_reader.PrintName = "Kartenlesegerät"
		end
	end

	-- VCMod-Edits
	local wrench = weapon("vc_wrench")
	if wrench then
		wrench.PrintName = "Schraubenschlüssel"
		wrench.Instructions = "Repariert Autos mit Linksklick.\nRechtsklick zum Schnell-Reparieren als Admin."
		wrench.Slot = 3
		wrench.UseHands = false
	end
	local spikes = weapon("vc_spikestrip_wep")
	if spikes then
		spikes.PrintName = "Nagelsperre"
		spikes.Instructions = "Lege sie mit Rechtsklick auf den Boden um Autos die Reifen zu plätten."
		spikes.Slot = 3
		spikes.UseHands = false
	end
	local jerry = weapon("vc_jerrycan")
	if jerry then
		jerry.PrintName = "Benzinkanister"
		jerry.Instructions = "Fülle Autos mit Linksklick an der Tankluke auf."
		jerry.Slot = 3
		jerry.UseHands = false
	end

	-- Mikrowelle-Edit
	entity("microwave").t.PrintName = "Mikrowelle"
	entity("microwave").t.blastRadius = 100
	entity("microwave").t.blastDamage = 100

	-- Essens-Übersetzungen
	entity("spawned_food").t.PrintName = "Essen"
	entity("food").t.PrintName = "Chinesisches Essen"

	-- Design Reworks

	entity("spawned_weapon").t.RenderGroup = RENDERGROUP_BOTH
	entity("spawned_shipment").t.RenderGroup = RENDERGROUP_BOTH
	entity("spawned_food").t.RenderGroup = RENDERGROUP_BOTH
	entity("food").t.RenderGroup = RENDERGROUP_BOTH
	entity("admin_food").t.RenderGroup = RENDERGROUP_BOTH
	entity("microwave").t.RenderGroup = RENDERGROUP_BOTH

	if CLIENT and !mg_design_override then
		mg_design_override = true

		surface.CreateFont("mg_weaponfont", {font = "Prototype", size = 72, weight = 700, blursize = 0, antialias = true, shadow = false})
		surface.CreateFont("mg_weaponfont2", {font = "Prototype", size = 100, weight = 700, blursize = 0, antialias = true, shadow = false})

		if !draw.ShadowText then
			function draw.ShadowText(text, font, x, y, colortext, colorshadow, dist, xalign, yalign)
				draw.SimpleText(text, font, x + dist, y + dist, colorshadow, xalign, yalign)
				draw.SimpleText(text, font, x, y, colortext, xalign, yalign)
			end
		end

		local up, clr, local_ply, eye_ang, wid = Vector(0, 0, 15), Color(0, 200, 255, 255)

		entity("spawned_weapon").t.Draw = function(self)
			self:DrawModel()
		end

		entity("spawned_weapon").t.DrawTranslucent = function(self)
			local_ply = local_ply or LocalPlayer()
			if local_ply:EyePos():DistToSqr(self:GetPos()) > 40000 then return end
			eye_ang = local_ply:EyeAngles()
			eye_ang.p = 0
			eye_ang.y = eye_ang.y - 90
			eye_ang.r = 90
			self.CachedClass = self.CachedClass or weapons.Get(self:GetWeaponClass())
			self.CachedName = self.CachedClass and self.CachedClass.PrintName or "Nicht einsehbar"
			surface.SetFont("mg_weaponfont")
			wid = surface.GetTextSize(self.CachedName)
			cam.Start3D2D(self:GetPos() + up, eye_ang, 0.05)
				surface.SetDrawColor(clr)
				surface.DrawRect(-wid / 2 - 15, -200, wid + 30, 65)
				surface.SetDrawColor(0, 0, 0, 150)
				surface.DrawRect(-wid / 2 - 15, -135, wid + 30, 65)
				draw.ShadowText(self.CachedName, "mg_weaponfont", 0, -170, color_white, color_black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw.ShadowText(self:Getamount().."x", "mg_weaponfont", 0, -105, color_white, color_black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			cam.End3D2D()
		end

		entity("spawned_shipment").t.DrawTranslucent = entity("spawned_shipment").t.Draw

		entity("spawned_shipment").t.Draw = function(self)
		end

		entity("spawned_shipment").t.drawInfo = function(self)
			local pos = self:GetPos()
			local ang = self:GetAngles()
			local content = self:Getcontents() or ""
			local contents = CustomShipments[content]
			if !contents then return end
			contents = contents.name
			surface.SetFont("mg_weaponfont2")
			local text = DarkRP.getPhrase("contents")
			local TextWidth, TextHeight = surface.GetTextSize(text)
			local TextWidth2, TextHeight2 = surface.GetTextSize(contents)
			cam.Start3D2D(pos + ang:Up() * 25, ang, 0.05)
				draw.WordBox(2, -TextWidth * 0.5, 0, text, "mg_weaponfont2", Color(0, 0, 0, 100), color_white)
				draw.WordBox(2, -TextWidth2 * 0.5, TextHeight + 50, contents, "mg_weaponfont2", Color(140, 0, 0, 100), color_white)
			cam.End3D2D()
			ang:RotateAroundAxis(ang:Forward(), 90)
			text = DarkRP.getPhrase("amount")
			TextWidth = surface.GetTextSize(text)
			TextWidth2 = surface.GetTextSize(self:Getcount())
			cam.Start3D2D(pos + ang:Up() * 17, ang, 0.04)
				draw.WordBox(2, -TextWidth * 0.5, -500, text, "mg_weaponfont2", Color(0, 0, 0, 100), color_white)
				draw.WordBox(2, -TextWidth2 * 0.5, -500 + TextHeight + 20, self:Getcount(), "mg_weaponfont2", Color(0, 0, 0, 100), color_white)
			cam.End3D2D()
		end

		local use_font = system.IsWindows() and "Tahoma" or "Verdana"
		surface.CreateFont("mg_entfont", {font = use_font, size = 35, weight = 1000, blursize = 0, antialias = true, shadow = false})
		surface.CreateFont("mg_entfont2", {font = use_font, size = 25, weight = 600, blursize = 0, antialias = true, shadow = false})

		entity("spawned_food").t.Draw = function(self)
			self:DrawModel()
		end

		local vector_1 = Vector(0, 0, 1)
		local local_ply
		entity("spawned_food").t.DrawTranslucent = function(self)
			local_ply = local_ply or LocalPlayer()
			local dist = local_ply:EyePos():DistToSqr(self:GetPos())
			if dist > 40000 then return end
			local name = self:GetNW2String("Name")
			if name == "" then return end
			local ang = self:GetAngles()	
			local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2) * 2))
			ang:RotateAroundAxis(ang:Forward(), 90)
			ang:RotateAroundAxis(ang:Right(), -90)
			ang:RotateAroundAxis(ang:Up(), 0)
			cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
				draw.SimpleTextOutlined(self:GetNW2String("Name"), "mg_entfont", 0, -100, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
				draw.SimpleTextOutlined("+"..self:GetNW2Int("Energy").." Energie", "mg_entfont2", 0, -70, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
				draw.SimpleTextOutlined("Drücke "..string.upper(input.LookupBinding("+use") or "[BENUTZEN]").." zum Verzehren.", "mg_entfont2", 0, -40, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			cam.End3D2D()
		end

		entity("food").t.Draw = entity("spawned_food").t.Draw
		entity("food").t.DrawTranslucent = entity("spawned_food").t.DrawTranslucent

		entity("admin_food").t.Draw = entity("spawned_food").t.Draw
		entity("admin_food").t.DrawTranslucent = entity("spawned_food").t.DrawTranslucent

		entity("microwave").t.Draw = function(self)
			self:DrawModel()
		end
	
		local color = Color(255, 160, 160)
		entity("microwave").t.DrawTranslucent = function(self)
			local_ply = local_ply or LocalPlayer()
			dist = local_ply:EyePos():DistToSqr(self:GetPos())
			if dist > 40000 then return end
			local ang = self:GetAngles()	
			local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2)))
			ang:RotateAroundAxis(ang:Forward(), 90)
			ang:RotateAroundAxis(ang:Right(), -90)
			ang:RotateAroundAxis(ang:Up(), 0)
			cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
				draw.SimpleTextOutlined(self.PrintName, "mg_entfont", 0, -100, color, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
				draw.SimpleTextOutlined(DarkRP.getPhrase("priceTag", DarkRP.formatMoney(self:Getprice()), ""), "mg_entfont2", 0, -70, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
				draw.SimpleTextOutlined("Drücke "..string.upper(input.LookupBinding("+use") or "[BENUTZEN]").." zum Kaufen von Chinesisches Essen.", "mg_entfont2", 0, -40, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			cam.End3D2D()
		end

		local reg = debug.getregistry()
		local GetTable = reg.Entity.GetTable
		local GetOwner = reg.Entity.GetOwner

		weapon("weapon_base").TranslateActivity = function(self, act) -- Optimierung für normale Waffen Basis
			local tb = GetTable(self)

			if GetOwner(self):IsNPC() then
				if tb.ActivityTranslateAI[act] then
					return tb.ActivityTranslateAI[act]
				end
				return -1
			end

			if tb.ActivityTranslate[act] != nil then
				return tb.ActivityTranslate[act]
			end

			return -1
		end
	end
end
hook.Add("OnGamemodeLoaded", "DarkRP_ModifyEntities", ModifyEntities)
hook.Add("OnReloaded", "DarkRP_ModifyEntities", ModifyEntities)