local localplayer
local hudText
local textCol1, textCol2 = Color(0, 0, 0, 255), Color(128, 30, 30, 255)
local plyMeta = FindMetaTable("Player")
local activeHitmen = {}
local minHitDistanceSqr = GM.Config.minHitDistance * GM.Config.minHitDistance

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("Hitman_Info", {font = use_font, size = 75, weight = 1000, antialias = true})
surface.CreateFont("Hitman_Info2", {font = use_font, size = 50, weight = 1000, antialias = true})

local function drawHitInfo()
	localplayer = localplayer or LocalPlayer()
	for ply in pairs(activeHitmen) do
		if !ply:Alive() or ply:GetNoDraw() or ply:IsDormant() or localplayer:EyePos():DistToSqr(ply:GetPos()) > 1000000 then continue end
		if ply == localplayer then
			local target = ply:getHitTarget()
			if IsValid(target) and target:Alive() and !target:GetNoDraw() and !target:IsDormant() then
				local pos, ang = target:GetShootPos(), target:EyeAngles()
				ang.p = 0
				ang:RotateAroundAxis(ang:Up(), 90)
				ang:RotateAroundAxis(ang:Forward(), 90)
				cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
					local targetText = "ZIEL"
					draw.DrawNonParsedText(targetText, "Hitman_Info", 3, -300, textCol1, 1)
					draw.DrawNonParsedText(targetText, "Hitman_Info", 0, -301, textCol2, 1)
				cam.End3D2D()
			end
		else
			local target = ply:getHitTarget()
			if ply == target then continue end
			local pos, ang = ply:GetShootPos(), ply:EyeAngles()
			ang.p = 0
			ang:RotateAroundAxis(ang:Up(), 90)
			ang:RotateAroundAxis(ang:Forward(), 90)
			cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
				local hitmanText = GAMEMODE.Config.hitmanText
				draw.DrawNonParsedText(hitmanText, "Hitman_Info2", 3, -300, textCol1, 1)
				draw.DrawNonParsedText(hitmanText, "Hitman_Info2", 0, -301, textCol2, 1)
			cam.End3D2D()
		end
	end
end

function plyMeta:drawHitInfo()
	activeHitmen[self] = true
	hook.Add("PostDrawTranslucentRenderables", "Hitmenu_DrawHitmanInfo", drawHitInfo)
end

function plyMeta:stopHitInfo()
	activeHitmen[self] = nil
	if table.IsEmpty(activeHitmen) then
		hook.Remove("PostDrawTranslucentRenderables", "Hitmenu_DrawHitmanInfo")
	end
end

function DarkRP.hooks:onHitAccepted(hitman)
	if !IsValid(hitman) then return end
	hitman:drawHitInfo()
end

function DarkRP.hooks:onHitCompleted(hitman)
	if !IsValid(hitman) then return end
	hitman:stopHitInfo()
end

function DarkRP.hooks:onHitFailed(hitman)
	if !IsValid(hitman) then return end
	hitman:stopHitInfo()
end

hook.Add("EntityRemoved", "Hitmenu_RemoveHitman", function(hitman)
	if hitman:IsPlayer() then
		hitman:stopHitInfo()
	end
end)

surface.CreateFont("Hitman_HUDText", {font = use_font, size = 25, weight = 600, antialias = true})

local function DrawHitText()
	localplayer = localplayer or LocalPlayer()
	hudText = hudText or GAMEMODE.Config.hudText
	local x, y
	local ply = localplayer:GetEyeTrace().Entity
	if IsValid(ply) and ply:IsPlayer() and ply:isHitman() and !ply:isArrested() and !ply:hasHit() and localplayer:GetPos():DistToSqr(ply:GetPos()) < minHitDistanceSqr then
		x, y = ScrW() / 2, ScrH() / 2 + 30
		draw.DrawNonParsedText(hudText, "Roboto20", x + 1, y + 1, textCol1, 1)
		draw.DrawNonParsedText(hudText, "Roboto20", x, y, textCol2, 1)
	end
	if localplayer:isHitman() and localplayer:hasHit() and IsValid(localplayer:getHitTarget()) then
		local target = localplayer:getHitTarget()
		local _, y = chat.GetChatBoxPos()
		x = 15
		y = y - 150
		local text = DarkRP.getPhrase("current_hit", target:Name())
		draw.DrawNonParsedText(text, "Hitman_HUDText", x + 1, y + 1, color_black, 0)
		draw.DrawNonParsedText(text, "Hitman_HUDText", x, y, textCol2, 0)
		text = DarkRP.getPhrase("current_bounty", DarkRP.formatMoney(localplayer:getHitPrice()))
		draw.DrawNonParsedText(text, "Hitman_HUDText", x + 1, y + 26, color_black, 0)
		draw.DrawNonParsedText(text, "Hitman_HUDText", x, y + 25, textCol2, 0)
		local dist = localplayer:EyePos():Distance(target:EyePos()) * 0.0254
		if dist <= 100 then
			local distText = string.Comma(math.Round(dist)).."m"
			text = "Distanz: "..distText
			draw.DrawNonParsedText(text, "Hitman_HUDText", x + 1, y + 51, color_black, 0)
			draw.DrawNonParsedText(text, "Hitman_HUDText", x, y + 50, textCol2, 0)
		end
	end
end
hook.Add("HUDPaint", "Hitmenu_DrawHitText", DrawHitText)

local lastKeyPress = 0
hook.Add("KeyPress", "Hitmenu_OpenHitMenu", function(ply, key)
	if key != IN_USE or lastKeyPress > CurTime() - 0.2 then return end
	lastKeyPress = CurTime()
	localplayer = localplayer or LocalPlayer()
	local hitman = localplayer:GetEyeTrace().Entity
	if !IsValid(hitman) or !hitman:IsPlayer() or !hitman:isHitman() or hitman:isArrested() or localplayer:GetPos():DistToSqr(hitman:GetPos()) > minHitDistanceSqr then return end
	local canRequest, message = hook.Call("canRequestHit", DarkRP.hooks, hitman, ply, nil, hitman:getHitPrice())
	if !canRequest then
		GAMEMODE:AddNotify(DarkRP.getPhrase("cannot_request_hit", (message or "")), 1, 4)
		surface.PlaySound("buttons/lightswitch2.wav")
		return
	end
	DarkRP.openHitMenu(hitman)
end)

hook.Add("InitPostEntity", "Hitmenu_AddHitmanStatus", function()
	timer.Simple(10, function()
		for _, v in ipairs(player.GetAll()) do
			if v:isHitman() and v:hasHit() then
				v:drawHitInfo()
			end
		end
	end)
end)

net.Receive("onHitAccepted", function(len)
	hook.Call("onHitAccepted", DarkRP.hooks, net.ReadEntity(), net.ReadEntity(), net.ReadEntity())
end)

net.Receive("onHitCompleted", function(len)
	hook.Call("onHitCompleted", DarkRP.hooks, net.ReadEntity(), net.ReadEntity())
end)

net.Receive("onHitFailed", function(len)
	hook.Call("onHitFailed", DarkRP.hooks, net.ReadEntity(), net.ReadEntity(), net.ReadString())
end)