local isnil = fn.Curry(fn.Eq, 2)(nil)
local validFood = {"name", model = isstring, "energy", "price", onEaten = fn.FOr{isnil, isfunction}}

FoodItems = {}
function DarkRP.createFood(name, mdl, energy, price)
	local foodItem = istable(mdl) and mdl or {model = mdl, energy = energy, price = price}
	foodItem.name = name
	for k, v in pairs(validFood) do
		local isFunction = isfunction(v)
		if (isFunction and !v(foodItem[k])) or (!isFunction and foodItem[v] == nil) then
			ErrorNoHalt("Corrupt food \""..(name or "").."\": element "..(isFunction and k or v).." is corrupt.\n")
		end
	end
	table.insert(FoodItems, foodItem)
end

DarkRP.getFoodItems = fp{fn.Id, FoodItems}

function DarkRP.removeFoodItem(i)
	local food = FoodItems[i]
	FoodItems[i] = nil
	hook.Run("onFoodItemRemoved", i, food)
end

local plyMeta = FindMetaTable("Player")
plyMeta.isCook = fn.Compose{fn.Curry(fn.GetValue, 2)("cook"), plyMeta.getJobTable}

DarkRP.registerDarkRPVar("Energy", net.WriteFloat, net.ReadFloat)

-- Ja, wir fügen hier unser Essen ein!

DarkRP.createFood("Spiegelei", {
	model = Model("models/eggs01/eggs01.mdl"),
	energy = 20,
	price = 200,
	sound = Sound("cookingmod/eating.wav")
})

DarkRP.createFood("Schinkenstreifen", {
	model = Model("models/bacon01/bacon01.mdl"),
	energy = 25,
	price = 300,
	sound = Sound("cookingmod/crunchy.wav")
})

DarkRP.createFood("Sushi", {
	model = Model("models/sushipack/sushi01.mdl"),
	energy = 40,
	price = 450,
	sound = Sound("cookingmod/eating.wav")
})

DarkRP.createFood("Cheeseburger", {
	model = Model("models/food/burger.mdl"),
	energy = 50,
	price = 600,
	sound = Sound("cookingmod/crunchy.wav")
})

DarkRP.createFood("Hot Dog", {
	model = Model("models/food/hotdog.mdl"),
	energy = 60,
	price = 750,
	sound = Sound("cookingmod/crunchy.wav")
})

DarkRP.createFood("Chinesisches Essen", { -- Für Mikrowelle benötigt.
	model = Model("models/props_junk/garbage_takeoutcarton001a.mdl"),
	energy = 80,
	price = 1000,
	microwave = true,
	sound = Sound("cookingmod/eating.wav")
})

DarkRP.createFood("Pizza", {
	model = Model("models/cheesepizza01/cheesepizza01.mdl"),
	energy = 100,
	price = 1500,
	sound = Sound("cookingmod/crunchy.wav")
})

DarkRP.createFood("Mineralwasser", {
	model = Model("models/props_junk/popcan01a.mdl"),
	energy = 20,
	price = 250,
	sound = Sound("cookingmod/drinking.wav")
})

DarkRP.createFood("Soda", {
	model = Model("models/props_junk/garbage_plasticbottle003a.mdl"),
	energy = 25,
	price = 300,
	sound = Sound("cookingmod/drinking.wav")
})

DarkRP.createFood("Milchshake", {
	model = Model("models/chocolateshake01/chocolateshake01.mdl"),
	energy = 40,
	price = 500,
	sound = Sound("cookingmod/drinking.wav")
})

DarkRP.createFood("Bier", {
	model = Model("models/props_junk/garbage_glassbottle003a.mdl"),
	energy = 25,
	price = 500,
	sound = Sound("cookingmod/drinking.wav")
})

print("Modern Roleplay - Essensgegenstände initialisiert!")