local use_default = system.IsWindows() and "Tahoma" or "Verdana"

surface.CreateFont("MG_LevelSys:Level", {font = use_default, size = 16, weight = 1000})
surface.CreateFont("MG_LevelSys:XP", {font = use_default, size = 12, weight = 1000})

local cl_progressbar = CreateClientConVar("cl_progressbar", 1, true, false)

local utime_enable = GetConVar("utime_enable")

local local_ply
local drawXP, OldXP = 0, 0
local box_color = Color(54, 54, 54, 150)
local function DrawLevelBar()
	if !cl_progressbar:GetBool() then return end

	local_ply = local_ply or LocalPlayer()

	local W, H = 260, 50
	local Border = 5
	local WPos = ScrW() - W - Border
	local HPos = (utime_enable and utime_enable:GetBool() and 65 or 0) + Border

	surface.SetDrawColor(box_color)
	surface.DrawRect(WPos, HPos, W, H)
	surface.DrawRect(WPos - 2, HPos - 2, W + 4, H + 4)

	local pos = 4

	local level = local_ply:getLevel() 
	local xp = local_ply:getXP()
	local maxxp = local_ply:getMaxXP()

	draw.SimpleText("Level: "..string.Comma(level), "MG_LevelSys:Level", WPos + W / 2, HPos + pos, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)

	local bar = 5

	local maxlevel = level >= MG_LevelSys_Config.MaxLevel and true or false
	local percent = maxlevel and 1 or (xp / maxxp)
	local percent2 = math.Clamp(math.floor(percent * 100), 0, 100)
	local percent2 = math.Clamp(percent2, 0, 100)

	drawXP = Lerp(FrameTime() * 3, OldXP, percent)
	OldXP = drawXP

	surface.SetDrawColor(MG_LevelSys_Config.LevelBarColor)
	surface.DrawOutlinedRect(WPos + 10 - 2, HPos + H - 15 - 2, W - 20 + 4, bar + 4)

	surface.DrawRect(WPos + 10, HPos + H - 15, (W - 20) * drawXP, bar)

	pos = pos + 15

	draw.SimpleText(maxlevel and "MAX XP" or "XP: "..string.Comma(math.floor(xp)).." / "..string.Comma(maxxp).." ("..percent2.."%)", "MG_LevelSys:XP", WPos + W / 2, HPos + pos, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
end
hook.Add("HUDPaint", "MG_LevelSys:HUDPaint", DrawLevelBar)