local use_font = "Bariol Regular"
surface.CreateFont("MG_LevelSys_MenuClose", {font = use_font, size = 22, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuTop", {font = use_font, size = 22, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuTopSmall", {font = use_font, size = 16, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuSkillR", {font = use_font, size = 48, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuSkillL", {font = use_font, size = 30, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuLevel", {font = use_font, size = 24, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuDescription", {font = use_font, size = 20, weight = 100, blursize = 0, scanlines = 0, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuFont", {font = use_font, size = 16, weight = 1000, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuPurchase", {font = use_font, size = 20, weight = 1000, blursize = 0, scanlines = 0, antialias = true, shadow = false})
surface.CreateFont("MG_LevelSys_MenuMax", {font = use_font, size = 32, weight = 1000, blursize = 0, scanlines = 0, antialias = true, shadow = false})

MG_LevelSys = MG_LevelSys or {}
MG_LevelSys_Config = MG_LevelSys_Config or {}

MG_LevelSys.SkillCategoryCount = {}

timer.Simple(0, function()
	for cat, contents in pairs(MG_LevelSys_Config.Skills) do
		for _, v in ipairs(contents) do
			MG_LevelSys.SkillCategoryCount[cat] = MG_LevelSys.SkillCategoryCount[cat] and MG_LevelSys.SkillCategoryCount[cat] + (v.max or MG_LevelSys_Config.MaxTiers) or (v.max or MG_LevelSys_Config.MaxTiers)
		end
		contents.categoryCount = MG_LevelSys.SkillCategoryCount[cat]
	end
end)

local text_color = Color(180, 180, 180)
local button_color = Color(30, 30, 30)
local panel_color = Color(30, 30, 30)

local color_allow = Color(50, 200, 50)
local color_deny = Color(200, 50, 50)

local color_deactivated = Color(255, 150, 150)

local function ButtonDraw(slf, w, h, col)
	local bgcol = button_color
	if slf:IsHovered() then
		col = Color(col.r + 25, col.g + 25, col.b + 25)
		bgcol = Color(bgcol.r + 25, bgcol.g + 25, bgcol.b + 25)
	end
	draw.RoundedBox(0, 0, 0, w, h, col)
	draw.RoundedBox(0, 2, 2, w - 4, h - 4, bgcol)
end

local UpgradeMenu
local TradeFunc
local ResetFunc
local function OpenUpgradeMenu()
	if IsValid(UpgradeMenu) then return end
	UpgradeMenu = vgui.Create("DFrame")
	UpgradeMenu:SetSize(math.Clamp(ScrW() * 0.75, 600, 1200), math.max(ScrH() * 0.8, 400))
	UpgradeMenu:Center()
	UpgradeMenu:SetTitle("")
	UpgradeMenu:SetDraggable(false)
	UpgradeMenu:ShowCloseButton(false)
	UpgradeMenu:MakePopup()
	UpgradeMenu:ParentToHUD()
	UpgradeMenu.Paint = function(slf, w, h)
		draw.RoundedBox(2, 0, 0, w, h, Color(35, 35, 35))
		draw.RoundedBox(2, 0, 0, w, 60, Color(50, 50, 50))
	end
	UpgradeMenu.OnScreenSizeChanged = function(slf)
		slf:Remove()
	end
	local ply = LocalPlayer()
	local LevelLabel = vgui.Create("DLabel", UpgradeMenu)
	LevelLabel:SetPos(5, 5)
	LevelLabel:SetText("Level: "..ply:getLevel()..",  ")
	LevelLabel:SetTextColor(color_white)
	LevelLabel:SetFont("MG_LevelSys_MenuTop")
	LevelLabel:SizeToContents()
	LevelLabel.Think = function()
		LevelLabel:SetText("Level: "..ply:getLevel()..",  ")
		LevelLabel:SizeToContents()
	end
	local XPLabel = vgui.Create("DLabel", UpgradeMenu)
	XPLabel:SetPos(5, 5)
	XPLabel:SetText("XP: "..string.Comma(math.floor(ply:getXP())).." / "..string.Comma(ply:getMaxXP())..",  ")
	XPLabel:SetTextColor(color_white)
	XPLabel:SetFont("MG_LevelSys_MenuTop")
	XPLabel:SizeToContents()
	XPLabel:MoveRightOf(LevelLabel)
	XPLabel.Think = function()
		if ply:getLevel() >= MG_LevelSys_Config.MaxLevel then
			XPLabel:SetText("XP: MAX XP".."\n\n")
			XPLabel:SizeToContents()
		else
			XPLabel:SetText("XP: "..string.Comma(math.floor(ply:getXP())).." / "..string.Comma(ply:getMaxXP())..",  ")
			XPLabel:SizeToContents()
		end
		XPLabel:MoveRightOf(LevelLabel)
	end
	local PointsLabel = vgui.Create("DLabel", UpgradeMenu)
	PointsLabel:SetPos(5, 5)
	PointsLabel:SetText("Punkte übrig: "..ply:getPoints().." ")
	PointsLabel:SetTextColor(color_white)
	PointsLabel:SetFont("MG_LevelSys_MenuTop")
	PointsLabel:SizeToContents()
	PointsLabel:MoveRightOf(XPLabel)
	PointsLabel.Think = function()
		PointsLabel:SetText("Punkte übrig: "..ply:getPoints().." ")
		PointsLabel:SizeToContents()
		PointsLabel:MoveRightOf(XPLabel)
	end
	local TradeButton
	if MG_LevelSys_Config.TradeXP then
		TradeButton = vgui.Create("DButton", UpgradeMenu)
		TradeButton:SetPos(5, 30)
		TradeButton:SetSize(150, 25)
		TradeButton:SetText("XP tauschen")
		TradeButton:SetTextColor(color_white)
		TradeButton:SetFont("MG_LevelSys_MenuTop")
		TradeButton.DoClick = function()
			if ply:getLevel() < MG_LevelSys_Config.TradeMinLevel then return end
			surface.PlaySound("ui/buttonclick.wav")
			if IsValid(TradeFunc) then
				TradeFunc:Remove()
			end
			local BuyAmount = 0
			TradeFunc = vgui.Create("DFrame")
			TradeFunc:SetTitle("")
			TradeFunc:SetSize(500, 140)
			TradeFunc:ShowCloseButton(false)
			TradeFunc:SetDraggable(false)
			TradeFunc:MakePopup()
			local cost = ply:getTradeMult()
			local reset = ply:getResetRefund()
			TradeFunc.Paint = function(slf, w, h)
				if !IsValid(UpgradeMenu) or !UpgradeMenu:IsVisible() then
					slf:Remove()
					return
				end
				draw.RoundedBox(0, 0, 0, w, h, Color(45, 45, 45, 255))
				draw.SimpleText("Wie viel $ möchtest du gegen XP tauschen?", "MG_LevelSys_MenuFont", w / 2, 30, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
				draw.SimpleText("Kurs: $"..string.Comma(math.Round(cost, 1)).." pro XP", "MG_LevelSys_MenuFont", w / 2, 45, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
				if BuyAmount > 0 then
					draw.SimpleText("Derzeitige Kosten: $"..string.Comma(math.ceil(BuyAmount * cost)), "MG_LevelSys_MenuFont", w / 2, 60, ply:canAfford(BuyAmount) and color_allow or color_deny, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
				end
			end
			TradeFunc:Center()
			TradeFunc:ParentToHUD()
			local Close = vgui.Create("DButton", TradeFunc)
			Close:SetSize(50, 20)
			Close:SetPos(TradeFunc:GetWide() - 52, 2)
			Close:SetText("X")
			Close:SetFont("MG_LevelSys_MenuClose")
			Close:SetTextColor(color_white)
			Close.Paint = function(slf, w, h)
				ButtonDraw(slf, w, h, color_deny)
			end
			Close.DoClick = function()
				surface.PlaySound("ui/buttonclick.wav")
				TradeFunc:Remove()
			end
			local TradeField = vgui.Create("DTextEntry", TradeFunc)
			TradeField:SetPos(5, 80)
			TradeField:SetSize(490, 25)
			TradeField:SetFont("MG_LevelSys_MenuClose")
			TradeField:SetNumeric(true)
			TradeField:SetPlaceholderText("Zahl angeben")
			TradeField.Paint = function(s, w, h)
				draw.RoundedBox(0, 0, 0, w, h, Color(35, 35, 35, 230))
				if s.GetPlaceholderText and s.GetPlaceholderColor and s:GetPlaceholderText() and s:GetPlaceholderText():Trim() != "" and s:GetPlaceholderColor() and (!s:GetText() or s:GetText() == "" ) then
					local oldText = s:GetText()
					local str = s:GetPlaceholderText()
					s:SetText(str)
					s:DrawTextEntryText(s:GetPlaceholderColor(), color_black, color_white)
					s:SetText(oldText)
					return
				end
				s:DrawTextEntryText(color_white, color_black, color_white)
			end
			TradeField.OnChange = function(s)
				BuyAmount = tonumber(s:GetValue()) or 0
			end
			local TradeButton = vgui.Create("DButton", TradeFunc)
			TradeButton:SetPos(5, 110)
			TradeButton:SetText("Tauschen")
			TradeButton:SetSize(490, 25)
			TradeButton.DoClick = function()
				if BuyAmount <= 0 then return end
				net.Start("MG_LevelSys:Trade")
					net.WriteUInt(BuyAmount, 32)
				net.SendToServer()
				TradeFunc:Remove()
			end
			TradeButton.Paint = function(slf, w, h)
				ButtonDraw(slf, w, h, color_allow)
			end
			TradeButton:SetTextColor(color_white)
			TradeButton:SetFont("MG_LevelSys_MenuClose")
		end
		TradeButton.Think = function(slf)
			if ply:getLevel() >= MG_LevelSys_Config.TradeMinLevel then
				slf:SetText("XP tauschen")
				slf.Color = color_allow
			else
				slf:SetText("Ab Level "..MG_LevelSys_Config.TradeMinLevel)
				slf.Color = color_deny
			end
		end
		TradeButton.Paint = function(slf, w, h)
			local col = slf.Color
			if !col then return end
			ButtonDraw(slf, w, h, col)
		end
	end
	local ResetButton = vgui.Create("DButton", UpgradeMenu)
	ResetButton:SetPos(5, 30)
	ResetButton:SetSize(100, 25)
	ResetButton:SetText("Reset")
	ResetButton:SetTextColor(color_white)
	ResetButton:SetFont("MG_LevelSys_MenuTop")
	ResetButton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		if IsValid(ResetFunc) then
			ResetFunc:Remove()
		end
		ResetFunc = vgui.Create("DFrame")
		ResetFunc:SetTitle("")
		ResetFunc:SetSize(500, 140)
		ResetFunc:ShowCloseButton(false)
		ResetFunc:SetDraggable(false)
		ResetFunc:MakePopup()
		local reset = ply:getResetRefund()
		ResetFunc.Paint = function(slf, w, h)
			if !IsValid(UpgradeMenu) or !UpgradeMenu:IsVisible() then
				slf:Remove()
				return
			end
			draw.RoundedBox(0, 0, 0, w, h, Color(45, 45, 45, 255))
			draw.SimpleText("Möchtest du deine verteilten Skillpunkte wirklich zurücksetzen?", "MG_LevelSys_MenuFont", w / 2, 35, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
			draw.SimpleText("Dir wird "..math.Round(MG_LevelSys_Config.RefundMult * 100, 2).."% deines Geldes zurück erstattet. ($"..string.Comma(reset)..")", "MG_LevelSys_MenuFont", w / 2, 50, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_TOP)
		end
		ResetFunc:Center()
		ResetFunc:ParentToHUD()
		local Close = vgui.Create("DButton", ResetFunc)
		Close:SetSize(50, 20)
		Close:SetPos(ResetFunc:GetWide() - 52, 2)
		Close:SetText("X")
		Close:SetFont("MG_LevelSys_MenuClose")
		Close:SetTextColor(color_white)
		Close.Paint = function(slf, w, h)
			ButtonDraw(slf, w, h, color_deny)
		end
		Close.DoClick = function()
			surface.PlaySound("ui/buttonclick.wav")
			ResetFunc:Remove()
		end
		local ResetAgree = vgui.Create("DButton", ResetFunc)
		ResetAgree:SetPos(5, 80)
		ResetAgree:SetText("Ja")
		ResetAgree:SetSize(490, 25)
		ResetAgree.DoClick = function()
			net.Start("MG_LevelSys:Reset")
			net.SendToServer()
			ResetFunc:Remove()
		end
		ResetAgree.Paint = function(slf, w, h)
			ButtonDraw(slf, w, h, color_allow)
		end
		ResetAgree:SetTextColor(color_white)
		ResetAgree:SetFont("MG_LevelSys_MenuClose")
		local ResetDeny = vgui.Create("DButton", ResetFunc)
		ResetDeny:SetPos(5, 110)
		ResetDeny:SetText("Nein")
		ResetDeny:SetSize(490, 25)
		ResetDeny.DoClick = function()
			surface.PlaySound("ui/buttonclick.wav")
			ResetFunc:Remove()
		end
		ResetDeny.Paint = function(slf, w, h)
			ButtonDraw(slf, w, h, color_deny)
		end
		ResetDeny:SetTextColor(color_white)
		ResetDeny:SetFont("MG_LevelSys_MenuClose")
	end
	if TradeButton then
		ResetButton:MoveRightOf(TradeButton, 10)
	end
	ResetButton.Paint = function(slf, w, h)
		ButtonDraw(slf, w, h, color_deny)
	end
	ResetButton.Think = function()
		if TradeButton then
			ResetButton:MoveRightOf(TradeButton, 10)
		end
	end
	local ActivateButton = vgui.Create("DButton", UpgradeMenu)
	ActivateButton:SetPos(5, 30)
	ActivateButton:SetSize(150, 25)
	ActivateButton:SetText("Alle Skills aktivieren")
	ActivateButton:SetTextColor(color_white)
	ActivateButton:SetFont("MG_LevelSys_MenuTopSmall")
	ActivateButton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		net.Start("MG_LevelSys:Configure")
			net.WriteBool(true)
			net.WriteBool(true)
		net.SendToServer()
	end
	ActivateButton:MoveRightOf(ResetButton, 20)
	ActivateButton.Paint = function(slf, w, h)
		ButtonDraw(slf, w, h, color_allow)
	end
	ActivateButton.Think = function()
		ActivateButton:MoveRightOf(ResetButton, 20)
	end
	local DeactivateButton = vgui.Create("DButton", UpgradeMenu)
	DeactivateButton:SetPos(5, 30)
	DeactivateButton:SetSize(160, 25)
	DeactivateButton:SetText("Alle Skills deaktivieren")
	DeactivateButton:SetTextColor(color_white)
	DeactivateButton:SetFont("MG_LevelSys_MenuTopSmall")
	DeactivateButton.DoClick = function()
		surface.PlaySound("ui/buttonclick.wav")
		net.Start("MG_LevelSys:Configure")
			net.WriteBool(true)
			net.WriteBool(false)
		net.SendToServer()
	end
	DeactivateButton:MoveRightOf(ActivateButton, 10)
	DeactivateButton.Paint = function(slf, w, h)
		ButtonDraw(slf, w, h, color_deny)
	end
	DeactivateButton.Think = function()
		DeactivateButton:MoveRightOf(ActivateButton, 10)
	end
	local CloseButton = vgui.Create("DButton", UpgradeMenu)
	CloseButton:SetSize(60, 25)
	CloseButton:SetPos(UpgradeMenu:GetWide() - CloseButton:GetWide() - 4, 4)
	CloseButton:SetText("X")
	CloseButton:SetTextColor(color_white)
	CloseButton:SetFont("MG_LevelSys_MenuClose")
	CloseButton.DoClick = function()
		UpgradeMenu:Close()
		surface.PlaySound("ui/buttonclick.wav")
	end
	CloseButton.Paint = function(slf, w, h)
		ButtonDraw(slf, w, h, color_deny)
	end
	local ScrollPanel = vgui.Create("DScrollPanel", UpgradeMenu)
	ScrollPanel:SetPos(5, 65)
	ScrollPanel:SetSize(UpgradeMenu:GetWide() * 0.4 - 10, UpgradeMenu:GetTall() - 70)
	ScrollPanel:DockMargin(0, 10, 0, 0)
	ScrollPanel:GetVBar().btnUp.Paint = function()
	end
	ScrollPanel:GetVBar().btnDown.Paint = function()
	end
	ScrollPanel:GetVBar().btnGrip.Paint = function(slf, w, h)
		draw.RoundedBox(2, 0, 0, w, h, Color(60, 60, 60))
	end
	ScrollPanel:GetVBar().Paint = function(slf, w, h)
		draw.RoundedBox(2, 0, 0, w, h, Color(80, 80, 80))
	end
	ScrollPanel.Paint = function(slf, w, h)
		draw.RoundedBox(2, 0, 0, w, h, Color(40, 40, 40))
	end
	local SkillLayout = vgui.Create("DIconLayout", ScrollPanel)
	SkillLayout:SetPos(0, 0)
	SkillLayout:SetSize(ScrollPanel:GetWide(), ScrollPanel:GetTall())
	SkillLayout:SetSpaceX(2)
	SkillLayout:SetSpaceY(2)
	function UpgradeMenu:AddSkills()
		SkillLayout:Clear()
		for cat, contents in SortedPairsByMemberValue(MG_LevelSys_Config.Skills, "categoryCount", true) do
			local CatPanel = SkillLayout:Add("DPanel")
			CatPanel:SetSize(ScrollPanel:GetWide(), 50)
			CatPanel.Paint = function(slf, w, h)
				draw.RoundedBox(2, 0, 0, w, h, panel_color)
			end
			local CatName = vgui.Create("DLabel", CatPanel)
			CatName:SetPos(4, 0)
			CatName:SetFont("MG_LevelSys_MenuSkillL")
			CatName:SetTextColor(color_white)
			CatName:SetText(cat)
			CatName:SizeToContents()
			local CatSkills = vgui.Create("DLabel", CatPanel)
			CatSkills:SetPos(4, 30)
			CatSkills:SetFont("MG_LevelSys_MenuFont")
			CatSkills:SetTextColor(color_white)
			CatSkills:SetText("Skills: "..#contents)
			CatSkills:SizeToContents()
			surface.SetFont("MG_LevelSys_MenuFont")
			local count = 0
			local full_count = MG_LevelSys.SkillCategoryCount[cat] or 0
			for _, v in ipairs(contents) do
				count = count + (tonumber(ply:getSkillTier(v.id)) or 0)
			end
			local progress_txt = "Fortschritt: "..count.."/"..full_count
			x, y = surface.GetTextSize(progress_txt)
			local CatProgress = vgui.Create("DLabel", CatPanel)
			CatProgress:SetFont("MG_LevelSys_MenuFont")
			CatProgress:SetTextColor(color_white)
			CatProgress:SetText(progress_txt)
			CatProgress:SizeToContents()
			CatProgress:SetPos(CatPanel:GetWide() - x - (ScrollPanel:GetVBar().Enabled and 20 or 10), 30)
			local nextUpdate = SysTime() + 1
			CatProgress.Paint = function(slf, w, h)
				if nextUpdate <= SysTime() then
					nextUpdate = SysTime() + 1
					surface.SetFont("MG_LevelSys_MenuFont")
					count = 0
					for _, v in ipairs(contents) do
						count = count + (tonumber(ply:getSkillTier(v.id)) or 0)
					end
					local progress_txt = "Fortschritt: "..count.."/"..full_count
					x, y = surface.GetTextSize(progress_txt)
					CatProgress:SetText(progress_txt)
					CatProgress:SizeToContents()
					CatProgress:SetPos(CatPanel:GetWide() - x - (ScrollPanel:GetVBar().Enabled and 20 or 10), 30)
				end
			end
			local CatButton = vgui.Create("DButton", CatPanel)
			CatButton:SetSize(ScrollPanel:GetWide(), 50)
			CatButton:SetPos(0, 0)
			CatButton:SetText("")
			CatButton.Paint = function()
			end
			CatButton.DoClick = function()
				SkillLayout:Clear()
				local BackPanel = SkillLayout:Add("DPanel")
				BackPanel:SetSize(ScrollPanel:GetWide(), 50)
				BackPanel.Paint = function(slf, w, h)
					draw.RoundedBox(2, 0, 0, w, h, panel_color)
				end
				local BackName = vgui.Create("DLabel", BackPanel)
				BackName:SetPos(4, 0)
				BackName:SetFont("MG_LevelSys_MenuSkillL")
				BackName:SetTextColor(color_white)
				BackName:SetText("Kategorie: "..cat)
				BackName:SizeToContents()
				local BackCat = vgui.Create("DLabel", BackPanel)
				BackCat:SetPos(4, 30)
				BackCat:SetFont("MG_LevelSys_MenuFont")
				BackCat:SetTextColor(color_white)
				BackCat:SetText("Hier klicken, um zurück zur Übersicht zu gelangen.")
				BackCat:SizeToContents()
				local BackButton = vgui.Create("DButton", BackPanel)
				BackButton:SetSize(ScrollPanel:GetWide(), 50)
				BackButton:SetPos(0, 0)
				BackButton:SetText("")
				BackButton.Paint = function()
				end
				BackButton.DoClick = function()
					UpgradeMenu:AddSkills()
					surface.PlaySound("ui/buttonclick.wav")
				end
				for _, v in ipairs(contents) do
					local skill_name = v.name
					local SkillPanel = SkillLayout:Add("DPanel")
					SkillPanel:SetSize(ScrollPanel:GetWide(), 50)
					SkillPanel.Paint = function(slf, w, h)
						draw.RoundedBox(2, 0, 0, w, h, panel_color)
					end
					local skill_level = v.level
					local SkillName = vgui.Create("DLabel", SkillPanel)
					SkillName:SetPos(4, 0)
					SkillName:SetFont("MG_LevelSys_MenuSkillL")
					SkillName:SetTextColor(color_white)
					SkillName:SetText(skill_name)
					SkillName:SizeToContents()
					local SkillLevel = vgui.Create("DLabel", SkillPanel)
					SkillLevel:SetPos(4, 30)
					SkillLevel:SetFont("MG_LevelSys_MenuFont")
					SkillLevel:SetTextColor(color_white)
					SkillLevel:SetText("Level "..skill_level)
					SkillLevel:SizeToContents()
					local id = v.id
					surface.SetFont("MG_LevelSys_MenuFont")
					local max_tier = (v.max or MG_LevelSys_Config.MaxTiers)
					local tier_txt = "Tier "..ply:getSkillTier(id).."/"..max_tier
					local x, y = surface.GetTextSize(tier_txt)
					local SkillTier = vgui.Create("DLabel", SkillPanel)
					SkillTier:SetPos(SkillPanel:GetWide() - x - (ScrollPanel:GetVBar().Enabled and 20 or 10), 30)
					SkillTier:SetFont("MG_LevelSys_MenuFont")
					SkillTier:SetTextColor(color_white)
					SkillTier:SetText(tier_txt)
					SkillTier:SizeToContents()
					SkillTier.Think = function(slf)
						surface.SetFont("MG_LevelSys_MenuFont")
						local tier_txt = "Tier "..ply:getSkillTier(id).."/"..max_tier
						x, y = surface.GetTextSize(tier_txt)
						slf:SetText(tier_txt)
						slf:SetPos(SkillPanel:GetWide() - x - (ScrollPanel:GetVBar().Enabled and 20 or 10), 30)
						slf:SizeToContents()
					end
					SkillPanel.Think = function()
						if !ply:hasLevel(skill_level) then
							SkillName:SetTextColor(text_color)
							SkillLevel:SetTextColor(text_color)
							SkillTier:SetTextColor(text_color)
						elseif ply:hasSkill(id) and !ply:hasSkillEquipped(id) then
							SkillName:SetTextColor(color_deactivated)
							SkillLevel:SetTextColor(color_deactivated)
							SkillTier:SetTextColor(color_deactivated)
						else
							SkillName:SetTextColor(color_white)
							SkillLevel:SetTextColor(color_white)
							SkillTier:SetTextColor(color_white)
						end
					end
					local SkillButton = vgui.Create("DButton", SkillPanel)
					SkillButton:SetSize(ScrollPanel:GetWide(), 50)
					SkillButton:SetPos(0, 0)
					SkillButton:SetText("")
					SkillButton.Paint = function()
					end
					SkillButton.DoClick = function(slf)
						UpgradeMenu:SelectSkill(id)
						surface.PlaySound("ui/buttonclick.wav")
					end
				end
				surface.PlaySound("ui/buttonclick.wav")
			end
		end
	end
	UpgradeMenu:AddSkills()
	UpgradeMenu.SelectSkill = function(slf, sel)
		if IsValid(UpgradeMenu.SkillPanel) then
			UpgradeMenu.SkillPanel:Remove()
		end
		for k, v in pairs(MG_LevelSys.SortedSkills) do
			local id = v.id
			if sel == tostring(id) or sel == true then
				local SkillPanel = vgui.Create("DPanel", slf)
				SkillPanel:SetSize(slf:GetWide() * 0.6 - 20, slf:GetTall() - 70)
				SkillPanel:SetPos(ScrollPanel:GetWide() + 10, 60)
				SkillPanel.Paint = function(slf, w, h)
					draw.RoundedBox(2, 0, 0, w, h, Color(35, 35, 35))
				end
				UpgradeMenu.SkillPanel = SkillPanel
				local skill_level = v.level
				local max_tier = (v.max or MG_LevelSys_Config.MaxTiers)
				surface.SetFont("MG_LevelSys_MenuFont")
				local tier_txt = "Tier "..ply:getSkillTier(id).."/"..max_tier
				local x, y = surface.GetTextSize(tier_txt)
				local SkillTier = vgui.Create("DLabel", SkillPanel)
				SkillTier:SetPos(SkillPanel:GetWide() - x, 10)
				SkillTier:SetFont("MG_LevelSys_MenuFont")
				SkillTier:SetTextColor(color_white)
				SkillTier:SetText(tier_txt)
				SkillTier:SizeToContents()
				local SkillLevel = vgui.Create("DLabel", SkillPanel)
				SkillLevel:SetPos(20, 10)
				SkillLevel:SetFont("MG_LevelSys_MenuLevel")
				SkillLevel:SetTextColor(color_white)
				SkillLevel:SetText("Level "..skill_level)
				SkillLevel:SizeToContents()
				local SkillTitle = vgui.Create("DLabel", SkillPanel)
				local skill_name = v.name
				SkillTitle:SetPos(20, 40)
				SkillTitle:SetTextColor(color_white)
				SkillTitle:SetText(skill_name)
				SkillTitle:SetContentAlignment(5)
				SkillTitle:SetFont("MG_LevelSys_MenuSkillR")
				SkillTitle:SizeToContents()
				local desc = string.Replace(v.desc or "", "%s", string.Comma(math.Round(ply:getSkillPercentage(id, true, true) * 100, 2)))
				local SkillDesc = vgui.Create("DLabel", SkillPanel)
				SkillDesc:SetWide(SkillPanel:GetWide() - 40)
				SkillDesc:SetPos(20, 100)
				SkillDesc:SetWrap(true)
				SkillDesc:SetAutoStretchVertical(true)
				SkillDesc:SetFont("MG_LevelSys_MenuDescription")
				SkillDesc:SetTextColor(color_white)
				SkillDesc:SetText(desc)
				local perc = v.perc
				local skill_tier = ply:getSkillTier(id)
				local SkillMult
				local SkillLevelMult
				local SkillMaxLevel
				local AddButton
				local MaxLevel
				local SwitchButton
				if perc and perc > 0 then
					SkillMult = vgui.Create("DLabel", SkillPanel)
					SkillMult:SetPos(20, 120 + SkillDesc:GetTall())
					SkillMult:SetFont("MG_LevelSys_MenuFont")
					SkillMult:SetTextColor(color_white)
					SkillMult:SetText("Derzeitig: "..(v.symbol1 or "")..string.Comma(math.Round(ply:getSkillPercentage(id, true) * 100, 2))..(v.symbol2 or "%"))
					SkillMult.Think = function(slf)
						slf:SetPos(20, 120 + SkillDesc:GetTall())
					end
					SkillMult:SizeToContents()
					if skill_tier < max_tier then
						SkillLevelMult = vgui.Create("DLabel", SkillPanel)
						SkillLevelMult:SetPos(20, 140 + SkillDesc:GetTall())
						SkillLevelMult.Think = function(slf)
							slf:SetPos(20, 140 + SkillDesc:GetTall())
						end
						SkillLevelMult:SetFont("MG_LevelSys_MenuFont")
						SkillLevelMult:SetTextColor(color_white)
						SkillLevelMult:SetText("Nächstes Level: "..(v.symbol1 or "")..string.Comma(math.Round(ply:getSkillPercentage(id, true, true) * 100, 2))..(v.symbol2 or "%"))
						SkillLevelMult:SizeToContents()
					end
					SkillMaxLevel = vgui.Create("DLabel", SkillPanel)
					SkillMaxLevel:SetPos(20, (SkillLevelMult and 160 or SkillMult and 140 or 120) + SkillDesc:GetTall())
					SkillMaxLevel.Think = function(slf)
						slf:SetPos(20, (SkillLevelMult and 160 or SkillMult and 140 or 120) + SkillDesc:GetTall())
					end
					SkillMaxLevel:SetFont("MG_LevelSys_MenuFont")
					SkillMaxLevel:SetTextColor(color_white)
					SkillMaxLevel:SetText("Maximal: "..(v.symbol1 or "")..string.Comma(math.Round(perc, 2))..(v.symbol2 or "%"))
					SkillMaxLevel:SizeToContents()
				end
				if SkillMaxLevel then
					x, y = SkillMaxLevel:GetPos()
				else
					x, y = SkillDesc:GetPos()
				end
				if skill_tier < max_tier then
					AddButton = vgui.Create("DButton", SkillPanel)
					AddButton:SetSize(200, 35)
					AddButton:SetPos(20, y + 35)
					local price = math.floor((MG_LevelSys_Config.PricePerTier * (v.pricemult or 1)) * (skill_tier + 1))
					local price_txt = price and " ($"..string.Comma(price)..")" or ""
					if skill_tier <= 0 then
						AddButton:SetText("Freischalten"..price_txt)
					else
						AddButton:SetText("Verbessern"..price_txt)
					end
					AddButton:SetTextColor(color_white)
					AddButton:SetFont("MG_LevelSys_MenuPurchase")
					AddButton.Paint = function(slf, w, h)
						if SkillMaxLevel then
							x, y = SkillMaxLevel:GetPos()
						else
							x, y = SkillDesc:GetPos()
						end
						slf:SetPos(20, y + 35)
						y = y + AddButton:GetTall() + 10
						local col = ply:hasLevel(skill_level) and ply:hasPoints(1) and (price and ply:canAfford(price) or !price and true) and color_allow or color_deny
						ButtonDraw(slf, w, h, col)
					end
					AddButton.DoClick = function(slf)
						if (slf.Delay or 0) > CurTime() then return end
						slf.Delay = CurTime() + 1
						net.Start("MG_LevelSys:Upgrade")
							net.WriteString(id)
						net.SendToServer()
						surface.PlaySound("ui/buttonclick.wav")
					end
					y = y + AddButton:GetTall() + 10
				else
					MaxLevel = vgui.Create("DLabel", SkillPanel)
					MaxLevel:SetPos(20, y + 35)
					MaxLevel:SetText("Max. verbessert")
					MaxLevel:SetTextColor(color_white)
					MaxLevel:SetFont("MG_LevelSys_MenuMax")
					MaxLevel:SizeToContents()
					MaxLevel.Think = function(slf)
						if SkillMaxLevel then
							x, y = SkillMaxLevel:GetPos()
						else
							x, y = SkillDesc:GetPos()
						end
						slf:SetPos(20, y + 35)
					end
				end
				if skill_tier > 0 then
					local has_equipped = ply:hasSkillEquipped(id)
					SwitchButton = vgui.Create("DButton", SkillPanel)
					SwitchButton:SetSize(200, 25)
					SwitchButton:SetPos(20, y + 50)
					SwitchButton:SetText(has_equipped and "Skill deaktivieren" or "Skill aktivieren")
					SwitchButton:SetTextColor(color_white)
					SwitchButton:SetFont("MG_LevelSys_MenuPurchase")
					SwitchButton.Paint = function(slf, w, h)
						local exists = AddButton or MaxLevel
						if exists then
							x, y = exists:GetPos()
						else
							x, y = SkillDesc:GetPos()
						end
						slf:SetPos(20, y + 50)
						has_equipped = ply:hasSkillEquipped(id)
						local col = has_equipped and color_deny or color_allow
						slf:SetText(has_equipped and "Skill deaktivieren" or "Skill aktivieren")
						ButtonDraw(slf, w, h, col)
					end
					SwitchButton.DoClick = function(slf)
						if (slf.Delay or 0) > CurTime() then return end
						slf.Delay = CurTime() + 0.1
						has_equipped = ply:hasSkillEquipped(id)
						net.Start("MG_LevelSys:Configure")
							net.WriteBool(false)
							net.WriteString(id)
							net.WriteBool(!has_equipped)
						net.SendToServer()
						surface.PlaySound("ui/buttonclick.wav")
					end
				end
				SkillPanel.Think = function()
					if !ply:hasLevel(skill_level) then
						SkillTier:SetTextColor(text_color)
						SkillLevel:SetTextColor(text_color)
						SkillTitle:SetTextColor(text_color)
						SkillDesc:SetTextColor(text_color)
						if SkillMult then
							SkillMult:SetTextColor(text_color)
							SkillMaxLevel:SetTextColor(text_color)
							if SkillLevelMult then
								SkillLevelMult:SetTextColor(text_color)
							end
						end
						if MaxLevel then
							MaxLevel:SetTextColor(text_color)
						end
					elseif ply:hasSkill(id) and !ply:hasSkillEquipped(id) then
						SkillTier:SetTextColor(color_deactivated)
						SkillLevel:SetTextColor(color_deactivated)
						SkillTitle:SetTextColor(color_deactivated)
						SkillDesc:SetTextColor(color_deactivated)
						if SkillMult then
							SkillMult:SetTextColor(color_deactivated)
							SkillMaxLevel:SetTextColor(color_deactivated)
							if SkillLevelMult then
								SkillLevelMult:SetTextColor(color_deactivated)
							end
						end
						if MaxLevel then
							MaxLevel:SetTextColor(color_deactivated)
						end
					else
						SkillTier:SetTextColor(color_white)
						SkillLevel:SetTextColor(color_white)
						SkillTitle:SetTextColor(color_white)
						SkillDesc:SetTextColor(color_white)
						if SkillMult then
							SkillMult:SetTextColor(color_white)
							SkillMaxLevel:SetTextColor(color_white)
							if SkillLevelMult then
								SkillLevelMult:SetTextColor(color_white)
							end
						end
						if MaxLevel then
							MaxLevel:SetTextColor(color_white)
						end
					end
				end
				UpgradeMenu.Selected = skill_name
				break
			end
		end
	end
end

net.Receive("MG_LevelSys:Skill", function()
	local skills = net.ReadData(net.ReadUInt(16))
	skills = util.JSONToTable(util.Decompress(skills))

	MG_LevelSys.PlayerSkills = skills
end)

net.Receive("MG_LevelSys:Upgrade", function()
	local str = net.ReadString()
	if IsValid(UpgradeMenu) then
		if str == "" then
			if IsValid(UpgradeMenu.SkillPanel) then
				UpgradeMenu.SkillPanel:Remove()
			end
			UpgradeMenu:AddSkills()
		else
			UpgradeMenu:SelectSkill(str)
		end
	end
end)

local down = false
local delay = 0
local function BindHandler()
	if input.IsKeyDown(MG_LevelSys_Config.UpgradeMenuBind) then
		if !down then
			if IsValid(UpgradeMenu) then
				if UpgradeMenu:IsVisible() then
					UpgradeMenu:SetVisible(false)
				else
					UpgradeMenu:SetVisible(true)
				end
			else
				OpenUpgradeMenu()
			end
			down = true
		end
	else
		down = false
	end
end
hook.Add("Think", "MG_LevelSys:BindHandler", BindHandler)

hook.Add("OnPlayerChat", "MG_LevelSys:UpgradeMenu", function(ply, text)
	if string.lower(text) == MG_LevelSys_Config.UpgradeMenuCommandName then
		if ply != LocalPlayer() then return true end
		if IsValid(UpgradeMenu) then
			if UpgradeMenu:IsVisible() then
				UpgradeMenu:SetVisible(false)
			else
				UpgradeMenu:SetVisible(true)
			end
		else
			OpenUpgradeMenu()
		end
		return true
	end
end)