/////////////////////////
// Configuration file  //
/////////////////////////

MG_LevelSys_Config = MG_LevelSys_Config or {} // Ignore

MG_LevelSys_Config.EnableHUD = true // Is the HUD enabled?
MG_LevelSys_Config.LevelBarColor = Color(6, 116, 255, 255) // The color of the XP bar.

MG_LevelSys_Config.TimerModule = true // Give XP to everybody every howeverlong
MG_LevelSys_Config.TimerTime = 60 // How much time (in seconds) until everybody gets given XP
MG_LevelSys_Config.TimerXPAmount = 10 // How much XP to give each time it goes off

MG_LevelSys_Config.LevelPerPoint = 1 // After how many levels a point is given to the player
MG_LevelSys_Config.DefaultXP = 200 // How much XP a player needs to fulfill by default
MG_LevelSys_Config.XPMult = 1.1 // How hard it is to level up. 2 would require twice as much XP, ect.
MG_LevelSys_Config.MaxLevel = 2500 // The max level
MG_LevelSys_Config.ContinueXP = true // If remaining XP continues over to next levels.

MG_LevelSys_Config.TradeXP = true // Trade XP vs money
MG_LevelSys_Config.XPCost = 75 // How much costs 1 XP
MG_LevelSys_Config.TradeMinLevel = 5 // What level unlocks XP trading

MG_LevelSys_Config.UpgradeMenuBind = KEY_F8 // Which key opens the upgrade menu
MG_LevelSys_Config.UpgradeMenuBindName = "F8" // Name of the key which opens the upgrade menu

MG_LevelSys_Config.UpgradeMenuCommandName = "!skills" // Name of the command for upgrade menu

MG_LevelSys_Config.Skills = { // Skills (name, level, perc, id)
	["Allgemein"] = {
		{name = "Schläger", desc = "Erhöht Schaden der gewöhnlichen Faustschläge.", level = 1, perc = 4, id = "general_fists_dmg"},
		{name = "Combo Meister", desc = "Erhöht Schaden des Combo-Angriffs der Fäuste.", level = 1, perc = 15, id = "general_fists_combo"},
		{name = "Stahlschädel", desc = "Reduziert erlittenen Schaden auf den Kopf.", level = 1, perc = 6, id = "general_def_head"},
		{name = "Gute Gene", desc = "Erhöht Regenerationsgeschwindigkeit.", level = 1, perc = 15, id = "general_regen"},
		{name = "Psychopath", desc = "Erhöht Schaden mit stumpfen Nahkampfwaffen.", level = 5, perc = 10, id = "general_melee_dull"},
		{name = "Schlächter", desc = "Erhöht Schaden mit spitzen Nahkampfwaffen.", level = 5, perc = 8, id = "general_melee_sharp"},
		{name = "Friendly Fire", desc = "Reduziert den Schaden den du anderen Personen in einer Party machst.", level = 5, perc = 15, id = "general_friendly_fire"},
		{name = "Alkoholiker", desc = "Erhöht benötigte Dosis an Alkohol, um an diesem zu sterben.", level = 10, perc = 50, id = "general_alcoholic"},
		{name = "Adlerauge", desc = "Erhöht die Präzision beim Zielen mit allen Waffen.", level = 10, perc = 4, id = "general_precision_aim"},
		{name = "Ruhige Hand", desc = "Reduziert Rückstoß beim Zielen mit allen Waffen.", level = 10, perc = 6, id = "general_recoil_aim"},
		{name = "Bücherwurm", desc = "Erhöht allgemeinen Erfahrungsgewinn.", level = 20, perc = 10, id = "general_xp"},
		{name = "Handhabung", desc = "Erhöht Nachladegeschwindigkeit von Schrotflinten.", level = 20, perc = 5, id = "general_reload_shotgun"},
		{name = "Vorbereitet", desc = "Bei Start eines Bandenkriegs oder einer Rebellion erhältst du Rüstung, wenn deine Fraktion diesen begonnen hat.", level = 20, perc = 20, id = "general_prepared"},
		{name = "Pistolenwunder", desc = "Erhöht Schaden mit Pistolen.", level = 30, perc = 2.5, id = "general_dmg_pistol"},
		{name = "Revolverheld", desc = "Erhöht Schaden mit Revolvern.", level = 30, perc = 4, id = "general_dmg_revolver"},
		{name = "Akrobat", desc = "Erhöht Sprunghöhe.", level = 40, perc = 2.5, id = "general_jumppower"},
		{name = "Jogger", desc = "Erhöht Bewegungsgeschwindigkeit beim Gehen.", level = 40, perc = 3, id = "general_walkspeed"},
		{name = "Nerven aus Stahl", desc = "Erhöht die Präzision aus der Hüfte mit allen Waffen.", level = 50, perc = 1, id = "general_precision_hip"},
		{name = "Athlet", desc = "Erhöht Bewegungsgeschwindigkeit beim Rennen.", level = 50, perc = 1, id = "general_runspeed"},
		{name = "Steueroase", desc = "Erhöht erhaltene Zinsen.\nDieser Skill ist doppelt so teuer, weil die MG-Bank Steuern auf diesen Skill erhebt.", level = 50, perc = 25, id = "general_steueroase", pricemult = 2},
		{name = "Konzentriert", desc = "Reduziert Rückstoß aus der Hüfte mit allen Waffen.", level = 60, perc = 2, id = "general_recoil_hip"},
		{name = "Gewandt", desc = "Erhöht Bewegungsgeschwindigkeit beim Ducken.", level = 60, perc = 7.5, id = "general_crouchspeed"},
		{name = "Mitarbeiter des Monats", desc = "Erhöht Endgehalt.", level = 70, perc = 10, id = "general_loan"},
		{name = "Todeswut", desc = "Erhöht Schaden, wenn Leben unter 20 fallen.", level = 70, perc = 7.5, id = "general_dmg_rage"},
		{name = "Schwachpunkt", desc = "Führt kritische Treffer ein, welche 50% mehr Schaden anrichten.", level = 80, perc = 1, id = "general_dmg_crit"},
		{name = "Silbergeschoss", desc = "Erhöht Schaden auf den Körper mit Scharfschützengewehren.", level = 80, perc = 10, id = "general_dmg_body_sniper"},
		{name = "Sportschütze", desc = "Erhöht Schaden mit Gewehren.", level = 90, perc = 2, id = "general_dmg_assault"},
		{name = "Fingerfertigkeit", desc = "Erhöht Nachladegeschwindigkeit mit allen Waffen.", level = 90, perc = 3, id = "general_reload"},
		{name = "Alleskönner", desc = "Erhöht Wirksamkeit aller Skills.", level = 90, perc = 2.5, id = "general_%mult"},
		(MG_LevelSys_Config.TradeXP and {name = "Händler", desc = "Reduziert Kosten für Tausch von $ gegen XP.", level = 100, perc = 20, id = "general_merchant"}),
		{name = "Meister der Zeit", desc = "Erhöht Erfahrungsgewinn durch Spielzeit.", level = 100, perc = 10, id = "general_xp_time"},
		{name = "Alleskönner II", desc = "Erhöht Wirksamkeit aller Skills.", level = 100, perc = 2.5, id = "general_%mult2"},

		{name = "Kultivist", desc = "Erhöht allgemeinen Erfahrungsgewinn.", level = 100, perc = 20, id = "general_xp2"},
		{name = "Investor", desc = "Erhöht die Maximalgrenze, die man an Zinsen erhalten kann.\nDieser Skill ist doppelt so teuer, weil die MG-Bank Steuern auf diesen Skill erhebt.", level = 110, perc = 5, id = "general_investor", pricemult = 2},
		{name = "Kultivist II", desc = "Erhöht allgemeinen Erfahrungsgewinn.", level = 120, perc = 20, id = "general_xp3"},
		{name = "Investor II", desc = "Erhöht die Maximalgrenze, die man an Zinsen erhalten kann.\nDieser Skill ist doppelt so teuer, weil die MG-Bank Steuern auf diesen Skill erhebt.", level = 130, perc = 5, id = "general_investor2", pricemult = 2},
		{name = "Kultivist III", desc = "Erhöht allgemeinen Erfahrungsgewinn.", level = 140, perc = 20, id = "general_xp4"},
		{name = "Investor III", desc = "Erhöht die Maximalgrenze, die man an Zinsen erhalten kann.\nDieser Skill ist doppelt so teuer, weil die MG-Bank Steuern auf diesen Skill erhebt.", level = 150, perc = 5, id = "general_investor3", pricemult = 2},
		(MG_LevelSys_Config.TradeXP and {name = "Händler II", desc = "Reduziert Kosten für Tausch von $ gegen XP.", level = 160, perc = 20, id = "general_merchant2"}),
	},
	["Bürger"] = {
		{name = "Arbeitslosengeld", desc = "Erhöht Endgehalt.", level = 10, perc = 25, id = "citizen_loan"},
		{name = "Flitzer", desc = "Erhöht Bewegungsgeschwindigkeit beim Rennen.", level = 20, perc = 2, id = "citizen_runspeed"},
	},
	["Priester"] = {
		{name = "Kirchensteuer", desc = "Erhöht Endgehalt.", level = 10, perc = 25, id = "priest_loan"},
		{name = "Kein Ruhetag", desc = "Erhöht Bewegungsgeschwindigkeit beim Rennen an Sonntagen.", level = 20, perc = 5, id = "priest_runspeed"},
	},
	["Auftragsmörder"] = {
		{name = "Meisterschütze", desc = "Erhöht Schaden gegen Zielpersonen auf eine Distanz von über 20m.", level = 10, perc = 25, id = "hitman_dmg_dist"},
		{name = "Assassine", desc = "Erhöht Schaden mit spitzen Nahkampfwaffen.", level = 20, perc = 40, id = "hitman_dmg_melee_sharp"},
	},
	-- Anwalt
	["Banker"] = {
		{name = "Läuft wie geschmiert", desc = "Erhöht Gelddrucker-Geschwindigket für 10 Minuten um %s%, nachdem Geld entnommen wurde.", level = 10, perc = 15, id = "banker_printer"},
		{name = "Eigenartiger Tresor", desc = "Money Pots generieren jede Minute %s% des Geldes, was in ihnen steckt.\nFunktioniert nur mit Werten bis hin zu $100,000.", level = 20, perc = 0.3, id = "banker_safe"},
	},
	-- Kinobesitzer
	-- DJ
	-- Taxifahrer
	["Gärtner"] = {
		{name = "Grüner Daumen", desc = "Erhöht die Geschwindigkeit mit der Pflanzen heranwachsen.", level = 10, perc = 15, id = "gardener_growth"},
		{name = "Sprinkler", desc = "Fügt Chance ein, dass beim Wässern einer Pflanze alle gewässert werden.", level = 20, perc = 7.5, id = "gardener_sprinkler"},
	},
	["Ölraffinerist"] = {
		{name = "Auf Öl gestoßen", desc = "Erhöht die Menge an Öl, die aus einer Ölquelle gewonnen werden kann.", level = 10, perc = 8, id = "refinery_oilmult"},
		{name = "Deal Maker", desc = "Schlage den Ölkaufer mit deinen Fäusten, damit er zu einer Wahrscheinlichkeit von %s% all dein Öl aufkauft.", level = 20, perc = 80, id = "refinery_dealmaker"},
	},
	["Bergmann"] = {
		{name = "Mechanischer Arm", desc = "Erhöht die Angriffs-Geschwindigkeit der Spitzhacke.", level = 10, perc = 6, id = "miner_pickaxe_speed"},
		{name = "Gewetzt", desc = "Erhöht den Schaden der Spitzhacke.", level = 20, perc = 60, id = "miner_pickaxe_dmg"},
	},
	["Methkoch"] = {
		{name = "Ass im Ärmel", desc = "Fügt Chance ein, dass illegale Gegenstände bei einer Durchsuchung mit dem Waffenchecker nicht angezeigt werden.", level = 10, perc = 15, id = "methcook_ace"},
		{name = "Dyskalkulie", desc = "Du scheinst dich mit der Mengenangabe des Aluminiums oft zu vertun.\nFügt Chance ein, dass ein Aluminium für den Kochprozess ausreicht.", level = 20, perc = 25, id = "methcook_calc"},
	},
	["Obdachlose"] = {
		{name = "Wühlmaus", desc = "Erhöht die Geschwindigkeit mit der Mülltonnen durchsucht werden.", level = 10, perc = 20, id = "hobo_hoarder"},
		{name = "Riesenblase", desc = "Erhöht die Menge an Urin, die man pinkeln kann.", level = 20, perc = 20, id = "hobo_pee"},
		{name = "Ritter aus Karton", desc = "Fügt Chance ein, mit 10% Rüstung zu spawnen.", level = 30, perc = 10, id = "hobo_armor"},
		{name = "Auf der Flucht", desc = "Erhöht Bewegungsgeschwindigkeit beim Rennen.", level = 40, perc = 1, id = "hobo_runspeed"},
	},
	["Hunde"] = {
		{name = "Straßenköter", desc = "Fügt Chance ein, dass ein Hunger-Zyklus übersprungen wird.", level = 10, perc = 25, id = "dog_hunger"},
		{name = "Willensstark", desc = "Reduziert Schaden durch Verhungern.", level = 20, perc = 60, id = "dog_dmg_hunger"},
		{name = "Bissig", desc = "Erhöht Schaden mit allen Angriffen.", level = 40, perc = 15, id = "dog_dmg"},
	}, 
	["Terrorist"] = {
		{name = "Henker", desc = "Erhöht Schaden mit spitzen Nahkampfwaffen.", level = 10, perc = 50, id = "terror_melee_sharp"},
		{name = "Dragonborn", desc = "Reduziert erlittenen Schaden durch Explosionen.", level = 20, perc = 60, id = "terror_def_exp"},
	},
	-- Arzt
	-- Koch
	["Mechaniker"] = {
		{name = "Tankwart", desc = "Erhöht die Geschwindigkeit des Auftankens von Autos.", level = 10, perc = 8, id = "mechanic_fuel"},
		{name = "Kleiner Zaubertrick", desc = "Fügt Chance ein, dass nachdem ein Teil von einem Auto repariert wurde, das gesamte Auto vollständig repariert wird.", level = 20, perc = 1, id = "mechanic_magic"},
	},
	-- Waffenhändler
	-- Schwarzmarkthändler
	["Drogenhändler"] = {
		{name = "Connections", desc = "Erhöht die Geschwindigkeit mit der Marihuanapflanzen verkauft werden.", level = 10, perc = 20, id = "dealer_connections"},
		{name = "Multitasker", desc = "Fügt Chance ein, dass beim Wässern einer Pflanze alle gewässert werden.", level = 20, perc = 7.5, id = "dealer_multitasker"},
		{name = "Drogenimperium", desc = "Erhöht den Gewinn, den man aus Marihuanapflanzen rausschlagen kann.", level = 40, perc = 10, id = "dealer_empire"},
	},
	["Sicherheitsmann"] = {
		{name = "Leibwächter", desc = "Gewährt Rüstung beim Spawn.", level = 10, perc = 50, id = "security_armor"},
		{name = "Leibesvisitation", desc = "Erhöht Durchsuchungs-Geschwindigkeit des Waffencheckers.", level = 10, perc = 10, id = "security_checker"},
	},
	["Bürgermeister"] = {
		{name = "Steuerhinterzug", desc = "Ein Teil des Steuereinnahmen findet seinen Weg in die Staatskasse nicht.\nEr kommt stattdessen bei dir an.", level = 10, perc = 5, id = "mayor_taxes"},
		{name = "Gemeinschaftsfeld", desc = "Wenn du als Bürgermeister gewählt wirst, füllt sich die Staatskasse um $%s, wenn sie unter $50,000 liegt.", level = 20, perc = 5000, id = "mayor_communityfield", symbol1 = "$", symbol2 = ""},
	},
	["Geheimdienst"] = {
		{name = "Leibwächter Mk II", desc = "Gewährt Rüstung beim Spawn.", level = 10, perc = 50, id = "ss_armor"},
		{name = "Leibwächter Mk III", desc = "Gewährt Rüstung beim Spawn.", level = 20, perc = 50, id = "ss_armor2"},
	},
	["Staatsbeamte"] = {
		{name = "Kurzer Prozess", desc = "Erhöht die Geschwindigkeit mit der man fesselt.", level = 10, perc = 7.5, id = "sb_cuffs"},
		{name = "Bodycheck", desc = "Erhöht Durchsuchungs-Geschwindigkeit des Waffencheckers.", level = 20, perc = 8, id = "sb_checker"},
	},
	["Polizei & Wachtmeister"] = {
		{name = "Schildkrötenpanzer", desc = "Reduziert erlittenen Schaden durch andere für 2 Sekunden, wenn versucht wurde Polizei-Handschellen an eine Person, die kein Staatsbeamter ist, anzulegen.", level = 10, perc = 30, id = "police_res_cuffs"},
		{name = "Überladung", desc = "Erhöht Nachladegeschwindigkeit des Tasers nach einem erfolgreichen Treffer.", level = 20, perc = 40, id = "police_taser"},
		{name = "Kill On Sight", desc = "Erhöht Schaden mit leichten Waffen gegen gesuchte Personen.", level = 30, perc = 4, id = "police_dmg_wanted"},
		{name = "Waffenkenntnis", desc = "Nur für den Wachtmeister:\nErhöht Rausholgeschwindigkeit mit Revolvern und Schrotflinten.", level = 40, perc = 15, id = "chief_equipspeed"},
	},
	-- Gefängniswärter
	["SEKs"] = {
		{name = "Notstands-Weste", desc = "Gewährt mehr Rüstung am Arsenal.", level = 10, perc = 25, id = "sek_armor"},
		{name = "Stichhemmende Weste", desc = "Negiert %s% des ersten erlittenen Schadens durch spitze Nahkampfwaffen.\nHat eine Abklingzeit von 40 Sekunden.", level = 20, perc = 40, id = "sek_res"},
		{name = "Neutralisierung", desc = "Erhöht Schaden gegen Personen mit ausgerüsteter Schusswaffe und reduziert Schaden gegen Personen ohne ausgerüstete Schusswaffe.", level = 30, perc = 5, id = "sek_dmg"},
		{name = "Bereitschaft", desc = "Erhöht Rausholgeschwindigkeit mit allen Waffen, wenn vor weniger als 6 Sekunden Schaden durch eine Person erlitten wurde.", level = 40, perc = 20, id = "sek_equipspeed"},
	},
	-- Zoll
	["Organisierte Gangs"] = {
		{name = "Geiselnehmer", desc = "Erhöht die Geschwindigkeit mit der Personen, die keine Staatsbeamten sind, gefesselt werden.", level = 10, perc = 15, id = "gang_cuffs_speed"},
		{name = "Notwehr oder so", desc = "Erhöht Schaden während nach einem gefahndet wird.", level = 20, perc = 2.5, id = "gang_dmg"},
		{name = "Selbstfreispruch", desc = "Erhöht die Geschwindigkeit mit der man sich selbst aus Fesseln befreien kann.", level = 30, perc = 10, id = "gang_cuffs_free"},
		{name = "Keypad-Knacker", desc = "Erhöht die Geschwindigkeit vom Keypad-Cracker.", level = 40, perc = 10, id = "gang_keypad"},
		{name = "Räuber", desc = "Erhöht gestohlene Menge an Geld, die man durch das Ausrauben der Staatskasse erhält.", level = 40, perc = 25, id = "gang_robber"},
	},
	["Diebe"] = {
		{name = "Techniker", desc = "Fügt Chance ein, dass Hausalarmanlagen bei einem Einbruch nicht anschlagen.", level = 10, perc = 15, id = "thief_caution"},
		{name = "Unbemerkt", desc = "Reduziert die Lautstärke der Brechstange beim Aufknacken von Türen.", level = 20, perc = 25, id = "thief_lockpick_sound"},
		{name = "Langfinger", desc = "Erhöht die Geschwindigkeit des Taschendiebstahls.", level = 30, perc = 15, id = "thief_stealspeed"},
		{name = "Schlossknacker", desc = "Erhöht die Geschwindigkeit vom Aufbrechen von Türen mit der Brechstange.", level = 40, perc = 10, id = "thief_lockpick_speed"},
	},
}

MG_LevelSys_Config.MaxTiers = 10 // Max tiers

MG_LevelSys_Config.PricePerTier = 1000 // Price per Tier

MG_LevelSys_Config.RefundMult = 0.6 // Refund for resetting

MG_LevelSys_Config.LevelSpeedMult = { // Ranks which speed up levelling with time
	["owner"] = 1.3,
	["stellv. owner"] = 1.3,
	["infrastrukturadmin"] = 1.3,
	["community-manager"] = 1.3,
	["teamleiter"] = 1.3,
	["developer"] = 1.3,
	["superadmin_vip"] = 1.3,
	["admin_vip"] = 1.3,
	["moderator_vip"] = 1.3,
	["vip++"] = 1.3,
	["vip+"] = 1.2,
	["vip"] = 1.1,
}

MG_LevelSys_Config.SkillFuncs = { // Functions which get's called for specific perks.
	["general_jumppower"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Sprunghöhe wird beim nächsten Respawn erhöht.")
		end)
	end,
	["general_walkspeed"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Bewegungsgeschwindigkeit wird beim nächsten Respawn erhöht.")
		end)
	end,
	["general_runspeed"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Bewegungsgeschwindigkeit wird beim nächsten Respawn erhöht.")
		end)
	end,
	["general_crouchspeed"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Bewegungsgeschwindigkeit wird beim nächsten Respawn erhöht.")
		end)
	end,
	["citizen_runspeed"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Bewegungsgeschwindigkeit wird beim nächsten Respawn erhöht.")
		end)
	end,
	["priest_runspeed"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Bewegungsgeschwindigkeit wird beim nächsten Respawn erhöht.")
		end)
	end,
	["hobo_runspeed"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Bewegungsgeschwindigkeit wird beim nächsten Respawn erhöht.")
		end)
	end,
	["hobo_armor"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Rüstung wird beim nächsten Respawn erhöht.")
		end)
	end,
	["ss_armor"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Rüstung wird beim nächsten Respawn erhöht.")
		end)
	end,
	["ss_armor2"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Rüstung wird beim nächsten Respawn erhöht.")
		end)
	end,
	["security_armor"] = function(ply)
		timer.Create("MG_LevelSys:Info", 2, 1, function()
			if !IsValid(ply) then return end
			DarkRP.notify(ply, 0, 4, "Deine Rüstung wird beim nächsten Respawn erhöht.")
		end)
	end,
}