local metal_detector_gui = {}
local ent
function metal_detector_gui.CreateMenu(visible)
	local Menu = vgui.Create("DFrame")
	Menu.ElementId = Menu.ElementId or 0
	Menu.Extra = 0
	Menu:SetSize(300, 160)
	Menu:SetTitle("")
	Menu:SetDraggable(false)
	Menu:Center()
	Menu.Think = function()
		local ply = LocalPlayer()
		if !IsValid(ent) or !ply:Alive() or ply:GetPos():DistToSqr(ent:GetPos()) > 10000 then
			Menu:SetVisible(false)
		end
	end

	function Menu:Paint(w, h)
		draw.RoundedBox(8, 0, 0, w, h, Color(60, 60, 60, 170))
	end

	function Menu:UpdatePosSize(Extra)
		if Extra then
			Menu.Extra = Menu.Extra + Extra
		end
		Menu:SetSize(300, 14 + Menu.ElementId * 60 + Menu.ElementId * 14 + Menu.Extra)
		Menu:Center()
	end

	function Menu:CreateButton(Text, Action, Icon)
		local Icon = Material("icon16/"..Icon..".png")
		local Button = vgui.Create("DButton")
		Button:SetParent(Menu)
		Button:SetText("")
		Button:SetPos(10, 14 + Menu.ElementId * 60 + Menu.ElementId * 14 + Menu.Extra)
		Button:SetSize(280, 60)
		Button.DoClick = Action
		Button.CustomColor = Color(255, 255, 255, 255)
		Button.Text = Text
		function Button:Paint(W, H)
			if !self:IsHovered() then
				draw.RoundedBox(8, 0, 0, W, H, Color(20, 20, 20, 255))
				draw.SimpleText(Button.Text, "mg_instructions", W / 2, H / 2, self.CustomColor, 1, 1)
				surface.SetDrawColor(255, 255, 255, 255)
				surface.SetMaterial(Icon)
				surface.DrawTexturedRect(11, H / 2 - 8, 16, 16)
				surface.DrawTexturedRect(W - 11 - 16, H / 2 - 8, 16, 16)
			else
				draw.RoundedBox(8, 0, 0, W, H, Color(100, 100, 100, 255))
				draw.SimpleText(Button.Text, "mg_instructions", W / 2, H / 2, self.CustomColor, 1, 1)
				surface.SetDrawColor(255, 255, 255, 255)
				surface.SetMaterial(Icon)
				surface.DrawTexturedRect(11, H / 2 - 8, 16, 16)
				surface.DrawTexturedRect(W - 11 - 16, H / 2 - 8, 16, 16)
			end
		end
		Menu.ElementId = Menu.ElementId + 1
		Menu:UpdatePosSize()
		return Button
	end

	function Menu:Remove(Element)
		Element:Remove()
		Menu.ElementId = Menu.ElementId - 1
		Menu:UpdatePosSize()
	end

	function Menu:CreateLabel(Text)
		local Label = vgui.Create("DLabel")
		Label:SetParent(Menu)
		Label:SetPos(20, 33 + Menu.ElementId * 60 + Menu.ElementId * 14 + Menu.Extra)
		Label:SetSize(260, 30)
		Label:SetText(Text)
		Label:SetFont("mg_instructions")
		Label:SetTextColor(Color(255, 255, 255, 255))
		Label:SetContentAlignment(5)
		Menu.ElementId = Menu.ElementId + 1
		Menu:UpdatePosSize()
		return Label
	end

	Menu:ShowCloseButton(false)
	Menu:SetVisible(visible)
	Menu:MakePopup()
	Menu:ParentToHUD()
	return Menu
end

local Panel = metal_detector_gui.CreateMenu(false)
local Panel2 = metal_detector_gui.CreateMenu(false)

net.Receive("MetalDetector_Remove", function()
	ent = net.ReadEntity()
	Panel:SetVisible(true)
end)

Panel:CreateLabel("Metaldetektor")

Panel:CreateButton("Detektor löschen", function()
	surface.PlaySound("ui/buttonclick.wav")
	Panel:SetVisible(false)
	Panel2:SetVisible(true)
end, "delete")

Panel:CreateButton("Fenster schließen", function()
	surface.PlaySound("ui/buttonclick.wav")
	Panel:SetVisible(false)
end, "cross")

Panel2:CreateLabel("Bist du dir sicher?")

Panel2:CreateButton("Akzeptieren", function()
	surface.PlaySound("ui/buttonclick.wav")
	Panel2:SetVisible(false)
	if !IsValid(ent) then return end
	net.Start("MetalDetector_Remove")
		net.WriteEntity(ent)
	net.SendToServer()
end, "accept")

Panel2:CreateButton("Abbrechen", function()
	surface.PlaySound("ui/buttonclick.wav")
	Panel2:SetVisible(false)
	Panel:SetVisible(true)
end, "cancel")