-- Waffenfunktionen

local reg = debug.getregistry()

local EyeAngles = reg.Entity.EyeAngles
local EyePos = reg.Entity.EyePos

function MG_IsLookingAt(ply, target, margin)
	local yes = EyeAngles(ply):Forward():Dot((EyePos(target) - EyePos(ply)):GetNormalized())
	return yes >= margin
end

local pi = math.pi
local GetAimVector = reg.Player.GetAimVector
local GetShootPos = reg.Player.GetShootPos
function MG_CanSee(ply, target, margin)
	local directionAng = pi / (margin or 6)
	local aimvector = GetAimVector(ply)
	local entVector = GetShootPos(target) - GetShootPos(ply)
	local dot = aimvector:Dot(entVector) / entVector:Length()
	return dot > directionAng
end

function MG_AttackTrace(ply, tbl)
	tbl.lagcompensation = tbl.lagcompensation or true
	if tbl.lagcompensation then
		ply:LagCompensation(true)
	end
	local tr = util.TraceLine({
		start = tbl.start,
		endpos = tbl.endpos,
		filter = ply,
		mask = tbl.mask
	})
	if tbl.mins and tbl.maxs and !IsValid(tr.Entity) then 
		tr = util.TraceHull({
			start = tbl.start,
			endpos = tbl.endpos,
			filter = ply,
			mins = tbl.mins,
			maxs = tbl.maxs,
			mask = tbl.mask
		})
	end
	if tbl.lagcompensation then
		ply:LagCompensation(false)
	end
	return tr
end

function MG_GetBodyOwner(ent, alive)
	local rag_ply = ent:GetDTEntity(0)
	return IsValid(rag_ply) and rag_ply:IsPlayer() and (alive and !rag_ply:Alive() or !alive and true) and rag_ply
end

-- Geräusche beim Gehen

local job_tbl
local reg = debug.getregistry()
local GetTeam = reg.Player.Team
local footstep, footstep_condition
hook.Add("PlayerFootstep", "MG_Lib_CustomFootsteps", function(ply, pos, foot, snd, volume, filter)
	job_tbl = RPExtraTeams[GetTeam(ply)]
	if job_tbl then
		footstep = job_tbl.footstep
		footstep_condition = job_tbl.footstep_condition and job_tbl.footstep_condition(ply, pos, foot, snd, volume, filter)
		if footstep_condition == false then return end
		if footstep_condition == true or footstep == true then
			return true
		elseif footstep then
			sound.Play(istable(footstep) and footstep[math.random(#footstep)] or footstep, pos)
			return true
		end
	end
end)

-- Sprung-Cooldown

hook.Add("OnPlayerHitGround", "MG_Lib_JumpCooldown", function(ply, _, _, speed)
	job_tbl = RPExtraTeams[GetTeam(ply)]
	if job_tbl and job_tbl.jumpcooldown and speed > 100 then
		ply.CuffsNextJumpTime = CurTime() + job_tbl.jumpcooldown -- Nutzt das System der Handschellen intern.
	end
end)

hook.Add("PlayerHurt", "MG_Lib_CuffRestricts", function(ply, att, rem, dmg)
	if dmg <= 3 then return end
	ply.MG_Lib_LastHit = CurTime() + 1
end)

-- Fesseln

hook.Add("Cuffs_AttemptBreak", "MG_Lib_CuffRestricts", function(ply)
	if (ply.MG_Lib_LastHit or 0) > CurTime() then
		return false
	end
end)

-- Beschränkungen

hook.Add("canTasePlayer", "MG_Lib_Restrict", function(ply, wep, pl)
	local job = RPExtraTeams[pl:Team()]
	if job and job.res and !job.res.taser then
		return false
	end
end)

hook.Add("canSleep", "MG_Lib_Restrict", function(ply)
	local job = RPExtraTeams[ply:Team()]
	if job and job.res and !job.res.sleep then
		return false
	end
end)