local local_ply, ragdollplayer
local view = {}
local function CalcView(ply, origin, angles, fov)
	ragdollplayer = ply.RagdollPlayer
	if IsValid(ragdollplayer) and ply:GetViewEntity() == ply then
		local bid = ragdollplayer:LookupBone("ValveBiped.Bip01_Head1")
		if bid then
			local pos, ang = ragdollplayer:GetBonePosition(bid)
			pos = pos + ang:Forward() * 7
			ang:RotateAroundAxis(ang:Up(), -90)
			ang:RotateAroundAxis(ang:Forward(), -90)
			pos = pos + ang:Forward() * 1
			view.origin = pos
			view.angles = ang
			return view
		end
	end
end

local parent
local unconcious_clr = Color(0, 0, 0, 253)

local function RagdollDrawHUD()
	local_ply = local_ply or LocalPlayer()
	ragdollplayer = local_ply.RagdollPlayer

	if IsValid(ragdollplayer) then
		local allowed = ragdollplayer:GetNW2Bool("IsSleeping")
		if allowed then
			local scrw = ScrW()
			local scrh = ScrH()
			draw.DrawNonParsedSimpleText("Du schläfst.", "DarkRPHUD2", scrw / 2, scrh / 2 - 100, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			draw.DrawNonParsedSimpleText("Wache mit \"/sleep\" auf.", "DarkRPHUD2", scrw / 2, scrh / 2 - 60, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		end
	end
end

local function RagdollDrawBackground()
	local_ply = local_ply or LocalPlayer()
	ragdollplayer = local_ply.RagdollPlayer

	if IsValid(ragdollplayer) then
		local allowed = ragdollplayer:GetNW2Bool("IsSleeping")
		if allowed then
			surface.SetDrawColor(unconcious_clr)
			local scrw = ScrW()
			local scrh = ScrH()
			surface.DrawRect(-1, -1, scrw + 2, scrh + 2)
		end
	end
end

local RagdollPlayers = {}
local function CuffsSupport()
	for _, v in pairs(RagdollPlayers) do
		if v:GetNW2String("cuffs_ropemat") == "" or v:GetNW2String("cuffs_cuffmat") == "" then continue end
		if !v.Cuffed then
			local kidnapper = v:GetNW2Entity("cuffs_kidnapper")
			local collar = v:GetNW2Bool("cuffs_collar")
			local handcuffed = weapons.Get("weapon_handcuffed")
			if !handcuffed then return end
			v.Cuffed = {
				cuffmat = v:GetNW2String("cuffs_cuffmat"),
				ropemat = v:GetNW2String("cuffs_ropemat"),
				GetBonePos = handcuffed.GetBonePos,
				GetIsCollar = function() return collar end,
				GetCuffMaterial = function(self) return self.cuffmat end,
				GetRopeMaterial = function(self) return self.ropemat end,
				GetKidnapper = function() return kidnapper end,
				Owner = v
			}
			v.Cuffed.DrawWorldModel = handcuffed.DrawWorldModel
		end
		v.Cuffed:DrawWorldModel()
	end
end

local page = Material("icon16/page_white_text.png")
local targ
local function DrawRagdollHUD()
	local_ply = local_ply or LocalPlayer()
	targ = local_ply:GetEyeTrace().Entity
	if IsValid(targ) and targ:IsRagdoll() and IsValid(targ:GetDTEntity(0)) and local_ply:GetPos():DistToSqr(targ:GetPos()) < 160000 then
		targ:GetDTEntity(0):drawPlayerInfo(targ:GetPos())
	end
end

hook.Add("NetworkEntityCreated", "Ragdoll_RagdollCreated", function(ent)
	if ent:IsRagdoll() then
		local ply = ent:GetDTEntity(0)
		if ply:IsValid() and ply:IsPlayer() then
			if table.IsEmpty(RagdollPlayers) then
				hook.Add("HUDPaint", "Ragdoll_DrawInfo", DrawRagdollHUD)
				hook.Add("PostDrawOpaqueRenderables", "Ragdoll_CuffsSupport", CuffsSupport)
			end
			if ply == LocalPlayer() then
				hook.Add("CalcView", "Ragdoll_CalcView", CalcView)
				hook.Add("HUDPaintBackground", "Ragdoll_DrawHUD", RagdollDrawHUD)
				hook.Add("RenderScreenspaceEffects", "Ragdoll_DrawBackground", RagdollDrawBackground)
			end
			RagdollPlayers[ent:EntIndex()] = ent
			ply.RagdollPlayer = ent
			ent.PlayerRagdoll = ply
			if ent:GetCreationTime() > CurTime() - 1 then
				ent:SnatchModelInstance(ply)
			end
			ent.GetPlayerColor = function()
				return ply:GetPlayerColor()
			end
		end
	end
end)

hook.Add("EntityRemoved", "Ragdoll_RagdollRemoved", function(ent)
	if ent:IsRagdoll() then
		if ent.PlayerRagdoll == LocalPlayer() then
			hook.Remove("CalcView", "Ragdoll_CalcView")
			hook.Remove("HUDPaintBackground", "Ragdoll_DrawHUD")
			hook.Remove("RenderScreenspaceEffects", "Ragdoll_DrawBackground")
		end
		RagdollPlayers[ent:EntIndex()] = nil
		if table.IsEmpty(RagdollPlayers) then
			hook.Remove("HUDPaint", "Ragdoll_DrawInfo")
			hook.Remove("PostDrawOpaqueRenderables", "Ragdoll_CuffsSupport")
		end
	end
end)