MG_SeizeReward = MG_SeizeReward or {}
MG_SeizeReward.Seizes = MG_SeizeReward.Seizes or {}

local the_ply

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("mg_entfont", {font = use_font, size = 35, weight = 1000, blursize = 0, antialias = true, shadow = false})
surface.CreateFont("mg_entfont2", {font = use_font, size = 25, weight = 600, blursize = 0, antialias = true, shadow = false})

local local_ply, dist
local vector_1 = Vector(0, 0, 1)
function MG_SeizeReward.DrawVisuals()
	for ent, data in pairs(MG_SeizeReward.Seizes) do
		if !ent:IsValid() then
			MG_SeizeReward.Seizes[ent] = nil
			MG_SeizeReward.RemoveHook()
			continue
		end
		if ent:IsDormant() or ent:GetNoDraw() then continue end
		local_ply = local_ply or LocalPlayer()
		dist = local_ply:EyePos():DistToSqr(ent:GetPos())
		if dist > 160000 then return end
		local ang = ent:GetAngles()	
		local pos = ent:GetPos() + (vector_1 * (ent:OBBMaxs().z + 10 + math.sin(SysTime() * 2) * 2))
		ang:RotateAroundAxis(ang:Forward(), 90)
		ang:RotateAroundAxis(ang:Right(), -90)
		ang:RotateAroundAxis(ang:Up(), 0)
		local is_cp = local_ply:isCP()
		local plys = data.plys or {}
		local mult = 20
		local adjusted_pos = ((data.plycount - 1) * mult) + (!is_cp and 30 or 0)
		cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
			draw.SimpleTextOutlined("Konfiszierung läuft:", "mg_entfont", 0, -100 - adjusted_pos, Color(150, 20, 20, 255), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			draw.SimpleTextOutlined("Zeit verbleibend: "..string.ToMinutesSeconds(math.max(data.endtime - CurTime(), 0)), "mg_entfont2", 0, -70 - adjusted_pos, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			if !is_cp then
				draw.SimpleTextOutlined("Drücke "..((input.LookupBinding("+use") or "[BENUTZEN]"):upper())..", um die Konfiszierung abzubrechen!", "mg_entfont2", 0, -40 - adjusted_pos, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			end
			local cnt = 0
			if IsValid(the_ply) then
				cnt = cnt + 1
				draw.SimpleTextOutlined(the_ply:Name(), "mg_entfont2", 0, -(is_cp and 60 or 30) - adjusted_pos + (cnt * mult), team.GetColor(the_ply:Team()), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
				cnt = cnt + 1
			end
			for _, ply in ipairs(plys) do
				if !IsValid(ply) then continue end
				cnt = cnt + 1
				draw.SimpleTextOutlined(ply:Name(), "mg_entfont2", 0, -(is_cp and 60 or 30) - adjusted_pos + (cnt * mult), team.GetColor(ply:Team()), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
			end
		cam.End3D2D()
	end
end

local hook_exists = false
function MG_SeizeReward.AddHook()
	if hook_exists then return end
	if !table.IsEmpty(MG_SeizeReward.Seizes) then
		hook.Add("PostDrawTranslucentRenderables", "MG_SeizeReward", MG_SeizeReward.DrawVisuals)
	end
end

function MG_SeizeReward.RemoveHook()
	if !hook_exists then return end
	if table.IsEmpty(MG_SeizeReward.Seizes) then
		hook.Remove("PostDrawTranslucentRenderables", "MG_SeizeReward")
	end
end

net.Receive("MG_SeizeReward.Visual", function()
	local ent = net.ReadEntity()
	local seizing = net.ReadBool()
	local endtime = net.ReadFloat()
	local plys = net.ReadTable()
	if !IsValid(ent) then return end
	if seizing then
		the_ply = nil
		local newplys = {}
		for ply in pairs(plys) do
			if !IsValid(ply) then continue end
			if ply == LocalPlayer() then
				the_ply = ply
			else
				table.insert(newplys, ply)
			end
		end
		table.sort(newplys, function(a, b) return a:Name() < b:Name() end)
		MG_SeizeReward.Seizes[ent] = {
			endtime = endtime,
			plys = newplys,
			plycount = table.Count(plys)
		}
		MG_SeizeReward.AddHook()
		if ent.DrawTranslucent and !ent.OldDrawTranslucent then
			ent.OldDrawTranslucent = ent.DrawTranslucent
			ent.DrawTranslucent = function()
			end
		end
	else
		MG_SeizeReward.Seizes[ent] = nil
		if ent.OldDrawTranslucent then
			ent.DrawTranslucent = ent.OldDrawTranslucent
			ent.OldDrawTranslucent = nil
		end
		MG_SeizeReward.RemoveHook()
	end
end)