local tow_platforms = {}
local green = Color(0, 255, 0)
local function HighlightTowPlatforms()
	halo.Add(tow_platforms, green, 1, 1, 1, true, true)
end

net.Receive("DarkRP_HighlightTowPlatforms", function()
	tow_platforms = net.ReadTable()
	if !table.IsEmpty(tow_platforms) then
		hook.Add("PreDrawHalos", "DarkRP_HighlightTowPlatforms", HighlightTowPlatforms)
	else
		hook.Remove("PreDrawHalos", "DarkRP_HighlightTowPlatforms", HighlightTowPlatforms)
	end
end)

local towable_vehicles = {}
net.Receive("DarkRP_TowVehicles", function()
	local add = net.ReadBool()
	local ent = net.ReadEntity()
	if !IsValid(ent) or !ent:IsVehicle() or ent:GetClass() == "prop_vehicle_prisoner_pod" then return end
	if add then
		surface.PlaySound("radio/radio_on.wav")
		towable_vehicles[ent] = true
	else
		towable_vehicles[ent] = nil
	end
	if table.IsEmpty(towable_vehicles) then
		hook.Remove("PreDrawHalos", "DarkRP_HighlightTowPlatforms", HighlightTowPlatforms)
	end
end)

surface.CreateFont("DarkRP_Towing", {font = "Roboto Cn", size = 18, weight = 1000, antialias = true})

local local_ply, ent
local car = Material("icon16/car.png")
local function DrawTowedVehicles()
	local_ply = local_ply or LocalPlayer()
	ent = local_ply:GetEyeTrace().Entity
	if local_ply:Team() == TEAM_REPAIR then
		for k in pairs(towable_vehicles) do
			if !IsValid(k) then
				towable_vehicles[k] = nil
				continue
			end
			if k:GetNW2Float("Towed") > 0 then
				surface.SetFont("DarkRP_Towing")
				local pos = k:GetPos() + Vector(0, 0, 32)
				local dist = local_ply:EyePos():Distance(pos) * 0.0254
				local dist_txt = "Auto zur Abschleppung markiert."
				local dist_txt2 = "Distanz: "..string.Comma(math.Round(dist)).."m"
				local dist_txt3 = "Wird in "..string.ToMinutesSeconds(math.max(0, k:GetNW2Float("Towed") - CurTime())).." min automatisch abgeschleppt." 
				local size = surface.GetTextSize(dist_txt)
				local size2 = surface.GetTextSize(dist_txt2)
				local size3 = surface.GetTextSize(dist_txt3)
				local toscreen = pos:ToScreen()
				local toscreen_x = toscreen.x
				local toscreen_y = toscreen.y
				local offset = toscreen_x - (size / 2)
				local offset2 = toscreen_x - (size2 / 2)
				local offset3 = toscreen_x - (size3 / 2)
				surface.SetDrawColor(color_white)
				surface.SetMaterial(car)
				surface.DrawTexturedRect(toscreen_x - 18, toscreen_y - 32, 32, 32)
				draw.SimpleTextOutlined(dist_txt, "DarkRP_Towing", offset, toscreen_y, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
				draw.SimpleTextOutlined(dist_txt2, "DarkRP_Towing", offset2, toscreen_y + 16, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
				draw.SimpleTextOutlined(dist_txt3, "DarkRP_Towing", offset3, toscreen_y + 32, color_white, TEXT_ALIGN_LEFT, TEXT_ALIGN_TOP, 1, color_black)
			end
		end
	end
	if IsValid(ent) and ent:IsVehicle() and ent:GetClass() != "prop_vehicle_prisoner_pod" and local_ply:GetPos():DistToSqr(ent:GetPos()) < 40000 then
		local towed = ent:GetNW2Float("Towed")
		local tow_access = ent:GetNW2Bool("TowAccess")
		if towed > 0 or tow_access then
			local txt = "Dieses Auto wurde zur Abschleppung markiert."
			draw.DrawNonParsedText(txt, "Roboto20", ScrW() / 2, ScrH() / 2 - 110 + 1, color_black, 1)
			draw.DrawNonParsedText(txt, "Roboto20", ScrW() / 2, ScrH() / 2 - 110, color_white, 1)
			txt = tow_access and towed == 0 and "Dieses Auto wird momentan abgeschleppt." or "Wenn es nicht abgeholt wird, wird es in "..string.ToMinutesSeconds(math.max(0, towed - CurTime())).." min automatisch abgeschleppt."
			draw.DrawNonParsedText(txt, "Roboto20", ScrW() / 2, ScrH() / 2 - 90 + 1, color_black, 1)
			draw.DrawNonParsedText(txt, "Roboto20", ScrW() / 2, ScrH() / 2 - 90, color_white, 1)
		end
	end
end
hook.Add("HUDPaint", "DarkRP_DrawTowedVehicles", DrawTowedVehicles)