function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Emitter = ParticleEmitter(self.Start)
	for i = 1, 7 do
		local t = self.Emitter:Add("effects/yellowflare", self.Start)
		if t then
			t:SetVelocity(Vector(math.random(-45,45), math.random(-45,45), math.random(65,95)))
			t:SetDieTime(1)
			t:SetStartAlpha(255)
			t:SetStartSize(1)
			t:SetEndSize(0)
			t:SetRoll(0)
			t:SetGravity(Vector(0,0,-350))
			t:SetCollide(false)
			t:SetStartLength(0.05)
			t:SetEndLength(0.1)
			t:SetVelocityScale(true)
		end
	end
	for i = 1, 2 do
		local c = self.Emitter:Add("particle/particle_composite", self.Start)
		if c then
			c:SetDieTime(1)
			c:SetStartAlpha(100)
			c:SetEndAlpha(0)
			c:SetStartSize(4)
			c:SetEndSize(15)
			c:SetRoll(math.Rand(150, 360))
			c:SetRollDelta(math.Rand(-1,1))
			c:SetAirResistance(150)
			c:SetVelocity(Vector(math.random(-15,15), math.random(-15,15), math.random(0,40)))
			c:SetGravity(Vector(0, 0, -100))
			c:SetColor(200,200,200)
		end
	end
	for i = 1, 5 do
		local p = self.Emitter:Add("particle/smokesprites_000"..math.random(1,9), self.Start + Vector(math.Rand(-1, 1), math.Rand(-1, 1), math.Rand(0, 3)))
		if p then
			p:SetDieTime(math.Rand(1,1.2))
			p:SetStartAlpha(math.Rand(25,35))
			p:SetEndAlpha(0)
			p:SetStartSize(math.Rand(6, 8))
			p:SetEndSize(math.Rand(10, 12))
			p:SetRoll(math.Rand(-0.25, 0.25))
			p:SetRollDelta(math.Rand(-0.1,0.1))
			p:SetGravity(Vector(0,0,-15))
			p:SetVelocity(Vector(math.Rand(-5,5), math.Rand(-5,5), math.Rand(3,8)))
		end
	end
	for i = 1, 10 do
		local w = self.Emitter:Add("effects/fleck_tile"..math.random(1,2), self.Start + Vector(math.Rand(-1, 1), math.Rand(-1, 1), math.Rand(0, 1)))
		if w then
			w:SetVelocity(Vector(math.Rand(-55, 55), math.Rand(-55, 55), math.Rand(100, 150)))
			w:SetDieTime(math.Rand(1, 3))
			w:SetStartAlpha(255)
			w:SetEndAlpha(0)
			w:SetStartSize(1)
			w:SetEndSize(0)
			w:SetRoll(math.Rand(0, 360))
			w:SetRollDelta(math.Rand(-15, 15))
			w:SetAirResistance(70)
			w:SetGravity(Vector(0, 0, -600))
			w:SetColor(199, 199, 199)
			w:SetCollide(true)
			w:SetBounce(0.6)
		end
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end