function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Forward = data:GetNormal()
	self.Emitter = ParticleEmitter(self.Start)
	if !IsValid(self.Entity) then return end
	for i = 1, 50 do
		local p = self.Emitter:Add("effects/yellowflare", self.Start + self.Entity:GetForward() * math.Rand(-25, 25))
		if p then
			p:SetVelocity(Vector(math.Rand(-70, 70), math.Rand(-70, 70), math.Rand(0, 100)))
			p:SetDieTime(math.Rand(1, 1.5))
			p:SetStartAlpha(255)
			p:SetStartSize(1)
			p:SetEndSize(0)
			p:SetRoll(0)
			p:SetGravity(Vector(0, 0, -150))
			p:SetCollide(false)
			p:SetStartLength(0.1)
			p:SetEndLength(0.1)
			p:SetVelocityScale(true)
		end
	end
	for i = 1, 10 do
		local p = self.Emitter:Add("particle/smokesprites_000"..math.random(1, 9), self.Start + self.Forward * math.Rand(-25, 25) + Vector(0, 0, 5))
		if p then
			p:SetVelocity(Vector(math.Rand(-3, 3), math.Rand(-3, 3), math.Rand(0, 3)))
			p:SetDieTime(math.Rand(1, 2))
			p:SetStartAlpha(math.Rand(50, 80))
			p:SetEndAlpha(0)
			p:SetStartSize(math.Rand(5, 10))
			p:SetEndSize(math.Rand(25, 35))
			p:SetRoll(math.Rand(-1, 1))
			p:SetRollDelta(math.Rand(-0.5, 0.5))
			p:SetColor(190, 200, 200)
		end
	end
	for i = 1, 100 do
		local w = self.Emitter:Add("effects/fleck_tile"..math.random(1,2), self.Start + self.Forward * math.Rand(-25, 25))
		if w then
			w:SetVelocity(Vector(math.Rand(-65, 65), math.Rand(-65, 65), math.Rand(0, 130)))
			w:SetDieTime(math.Rand(2, 4))
			w:SetStartAlpha(255)
			w:SetEndAlpha(0)
			w:SetStartSize(1)
			w:SetEndSize(0)
			w:SetRoll(math.Rand(0, 360))
			w:SetRollDelta(math.Rand(-15, 15))
			w:SetAirResistance(70)
			w:SetGravity(Vector(0, 0, -300))
			w:SetCollide(true)
			w:SetBounce(0.6)
			w:SetColor(190, 200, 200)
		end
	end
	for i = 1, 50 do
		local w = self.Emitter:Add("effects/fleck_glass"..math.random(1, 3), self.Start + self.Forward * math.Rand(-25, 25))
		if w then
			w:SetVelocity(Vector(math.Rand(-45, 45), math.Rand(-45, 45), math.Rand(0, 100)))
			w:SetDieTime(math.Rand(3, 5))
			w:SetStartAlpha(255)
			w:SetEndAlpha(0)
			w:SetStartSize(1)
			w:SetEndSize(0)
			w:SetRoll(math.Rand(0, 360))
			w:SetRollDelta(math.Rand(-30, 30))
			w:SetAirResistance(70)
			w:SetGravity(Vector(0, 0, -200))
			w:SetCollide(true)
			w:SetBounce(0.6)
		end
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end