function EFFECT:Init(data)
	local pos = data:GetOrigin()
	local emitter = ParticleEmitter(pos)
	local color = data:GetStart()
	for i = 1, 100 do
		local particle = emitter:Add("particle/fire", pos)
		if particle then
			particle:SetVelocity(Vector(math.Rand(-300, 300), math.Rand(-300, 300), math.Rand(-100, 300)))
			particle:SetLifeTime(0)
			particle:SetDieTime(1)
			particle:SetColor(math.Round(color[1]), math.Round(color[2]), math.Round(color[3]))		
			particle:SetStartAlpha(255)
			particle:SetEndAlpha(0)
			particle:SetStartSize(5)
			particle:SetEndSize(0)
			particle:SetRoll(math.Rand(-360, 360))
			particle:SetRollDelta(math.Rand(-1, 1))
			particle:SetAirResistance(math.Rand(200, 300))
			particle:SetGravity(Vector(0, 0, -50))
			particle:SetCollide(true)
			particle:SetBounce(1)
		end
	end
	emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end