local hidepiss = CreateClientConVar("cl_hidepiss", 0, FCVAR_ARCHIVE)

local lastDecal = {}

function EFFECT:Init(data)
	local pos = data:GetOrigin()
	local ply = data:GetEntity()
	if !IsValid(ply) then return end
	local normal = Vector(math.Rand(0.5, 0.52), 0, math.Rand(0.5, 0.52))
	normal:Rotate(data:GetAngles())
	local strength = data:GetRadius()
	local emitter = ParticleEmitter(pos)
	local velocity = ply:GetVelocity()
	for i = 1, 3 do
		local particle = emitter:Add("effects/yellowflare", pos)
		if particle then
			particle:SetDieTime(math.Rand(3, 5))
			particle:SetStartAlpha(255)
			particle:SetStartSize(math.Rand(2, 4))
			particle:SetEndSize(0)
			particle:SetVelocity(velocity + Vector(strength, strength, 0) * (normal + VectorRand() * 0.01))
			particle:SetRoll(0)
			particle:SetColor(math.random(250, 255), math.random(225, 255), 0, 255)
			particle:SetGravity(Vector(0, 0, -130))
			particle:SetAirResistance(-3)
			particle:SetCollide(true)
			particle:SetBounce(0.4)
			particle:SetStartLength(0.1)
			particle:SetEndLength(0.5)
			particle:SetVelocityScale(true)
			if !hidepiss:GetBool() then
				particle:SetCollideCallback(function(part, hitpos, hitnormal)
					if part.Decal then return end
					part.Decal = true
					if (lastDecal[ply] or 0) > CurTime() then return end
					lastDecal[ply] = CurTime() + 0.25
					util.Decal("BeerSplash", hitpos + hitnormal, hitpos - hitnormal, {part, ply})
				end)
			end
		end
	end
	emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end