function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Emitter = ParticleEmitter(self.Start)
	for i = 1, 10 do
		local t = self.Emitter:Add("effects/yellowflare", self.Start)
		if t then
			t:SetVelocity(Vector(math.random(-40, 40), math.random(-40, 40), math.random(40, 55)))
			t:SetDieTime(1)
			t:SetStartAlpha(255)
			t:SetStartSize(1)
			t:SetEndSize(0)
			t:SetRoll(0)
			t:SetGravity(Vector(0, 0, -250))
			t:SetCollide(false)
			t:SetStartLength(0.1)
			t:SetEndLength(0.1)
			t:SetVelocityScale(true)
		end
	end
	for i = 1, 7 do
		local c = self.Emitter:Add("particle/smokesprites_000"..math.random(1, 9), self.Start)
		if c then
			c:SetDieTime(1)
			c:SetStartAlpha(35)
			c:SetEndAlpha(0)
			c:SetStartSize(3)
			c:SetEndSize(10)
			c:SetRoll(math.Rand(-40, 40))
			c:SetRollDelta(math.Rand(-0.6,0.6))
			c:SetAirResistance(150)
			c:SetVelocity(Vector(math.random(-25, 25), math.random(-25, 25), math.random(0, 30)))
			c:SetGravity(Vector(0, 0, -30))
			c:SetColor(125, 125, 125)
		end
	end
	for i = 1, 6 do
		local w = self.Emitter:Add("effects/fleck_tile"..math.random(1,2), self.Start + Vector(math.Rand(-1, 1), math.Rand(-1, 1), math.Rand(0, 1)))
		if w then
			w:SetVelocity(Vector(math.Rand(-50, 50), math.Rand(-50, 50), math.Rand(50, 75)))
			w:SetDieTime(1)
			w:SetStartAlpha(255)
			w:SetEndAlpha(0)
			w:SetStartSize(1)
			w:SetEndSize(0)
			w:SetRoll(math.Rand(0, 360))
			w:SetRollDelta(math.Rand(-5, 5))
			w:SetAirResistance(70)
			w:SetGravity(Vector(0, 0, -600))
			w:SetCollide(true)
			w:SetBounce(0.6)
			w:SetColor(180, 180, 180)
		end
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end