function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Emitter = ParticleEmitter(self.Start)
	for i = 1, 55 do
		local w = self.Emitter:Add("effects/fleck_tile"..math.random(1,2), self.Start)
		if w then
			w:SetVelocity(Vector(math.Rand(-100,100), math.Rand(-100,100), math.Rand(0,200)))
			w:SetDieTime(math.random(6,8))
			w:SetStartAlpha(255)
			w:SetEndAlpha(0)
			w:SetStartSize(1)
			w:SetEndSize(0)
			w:SetRoll(math.Rand(0, 360))
			w:SetRollDelta(math.Rand(-15, 15))
			w:SetAirResistance(50)
			w:SetColor(90,85,75)
			w:SetGravity(Vector(0,0,-550))
			w:SetCollide(true)
			w:SetBounce(0.6)
		end
	end
	for i = 1, 5 do
		local c = self.Emitter:Add("particle/particle_composite", self.Start)
		if c then
			c:SetDieTime(1)
			c:SetStartAlpha(100)
			c:SetEndAlpha(0)
			c:SetStartSize(10)
			c:SetEndSize(25)
			c:SetRoll(math.Rand(150, 360))
			c:SetRollDelta(math.Rand(-1, 1))
			c:SetAirResistance(150)
			c:SetVelocity(Vector(math.random(-15, 15), math.random(-15, 15), math.random(0, 35)))
			c:SetGravity(Vector(0, 0, -150))
			c:SetColor(142, 107, 72)
		end
	end
	for i = 1, 5 do
		local p = self.Emitter:Add("particle/smokesprites_000"..math.random(1, 9), self.Start)
		p:SetDieTime(math.Rand(1, 1.5))
		p:SetStartAlpha(math.Rand(100, 155))
		p:SetEndAlpha(0)
		p:SetStartSize(math.random(12, 15))
		p:SetEndSize(math.Rand(28, 35))
		p:SetRoll(math.Rand(-1, 1))
		p:SetRollDelta(math.Rand(-0.3, 0.3))
		p:SetGravity(Vector(0, 0, -15))
		p:SetVelocity(Vector(math.Rand(-5, 5), math.Rand(-5, 5), math.Rand(-1, 0)))
		p:SetColor(142, 107, 72)
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end