function EFFECT:Init(data)
	self.Start = data:GetOrigin()
	self.Emitter = ParticleEmitter(self.Start)
	for i = 1, 10 do
		local c = self.Emitter:Add("particle/particle_composite", self.Start)
		if c then
			c:SetDieTime(1)
			c:SetStartAlpha(100)
			c:SetEndAlpha(0)
			c:SetStartSize(3)
			c:SetEndSize(5)
			c:SetRoll(math.Rand(150, 360))
			c:SetRollDelta(math.Rand(-1, 1))
			c:SetAirResistance(150)
			c:SetVelocity(Vector(math.random(-13,13),math.random(-13,13),math.random(10,60)))
			c:SetGravity(Vector(0, 0, -100))
			c:SetColor(220,220,220)
		end
	end
	for i = 1, 50 do
		local d = self.Emitter:Add("effects/fleck_glass"..math.random(1,3), self.Start)
		if d then
			d:SetVelocity(Vector(math.random(-10,10),math.random(-10,10),math.random(0,40)))
			d:SetDieTime(math.random(3,5))
			d:SetStartAlpha(255)
			d:SetEndAlpha(0)
			d:SetStartSize(1)
			d:SetRoll(math.Rand(0, 360))
			d:SetRollDelta(math.Rand(-15, 15))
			d:SetAirResistance(-55)
			d:SetColor(200,200,200)
			d:SetGravity(Vector(0, 0, -100))
			d:SetCollide(true)
			d:SetBounce(0.15)
		end
	end
	for i = 1, 10 do
		local particle = self.Emitter:Add("particle/fire", self.Start)
		if particle then
			particle:SetVelocity(VectorRand() * math.Rand(50, 100))
			particle:SetLifeTime(0)
			particle:SetDieTime(5)
			particle:SetColor(255, 190, 0)
			particle:SetStartAlpha(255)
			particle:SetEndAlpha(0)
			particle:SetStartSize(3)
			particle:SetEndSize(0)
			particle:SetRoll(math.Rand(-360, 360))
			particle:SetRollDelta(math.Rand(-0.21, 0.21))
			particle:SetAirResistance(math.Rand(500, 800))
			particle:SetGravity(Vector(0, 0, -50))
			particle:SetCollide(true)
			particle:SetBounce(0.45)
		end
	end
	self.Emitter:Finish()
end

function EFFECT:Think()
	return false
end

function EFFECT:Render()
end