include("shared.lua")

surface.CreateFont("MG_CRATE72", {font = "Prototype", size = 72, weight = 700, blursize = 0, antialias = true, shadow = false})
surface.CreateFont("MG_CRATE60", {font = "Prototype", size = 60, weight = 700, blursize = 0, antialias = true, shadow = false})

local baseFont = "MG_CRATE72"
local ammoText = "MG_CRATE60"

function ENT:Initialize()
	surface.SetFont(baseFont)
	self.baseHorSize, self.vertFontSize = surface.GetTextSize(self.PrintName)
	self.baseHorSize = self.baseHorSize < 800 and 800 or self.baseHorSize
	self.baseHorSize = self.baseHorSize + 20
	self.halfBaseHorSize = self.baseHorSize * 0.5
	self.halfVertFontSize = self.vertFontSize * 0.5
end

local color = Color(160, 40, 40)
function ENT:getTopPartColor()
	return color
end

ENT.displayDistance = 256 * 256
ENT.upOffset = Vector(0, 0, 35)

local white, black = Color(255, 255, 255, 255), Color(0, 0, 0, 255)

if !draw.ShadowText then
	function draw.ShadowText(text, font, x, y, colortext, colorshadow, dist, xalign, yalign)
		draw.SimpleText(text, font, x + dist, y + dist, colorshadow, xalign, yalign)
		draw.SimpleText(text, font, x, y, colortext, xalign, yalign)
	end
end

function ENT:Draw()
	self:DrawModel()
end

local ply, max_ammo, ammo_name
function ENT:DrawTranslucent()
	ply = ply or LocalPlayer()
	if ply:EyePos():DistToSqr(self:GetPos()) > self.displayDistance then
		return
	end
	local eyeAng = EyeAngles()
	eyeAng.p = 0
	eyeAng.y = eyeAng.y - 90
	eyeAng.r = 90
	cam.Start3D2D(self:GetPos() + self.upOffset, eyeAng, 0.05)
		local r, g, b, a = self:getTopPartColor()
		surface.SetDrawColor(r, g, b, a)
		surface.DrawRect(-self.halfBaseHorSize, 0, self.baseHorSize, self.vertFontSize)
		draw.ShadowText(self.PrintName, baseFont, 0, self.halfVertFontSize, white, black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
		local wep = ply:GetActiveWeapon()
		local prim = wep.Primary
		local class = wep.ClassName
		if prim then
			if wep:GetPrimaryAmmoType() != -1 then
				max_ammo = prim.ClipSize * self:GetResupplyAmount()
				ammo_name = "Munition"
				surface.SetDrawColor(0, 0, 0, 150)
				surface.DrawRect(-self.halfBaseHorSize, self.vertFontSize, self.baseHorSize, self.vertFontSize * 2)
				draw.ShadowText("Maximal: "..max_ammo.." "..ammo_name, ammoText, 0, self.vertFontSize + self.halfVertFontSize, white, black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
				draw.ShadowText("+"..(prim.ClipSize_Orig or prim.ClipSize).." "..ammo_name.." pro Versorgung", ammoText, 0, self.vertFontSize * 2 + self.halfVertFontSize, white, black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			else
				surface.SetDrawColor(0, 0, 0, 150)
				surface.DrawRect(-self.halfBaseHorSize, self.vertFontSize, self.baseHorSize, self.vertFontSize)
				draw.ShadowText("Kann nicht versorgen", ammoText, 0, self.vertFontSize + self.halfVertFontSize, white, black, 2, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER)
			end
		end
	cam.End3D2D()
end

function ENT:Think()
end 