include("shared.lua")

local use_font = system.IsWindows() and "Tahoma" or "Verdana"
surface.CreateFont("mg_entfont", {font = use_font, size = 35, weight = 1000, blursize = 0, antialias = true, shadow = false})
surface.CreateFont("mg_entfont2", {font = use_font, size = 25, weight = 600, blursize = 0, antialias = true, shadow = false})

function ENT:Draw()
	self:DrawModel()
end

local local_ply, dist
local vector_1 = Vector(0, 0, 1)
function ENT:DrawTranslucent()
	local_ply = local_ply or LocalPlayer()
	dist = local_ply:EyePos():DistToSqr(self:GetPos())
	if dist > 40000 then return end
	local ang = self:GetAngles()	
	local pos = self:GetPos() + (vector_1 * (self:OBBMaxs().z + 5 + math.sin(SysTime() * 2)))
	ang:RotateAroundAxis(ang:Forward(), 90)
	ang:RotateAroundAxis(ang:Right(), -90)
	ang:RotateAroundAxis(ang:Up(), 0)
	cam.Start3D2D(pos, Angle(0, EyeAngles().y - 90, 90), 0.1)
		draw.SimpleTextOutlined(self.PrintName, "mg_entfont", 0, -70, Color(160, 40, 40), TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
		draw.SimpleTextOutlined("Drücke "..string.upper(input.LookupBinding("+use") or "[BENUTZEN]").." zum Energie tanken.", "mg_entfont2", 0, -40, color_white, TEXT_ALIGN_CENTER, TEXT_ALIGN_CENTER, 1, color_black)
	cam.End3D2D()
end